/*Table structure for table `activity_effect` */

DROP TABLE IF EXISTS `activity_effect`;

CREATE TABLE `activity_effect` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `activity_id` int(11) DEFAULT NULL COMMENT 'activity_log',
  `subject_id` int(11) DEFAULT NULL,
  `date_created` char(15) DEFAULT NULL,
  `active` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

/*Table structure for table `activity_log` */

DROP TABLE IF EXISTS `activity_log`;

CREATE TABLE `activity_log` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `appid` varchar(255) DEFAULT NULL,
  `type` varchar(255) DEFAULT NULL,
  `item_id` int(11) DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL COMMENT 'This is the user that is the "actor" in this activity',
  `group_id` int(11) DEFAULT '0',
  `session_user_id` int(11) DEFAULT NULL COMMENT 'This is the currently logged in user that triggered the activity .Useful for analytic purpose.',
  `only_notify_id` int(11) DEFAULT '0' COMMENT 'Restrict notification to only this user_id',
  `activity_date` varchar(255) DEFAULT NULL COMMENT 'readable version of the date created',
  `date_created` char(15) DEFAULT NULL,
  `active` tinyint(3) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

/*Table structure for table `activity_registry` */

DROP TABLE IF EXISTS `activity_registry`;

CREATE TABLE `activity_registry` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `appid` varchar(255) NOT NULL,
  `type` varchar(255) NOT NULL,
  `table_name` varchar(255) NOT NULL,
  `class_path` varchar(255) DEFAULT NULL,
  `class_name` varchar(255) DEFAULT NULL,
  `feed_format` text,
  `mail_format` text,
  `mail_subject` varchar(255) DEFAULT NULL,
  `sms_format` text,
  `feed_enabled` tinyint(1) DEFAULT '1',
  `mail_enabled` tinyint(1) DEFAULT '1',
  `sms_enabled` tinyint(1) DEFAULT '1',
  `date_created` char(15) DEFAULT NULL,
  `active` tinyint(1) DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

/*Table structure for table `analytics` */

DROP TABLE IF EXISTS `analytics`;

CREATE TABLE `analytics` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `session_id` char(30) DEFAULT NULL,
  `module` varchar(255) DEFAULT NULL,
  `controller` varchar(255) DEFAULT NULL,
  `action` varchar(255) DEFAULT NULL,
  `params` text,
  `date_created` char(15) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

/*Table structure for table `app_documents` */

DROP TABLE IF EXISTS `app_documents`;

CREATE TABLE `app_documents` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `appid` char(10) DEFAULT NULL,
  `item_id` int(10) NOT NULL,
  `content_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `date_created` char(15) DEFAULT NULL,
  `active` tinyint(1) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

/*Table structure for table `app_tags` */

DROP TABLE IF EXISTS `app_tags`;

CREATE TABLE `app_tags` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `appid` char(10) DEFAULT NULL,
  `item_id` int(10) NOT NULL,
  `tag_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `date_created` char(15) DEFAULT NULL,
  `active` tinyint(1) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

/*Table structure for table `bugs` */

DROP TABLE IF EXISTS `bugs`;

CREATE TABLE `bugs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `type` char(20) NOT NULL,
  `component` char(40) NOT NULL,
  `title` varchar(255) NOT NULL,
  `description` text NOT NULL,
  `date_created` char(15) DEFAULT NULL,
  `active` tinyint(3) unsigned DEFAULT NULL,
  `sent` tinyint(3) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Table structure for table `categorys` */

DROP TABLE IF EXISTS `categorys`;

CREATE TABLE `categorys` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL COMMENT 'user that created the category',
  `parent_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'category id to which it is a sub category of. parent categories have their parent_id as 0',
  `title` varchar(255) DEFAULT NULL,
  `description` text,
  `access_type` tinyint(4) NOT NULL DEFAULT '0' COMMENT '-1 for private, 0 for public, 1 for shared',
  `appid` varchar(30) NOT NULL DEFAULT 'cms' COMMENT 'App that is making use of category feature',
  `date_created` char(20) DEFAULT NULL,
  `active` tinyint(3) unsigned NOT NULL DEFAULT '1',
  `deleted` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT 'this indicates if a category has been permanently deleted from the recycle bin. A value of 1 means the category has been deleted  permanently, while 0 means the category is still in recycle bin',
  `is_folder` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `is_photo` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'indicates if it is an album folder',
  `is_site` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'indicates if it is a site category',
  `is_locked` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'indicates if a folder has been locked',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

/*Table structure for table `components` */

DROP TABLE IF EXISTS `components`;

CREATE TABLE `components` (
  `componentid` int(11) NOT NULL AUTO_INCREMENT,
  `componentform` int(11) DEFAULT NULL,
  `section` int(11) DEFAULT '0',
  `rowid` int(11) DEFAULT NULL,
  `componenttype` varchar(10) DEFAULT NULL,
  `componentlabel` varchar(250) DEFAULT NULL,
  `componentrequired` int(1) DEFAULT '0',
  `componentdefaultvalue` varchar(250) DEFAULT NULL,
  `frm_database` varchar(255) DEFAULT 'self',
  `frm_table` varchar(255) DEFAULT NULL,
  `frm_label_field` varchar(255) DEFAULT 'title',
  `frm_value_field` varchar(255) DEFAULT 'id',
  `frm_where_clause` text,
  `lastmodified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`componentid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

/*Table structure for table `contacts` */

DROP TABLE IF EXISTS `contacts`;

CREATE TABLE `contacts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `account_id` int(10) unsigned NOT NULL DEFAULT '0',
  `user_id` int(10) unsigned DEFAULT NULL,
  `full_name` varchar(255) DEFAULT NULL,
  `address` varchar(255) DEFAULT NULL,
  `company` varchar(255) DEFAULT NULL,
  `work_phone` varchar(255) DEFAULT NULL,
  `mobile_phone` varchar(255) DEFAULT NULL,
  `fax` varchar(255) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `website` varchar(255) DEFAULT NULL,
  `job_title` varchar(255) DEFAULT NULL,
  `twitter` varchar(255) DEFAULT NULL,
  `shared` tinyint(3) unsigned NOT NULL DEFAULT '1',
  `date_created` char(15) DEFAULT NULL,
  `last_updated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `active` tinyint(4) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Table structure for table `content` */

DROP TABLE IF EXISTS `content`;

CREATE TABLE `content` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `image_path` varchar(255) DEFAULT NULL,
  `summary` text,
  `body` text,
  `user_id` int(10) unsigned DEFAULT '0',
  `poll_id` int(10) unsigned DEFAULT '0',
  `url` varchar(255) NOT NULL DEFAULT '#',
  `keyword` varchar(255) DEFAULT '',
  `is_featured` tinyint(3) unsigned DEFAULT '0',
  `is_photo` tinyint(3) unsigned DEFAULT '0',
  `is_document` tinyint(3) unsigned DEFAULT '0',
  `date_created` char(15) DEFAULT NULL,
  `last_updated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `active` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `deleted` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT 'A value of 1 means the content has been deleted  permanently, while 0 means the content is still in recycle bin',
  `num_of_hits` int(10) unsigned NOT NULL DEFAULT '0',
  `rating` int(11) NOT NULL DEFAULT '0',
  `is_public` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `template` varchar(255) DEFAULT NULL COMMENT 'a default template is handled at code level',
  `is_page` tinyint(1) unsigned DEFAULT '0',
  `disable_comments` tinyint(1) unsigned DEFAULT '0',
  `is_site` tinyint(1) unsigned DEFAULT '0',
  `confirm_read` tinyint(1) unsigned DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

/*Table structure for table `content_approval` */

DROP TABLE IF EXISTS `content_approval`;

CREATE TABLE `content_approval` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `featured` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `advert` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `news` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `group_content` tinyint(3) NOT NULL DEFAULT '0' COMMENT 'this is ignored if group_id = 0',
  `group_id` int(10) unsigned NOT NULL DEFAULT '0',
  `active` tinyint(3) unsigned NOT NULL DEFAULT '1',
  `date_created` char(15) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Table structure for table `content_categorys` */

DROP TABLE IF EXISTS `content_categorys`;

CREATE TABLE `content_categorys` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL,
  `content_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL COMMENT 'user that assigned the content to the category',
  `date_created` char(20) DEFAULT NULL,
  `active` tinyint(4) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

/*Table structure for table `content_lock_history` */

DROP TABLE IF EXISTS `content_lock_history`;

CREATE TABLE `content_lock_history` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `content_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `lock` tinyint(1) unsigned NOT NULL,
  `active` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `date_created` char(15) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

/*Table structure for table `content_ratings` */

DROP TABLE IF EXISTS `content_ratings`;

CREATE TABLE `content_ratings` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `content_id` int(10) unsigned DEFAULT NULL,
  `user_id` int(10) unsigned DEFAULT NULL,
  `value` tinyint(4) DEFAULT NULL,
  `date_created` char(15) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Table structure for table `department` */

DROP TABLE IF EXISTS `department`;

CREATE TABLE `department` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `group_id` int(10) unsigned NOT NULL,
  `colour_code` varchar(255) DEFAULT NULL,
  `date_created` char(255) DEFAULT NULL,
  `active` tinyint(3) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

/*Table structure for table `discussion_groups` */

DROP TABLE IF EXISTS `discussion_groups`;

CREATE TABLE `discussion_groups` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `discussion_id` int(10) unsigned NOT NULL,
  `group_id` int(10) unsigned NOT NULL,
  `date_created` char(15) DEFAULT NULL,
  `active` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

/*Table structure for table `discussion_users` */

DROP TABLE IF EXISTS `discussion_users`;

CREATE TABLE `discussion_users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `discussion_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `date_created` char(15) NOT NULL,
  `active` tinyint(3) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

/*Table structure for table `discussions` */

DROP TABLE IF EXISTS `discussions`;

CREATE TABLE `discussions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL,
  `title` varchar(255) DEFAULT NULL,
  `creator_user_id` int(11) DEFAULT NULL,
  `date_created` char(15) DEFAULT NULL,
  `last_updated` char(15) DEFAULT NULL,
  `active` tinyint(4) unsigned DEFAULT NULL,
  `is_team` tinyint(3) unsigned DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

/*Table structure for table `document_checkout` */

DROP TABLE IF EXISTS `document_checkout`;

CREATE TABLE `document_checkout` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `document_id` int(10) unsigned NOT NULL,
  `check_out` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `check_in` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `user_id` int(10) unsigned NOT NULL,
  `version` char(10) DEFAULT NULL,
  `active` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `cancelled` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `date_created` char(15) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

/*Table structure for table `document_download_log` */

DROP TABLE IF EXISTS `document_download_log`;

CREATE TABLE `document_download_log` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `document_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `date_created` char(15) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

/*Table structure for table `document_history` */

DROP TABLE IF EXISTS `document_history`;

CREATE TABLE `document_history` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `content_id` int(10) unsigned NOT NULL,
  `file_name` varchar(255) NOT NULL,
  `file_type` char(5) DEFAULT NULL,
  `file_author` varchar(255) DEFAULT NULL,
  `file_size` int(10) unsigned DEFAULT NULL,
  `file_date_created` char(15) DEFAULT NULL,
  `file_content` longblob,
  `date_created` char(15) DEFAULT NULL,
  `last_modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

/*Table structure for table `document_password` */

DROP TABLE IF EXISTS `document_password`;

CREATE TABLE `document_password` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `document_id` int(10) unsigned NOT NULL,
  `password` varchar(100) DEFAULT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `active` tinyint(1) unsigned DEFAULT NULL,
  `date_created` char(15) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

/*Table structure for table `document_versions` */

DROP TABLE IF EXISTS `document_versions`;

CREATE TABLE `document_versions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `document_history_id` int(10) unsigned NOT NULL COMMENT 'a value of zero means this version has not been moved to the history and so is the most recent version. Note that the most recent version is not necessarily the current version since a user can set an older version as the current version',
  `document_id` int(10) unsigned NOT NULL,
  `version` char(10) NOT NULL,
  `notes` text,
  `user_id` int(10) unsigned NOT NULL,
  `current` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Is the current version?',
  `major` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT 'Is a major version',
  `active` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `date_created` char(15) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

/*Table structure for table `documents` */

DROP TABLE IF EXISTS `documents`;

CREATE TABLE `documents` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `content_id` int(10) NOT NULL,
  `file_name` varchar(255) NOT NULL,
  `file_type` char(5) DEFAULT NULL,
  `file_author` varchar(255) DEFAULT NULL,
  `file_size` int(10) unsigned DEFAULT NULL,
  `file_date_created` char(15) DEFAULT NULL,
  `file_content` longblob,
  `date_created` char(15) DEFAULT NULL,
  `last_modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

/*Table structure for table `email_documents` */

DROP TABLE IF EXISTS `email_documents`;

CREATE TABLE `email_documents` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `email_message_id` int(10) unsigned NOT NULL COMMENT 'foreign key to email_messages',
  `document_id` int(10) unsigned NOT NULL,
  `date_created` char(15) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Table structure for table `email_messages` */

DROP TABLE IF EXISTS `email_messages`;

CREATE TABLE `email_messages` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `user_email_id` int(10) unsigned DEFAULT NULL COMMENT 'foreign key the user_emails',
  `message` text,
  `mailbox` char(20) DEFAULT NULL,
  `message_id` varchar(255) DEFAULT NULL,
  `from_address` varchar(255) DEFAULT NULL,
  `to_address` varchar(255) DEFAULT NULL,
  `cc_address` varchar(255) DEFAULT NULL,
  `bcc_address` varchar(255) DEFAULT NULL,
  `reply_address` varchar(255) DEFAULT NULL,
  `sender_address` varchar(255) DEFAULT NULL,
  `return_address` varchar(255) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `in_reply_to` varchar(255) DEFAULT NULL,
  `followup_to` varchar(255) DEFAULT NULL,
  `is_recent` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `is_seen` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `is_flagged` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `is_deleted` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `is_draft` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `message_size` varchar(50) DEFAULT NULL,
  `message_date` varchar(50) DEFAULT NULL,
  `date_created` char(15) DEFAULT NULL,
  `active` tinyint(1) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Table structure for table `event_contents` */

DROP TABLE IF EXISTS `event_contents`;

CREATE TABLE `event_contents` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `event_id` int(10) unsigned NOT NULL,
  `content_id` int(10) unsigned NOT NULL,
  `date_created` char(15) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Table structure for table `event_status` */

DROP TABLE IF EXISTS `event_status`;

CREATE TABLE `event_status` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `event_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `status` tinyint(4) NOT NULL DEFAULT '0',
  `date_created` char(15) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

/*Table structure for table `events` */

DROP TABLE IF EXISTS `events`;

CREATE TABLE `events` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `title` varchar(255) DEFAULT NULL,
  `summary` varchar(255) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `location_id` int(10) unsigned DEFAULT NULL,
  `venue` varchar(255) DEFAULT NULL,
  `start_date` char(11) DEFAULT NULL,
  `start_time` varchar(255) DEFAULT '9am',
  `end_date` char(11) DEFAULT NULL,
  `end_time` varchar(255) DEFAULT '5pm',
  `start_timestamp` char(15) DEFAULT NULL COMMENT 'unix timestamp of the start date',
  `description` longtext,
  `is_open` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `work_related` tinyint(3) unsigned NOT NULL DEFAULT '1',
  `open_guest_list` tinyint(3) unsigned NOT NULL DEFAULT '1',
  `restrict_content_access` tinyint(4) unsigned NOT NULL DEFAULT '0',
  `disable_content_access` tinyint(4) unsigned NOT NULL DEFAULT '0',
  `logo` varchar(255) DEFAULT NULL,
  `date_created` char(15) DEFAULT NULL,
  `last_updated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `active` tinyint(4) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

/*Table structure for table `facts` */

DROP TABLE IF EXISTS `facts`;

CREATE TABLE `facts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `url` varchar(255) DEFAULT NULL,
  `user_id` int(10) unsigned DEFAULT NULL,
  `date_created` char(255) DEFAULT NULL,
  `active` tinyint(3) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Table structure for table `featured_user` */

DROP TABLE IF EXISTS `featured_user`;

CREATE TABLE `featured_user` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `comment` text NOT NULL,
  `expires` char(15) DEFAULT NULL,
  `date_created` char(15) NOT NULL,
  `active` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

/*Table structure for table `forms` */

DROP TABLE IF EXISTS `forms`;

CREATE TABLE `forms` (
  `formid` int(11) NOT NULL AUTO_INCREMENT,
  `formName` varchar(50) DEFAULT NULL,
  `formDescription` text,
  `createdBy` varchar(50) DEFAULT NULL,
  `lastModified` datetime DEFAULT NULL,
  `active` int(1) DEFAULT '1',
  `formCode` varchar(200) DEFAULT NULL,
  PRIMARY KEY (`formid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

/*Table structure for table `group_apps` */

DROP TABLE IF EXISTS `group_apps`;

CREATE TABLE `group_apps` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `group_id` int(11) DEFAULT NULL,
  `appid` varchar(255) DEFAULT NULL,
  `date_created` char(15) DEFAULT NULL,
  `active` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

/*Table structure for table `group_categorys` */

DROP TABLE IF EXISTS `group_categorys`;

CREATE TABLE `group_categorys` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `category_id` int(10) unsigned NOT NULL,
  `group_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL COMMENT 'user that assigned the category to the group',
  `date_created` char(20) DEFAULT NULL,
  `active` tinyint(4) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

/*Table structure for table `group_contents` */

DROP TABLE IF EXISTS `group_contents`;

CREATE TABLE `group_contents` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `group_id` int(10) unsigned NOT NULL,
  `content_id` int(10) unsigned NOT NULL,
  `task_id` int(10) unsigned DEFAULT '0',
  `active` tinyint(3) unsigned NOT NULL DEFAULT '1',
  `date_created` char(15) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

/*Table structure for table `group_settings` */

DROP TABLE IF EXISTS `group_settings`;

CREATE TABLE `group_settings` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `group_id` int(10) unsigned NOT NULL,
  `content_requires_approval` tinyint(4) NOT NULL DEFAULT '1',
  `featured` tinyint(4) NOT NULL DEFAULT '0',
  `advert` tinyint(4) NOT NULL DEFAULT '0',
  `news` tinyint(4) NOT NULL DEFAULT '0',
  `date_created` char(15) NOT NULL,
  `last_updated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Table structure for table `groups` */

DROP TABLE IF EXISTS `groups`;

CREATE TABLE `groups` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `title` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `parent_id` int(11) unsigned DEFAULT '0',
  `is_location` tinyint(4) DEFAULT '0',
  `is_department` tinyint(4) DEFAULT '0',
  `is_role` tinyint(4) DEFAULT '0',
  `is_default` tinyint(4) DEFAULT '0',
  `is_team` tinyint(4) DEFAULT '0',
  `team_template_id` int(11) unsigned DEFAULT '0',
  `active` tinyint(4) NOT NULL DEFAULT '1',
  `date_created` char(15) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

/*Table structure for table `invited_users` */

DROP TABLE IF EXISTS `invited_users`;

CREATE TABLE `invited_users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `activity_id` int(11) DEFAULT NULL,
  `team_id` int(11) DEFAULT NULL,
  `date_created` char(15) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=dec8;

/*Table structure for table `links` */

DROP TABLE IF EXISTS `links`;

CREATE TABLE `links` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL DEFAULT ' ',
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `url` varchar(255) DEFAULT '#',
  `description` text,
  `target` varchar(255) NOT NULL DEFAULT '_blank',
  `active` char(1) NOT NULL DEFAULT '0',
  `date_created` char(15) NOT NULL,
  `last_updated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `rating` int(11) NOT NULL DEFAULT '0',
  `is_site` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

/*Table structure for table `locations` */

DROP TABLE IF EXISTS `locations`;

CREATE TABLE `locations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `group_id` int(10) unsigned NOT NULL,
  `date_created` char(15) DEFAULT NULL,
  `active` tinyint(3) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

/*Table structure for table `logs` */

DROP TABLE IF EXISTS `logs`;

CREATE TABLE `logs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `priority` varchar(255) DEFAULT NULL,
  `message` text,
  `timestamp` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

/*Table structure for table `mail_queue` */

DROP TABLE IF EXISTS `mail_queue`;

CREATE TABLE `mail_queue` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `activity_id` int(10) unsigned DEFAULT '0',
  `subject` text NOT NULL,
  `body` text NOT NULL,
  `from` text NOT NULL,
  `to` text NOT NULL,
  `cc` text,
  `bcc` text,
  `attachment` text,
  `sent` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `error_count` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `date_created` char(15) NOT NULL,
  `date_sent` char(15) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

/*Table structure for table `menu` */

DROP TABLE IF EXISTS `menu`;

CREATE TABLE `menu` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL DEFAULT ' ',
  `parent_id` int(10) unsigned NOT NULL DEFAULT '0',
  `content_id` int(10) unsigned NOT NULL DEFAULT '0',
  `redirect_id` int(11) DEFAULT NULL COMMENT 'redirect this menu to another menu',
  `menu_order` int(11) NOT NULL DEFAULT '0',
  `url` text,
  `description` text,
  `target` varchar(255) NOT NULL DEFAULT '_self',
  `resource` varchar(255) DEFAULT NULL,
  `active` char(1) NOT NULL DEFAULT '0',
  `date_created` char(15) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

/*Table structure for table `note_groups` */

DROP TABLE IF EXISTS `note_groups`;

CREATE TABLE `note_groups` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `note_id` int(10) unsigned NOT NULL,
  `group_id` int(10) unsigned NOT NULL,
  `date_created` char(15) DEFAULT NULL,
  `active` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

/*Table structure for table `notes` */

DROP TABLE IF EXISTS `notes`;

CREATE TABLE `notes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `body` text,
  `creator_user_id` int(11) DEFAULT NULL,
  `date_created` char(15) DEFAULT NULL,
  `last_updated` char(15) DEFAULT NULL,
  `active` tinyint(4) unsigned DEFAULT NULL,
  `is_team` tinyint(3) unsigned DEFAULT '0',
  `team_edit` tinyint(3) unsigned DEFAULT '1' COMMENT 'if team members can edit the note',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

/*Table structure for table `options` */

DROP TABLE IF EXISTS `options`;

CREATE TABLE `options` (
  `optionid` int(11) NOT NULL AUTO_INCREMENT,
  `componentid` int(11) DEFAULT NULL,
  `options` text,
  `lastmodified` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`optionid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AVG_ROW_LENGTH=48 ROW_FORMAT=DYNAMIC;

/*Table structure for table `out_of_office` */

DROP TABLE IF EXISTS `out_of_office`;

CREATE TABLE `out_of_office` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `proxy_id` int(11) NOT NULL COMMENT 'this is the person that will handle you tasks in your absence',
  `summary` varchar(255) DEFAULT NULL,
  `leave_date` char(15) DEFAULT NULL,
  `return_date` char(15) DEFAULT NULL,
  `active` tinyint(3) unsigned DEFAULT NULL,
  `date_created` char(15) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

/*Table structure for table `p2_users` */

DROP TABLE IF EXISTS `p2_users`;

CREATE TABLE `p2_users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `identity` varchar(255) NOT NULL,
  `credential` varchar(255) NOT NULL,
  `date_created` char(255) DEFAULT NULL,
  `last_updated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

/*Table structure for table `pages` */

DROP TABLE IF EXISTS `pages`;

CREATE TABLE `pages` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `content_id` int(11) NOT NULL,
  `title` varchar(255) NOT NULL,
  `parent_id` int(10) unsigned NOT NULL DEFAULT '0',
  `order` smallint(6) NOT NULL DEFAULT '1',
  `url` text COMMENT 'this is set for external pages or apps.',
  `date_created` char(15) DEFAULT NULL,
  `active` tinyint(1) NOT NULL DEFAULT '1',
  `is_site` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

/*Table structure for table `poll_options` */

DROP TABLE IF EXISTS `poll_options`;

CREATE TABLE `poll_options` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `poll_id` int(10) unsigned NOT NULL,
  `label` varchar(255) NOT NULL,
  `num_votes` int(10) unsigned NOT NULL DEFAULT '0',
  `date_created` char(15) NOT NULL,
  `active` tinyint(3) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

/*Table structure for table `polls` */

DROP TABLE IF EXISTS `polls`;

CREATE TABLE `polls` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `user_id` int(10) unsigned DEFAULT NULL,
  `multiple_answers` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `is_public` tinyint(3) unsigned NOT NULL DEFAULT '1',
  `end_date` char(15) NOT NULL DEFAULT '0',
  `randomise_options` tinyint(15) unsigned DEFAULT '0',
  `active` tinyint(3) unsigned NOT NULL DEFAULT '1',
  `date_created` char(15) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

/*Table structure for table `privileges` */

DROP TABLE IF EXISTS `privileges`;

CREATE TABLE `privileges` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `privilege` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

/*Table structure for table `profile_pics` */

DROP TABLE IF EXISTS `profile_pics`;

CREATE TABLE `profile_pics` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `image_path` varchar(255) NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `content_id` int(11) NOT NULL DEFAULT '0' COMMENT 'profile picture must first be inserted into content table',
  `date_created` char(15) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

/*Table structure for table `resources` */

DROP TABLE IF EXISTS `resources`;

CREATE TABLE `resources` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'not used at all. just for indexing purpose',
  `resource` varchar(255) DEFAULT NULL,
  `parent` varchar(255) DEFAULT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

/*Table structure for table `roles` */

DROP TABLE IF EXISTS `roles`;

CREATE TABLE `roles` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `group_id` int(10) unsigned NOT NULL,
  `date_created` char(15) DEFAULT NULL,
  `active` tinyint(3) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

/*Table structure for table `rss` */

DROP TABLE IF EXISTS `rss`;

CREATE TABLE `rss` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `logo` varchar(255) DEFAULT NULL,
  `url` varchar(255) NOT NULL,
  `last_updated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `date_created` char(15) NOT NULL,
  `active` tinyint(3) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

/*Table structure for table `rss_content` */

DROP TABLE IF EXISTS `rss_content`;

CREATE TABLE `rss_content` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `rss_id` int(10) unsigned NOT NULL,
  `rss_item_id` varchar(255) NOT NULL,
  `author` varchar(255) NOT NULL,
  `content_id` int(10) unsigned NOT NULL,
  `date_created` char(15) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Table structure for table `rules` */

DROP TABLE IF EXISTS `rules`;

CREATE TABLE `rules` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `role_id` int(11) NOT NULL,
  `resource` varchar(255) NOT NULL,
  `privilege` varchar(255) NOT NULL,
  `allow` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `created_by` varchar(255) DEFAULT NULL,
  `last_updated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `date_created` char(15) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

/*Table structure for table `sections` */

DROP TABLE IF EXISTS `sections`;

CREATE TABLE `sections` (
  `sectionid` int(11) NOT NULL AUTO_INCREMENT,
  `formid` int(11) DEFAULT NULL,
  `formposition` int(11) DEFAULT NULL,
  `displayname` varchar(234) DEFAULT NULL,
  `sla` int(11) DEFAULT NULL,
  `sla_email` varchar(230) DEFAULT NULL,
  `userselect` int(1) DEFAULT NULL,
  `lastmodified` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `approval` int(1) DEFAULT NULL,
  PRIMARY KEY (`sectionid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

/*Table structure for table `secure_codes` */

DROP TABLE IF EXISTS `secure_codes`;

CREATE TABLE `secure_codes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `activity_id` int(11) DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  `secure_code` varchar(255) DEFAULT NULL,
  `date_created` char(15) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

/*Table structure for table `shared_categorys` */

DROP TABLE IF EXISTS `shared_categorys`;

CREATE TABLE `shared_categorys` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `category_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `sharer_id` int(10) unsigned NOT NULL COMMENT 'user that assigned the category to the user',
  `date_created` char(20) DEFAULT NULL,
  `active` tinyint(1) unsigned DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

/*Table structure for table `shared_contents` */

DROP TABLE IF EXISTS `shared_contents`;

CREATE TABLE `shared_contents` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `content_id` int(10) unsigned NOT NULL DEFAULT '0',
  `sharer_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'this is not the owner of the content, but the user sharing the content',
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `date_created` char(15) NOT NULL,
  `active` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

/*Table structure for table `site_admins` */

DROP TABLE IF EXISTS `site_admins`;

CREATE TABLE `site_admins` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `site_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `active` tinyint(4) DEFAULT NULL,
  `date_created` char(15) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

/*Table structure for table `site_categorys` */

DROP TABLE IF EXISTS `site_categorys`;

CREATE TABLE `site_categorys` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `site_id` int(10) unsigned NOT NULL,
  `category_id` int(10) unsigned NOT NULL,
  `active` tinyint(4) DEFAULT NULL,
  `date_created` char(15) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

/*Table structure for table `site_contents` */

DROP TABLE IF EXISTS `site_contents`;

CREATE TABLE `site_contents` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `site_id` int(10) unsigned NOT NULL,
  `content_id` int(10) unsigned NOT NULL,
  `active` tinyint(4) DEFAULT NULL,
  `date_created` char(15) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

/*Table structure for table `site_links` */

DROP TABLE IF EXISTS `site_links`;

CREATE TABLE `site_links` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `site_id` int(11) NOT NULL,
  `link_id` int(11) NOT NULL,
  `date_created` char(15) DEFAULT NULL,
  `active` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

/*Table structure for table `site_pages` */

DROP TABLE IF EXISTS `site_pages`;

CREATE TABLE `site_pages` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `site_id` int(10) unsigned NOT NULL,
  `page_id` int(10) unsigned NOT NULL,
  `active` tinyint(4) DEFAULT NULL,
  `date_created` char(15) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

/*Table structure for table `sites` */

DROP TABLE IF EXISTS `sites`;

CREATE TABLE `sites` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `description` text,
  `welcome_page_id` int(11) DEFAULT '0',
  `resource_folder_id` int(11) DEFAULT '0',
  `date_created` char(15) DEFAULT NULL,
  `active` tinyint(1) DEFAULT NULL,
  `publish` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

/*Table structure for table `state_fields` */

DROP TABLE IF EXISTS `state_fields`;

CREATE TABLE `state_fields` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `state_id` int(10) unsigned DEFAULT NULL COMMENT 'remember that the state id is binded to the process id',
  `field_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 CHECKSUM=1;

/*Table structure for table `status_messages` */

DROP TABLE IF EXISTS `status_messages`;

CREATE TABLE `status_messages` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `message` varchar(255) NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `content_id` int(10) unsigned NOT NULL DEFAULT '0',
  `group_id` int(10) unsigned NOT NULL DEFAULT '0',
  `date_created` char(15) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

/*Table structure for table `tags` */

DROP TABLE IF EXISTS `tags`;

CREATE TABLE `tags` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `date_created` char(20) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

/*Table structure for table `task_content` */

DROP TABLE IF EXISTS `task_content`;

CREATE TABLE `task_content` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `task_id` int(10) unsigned NOT NULL,
  `content_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL COMMENT 'user who attached content to task, this should either be the task creator or task doer, but not necessarily the content creator',
  `date_created` char(15) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Table structure for table `task_groups` */

DROP TABLE IF EXISTS `task_groups`;

CREATE TABLE `task_groups` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `task_id` int(10) unsigned DEFAULT NULL,
  `group_id` int(10) unsigned DEFAULT NULL,
  `date_created` char(15) DEFAULT NULL,
  `active` tinyint(3) unsigned DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

/*Table structure for table `task_helpdesk` */

DROP TABLE IF EXISTS `task_helpdesk`;

CREATE TABLE `task_helpdesk` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `task_id` int(10) unsigned NOT NULL,
  `request_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `date_created` char(20) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Table structure for table `task_opportunity` */

DROP TABLE IF EXISTS `task_opportunity`;

CREATE TABLE `task_opportunity` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `task_id` int(10) unsigned NOT NULL,
  `opportunity_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `date_created` char(20) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Table structure for table `task_proxy` */

DROP TABLE IF EXISTS `task_proxy`;

CREATE TABLE `task_proxy` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `task_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `proxy_id` int(10) unsigned NOT NULL,
  `out_of_office_id` int(10) unsigned NOT NULL,
  `date_created` char(15) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Table structure for table `task_transfer` */

DROP TABLE IF EXISTS `task_transfer`;

CREATE TABLE `task_transfer` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `task_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL COMMENT 'the person that did the transfer',
  `from_user_id` int(10) unsigned NOT NULL,
  `to_user_id` int(10) unsigned NOT NULL,
  `reason` varchar(255) DEFAULT NULL,
  `date_created` char(15) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

/*Table structure for table `task_users` */

DROP TABLE IF EXISTS `task_users`;

CREATE TABLE `task_users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `task_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `date_created` char(15) NOT NULL,
  `is_proxy` tinyint(3) unsigned DEFAULT '0',
  `is_transfer` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `is_active` tinyint(3) DEFAULT '0' COMMENT 'the user actively handling the task. Others are spectators',
  `active` tinyint(3) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

/*Table structure for table `tasks` */

DROP TABLE IF EXISTS `tasks`;

CREATE TABLE `tasks` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `type` char(20) DEFAULT NULL COMMENT 'some application defined types',
  `creator_user_id` int(10) unsigned DEFAULT '0',
  `creator_group_id` int(10) unsigned DEFAULT '0',
  `title` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `duration` int(10) unsigned DEFAULT NULL COMMENT 'number of hours. 24hrs = 1day',
  `start_time` char(15) DEFAULT NULL COMMENT 'unix timestamp ',
  `end_time` char(15) DEFAULT NULL COMMENT 'unix timestamp ',
  `complete_time` char(15) DEFAULT NULL COMMENT 'unix timestamp',
  `alert_type` smallint(20) DEFAULT '1' COMMENT '0, no alert. 1 notification and email, 2 ...i think this should be based on priority',
  `priority` smallint(20) DEFAULT '2' COMMENT '2 means normal priority, 1 is low priority',
  `is_transferable` tinyint(3) unsigned DEFAULT '1',
  `date_created` char(15) DEFAULT NULL COMMENT 'this will typically be the same as start time.',
  `last_updated` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `active` tinyint(3) unsigned DEFAULT '1',
  `status` tinyint(3) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

/*Table structure for table `team_templates` */

DROP TABLE IF EXISTS `team_templates`;

CREATE TABLE `team_templates` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `description` text,
  `date_created` char(20) DEFAULT NULL,
  `active` tinyint(1) DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

/*Table structure for table `team_templates_data` */

DROP TABLE IF EXISTS `team_templates_data`;

CREATE TABLE `team_templates_data` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `template_id` int(11) DEFAULT NULL,
  `appid` varchar(10) DEFAULT NULL,
  `title` varchar(255) DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  `date_created` char(20) DEFAULT NULL,
  `active` tinyint(1) DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

/*Table structure for table `user_activities` */

DROP TABLE IF EXISTS `user_activities`;

CREATE TABLE `user_activities` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `type` smallint(5) unsigned DEFAULT NULL,
  `activity_id` int(10) unsigned NOT NULL DEFAULT '0',
  `url` varchar(255) DEFAULT NULL,
  `subject_id` int(11) NOT NULL DEFAULT '0',
  `date_created` char(15) NOT NULL,
  `active` tinyint(1) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

/*Table structure for table `user_comments` */

DROP TABLE IF EXISTS `user_comments`;

CREATE TABLE `user_comments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `appid` varchar(255) NOT NULL DEFAULT '0' COMMENT 'this is not the actual activity id, but the autoincrement id of the activities table',
  `item_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'a comment is either binded to an activity or a content',
  `message` text NOT NULL,
  `user_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'id of user who made the comment',
  `date_created` char(15) NOT NULL,
  `active` tinyint(1) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

/*Table structure for table `user_details` */

DROP TABLE IF EXISTS `user_details`;

CREATE TABLE `user_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `boss_id` int(11) DEFAULT '0',
  `email` varchar(255) NOT NULL,
  `username` varchar(255) DEFAULT NULL,
  `password` varchar(255) DEFAULT NULL,
  `first_name` varchar(255) DEFAULT NULL,
  `last_name` varchar(255) DEFAULT NULL,
  `work_phone` char(20) DEFAULT NULL,
  `mobile_phone` char(20) DEFAULT NULL,
  `address` varchar(255) DEFAULT NULL,
  `birth_day` smallint(10) unsigned DEFAULT NULL,
  `birth_month` smallint(10) unsigned DEFAULT NULL,
  `birth_year` smallint(5) unsigned DEFAULT NULL,
  `gender` char(7) DEFAULT NULL,
  `location_id` int(11) NOT NULL DEFAULT '0',
  `job_title` varchar(255) DEFAULT NULL,
  `company` varchar(255) DEFAULT NULL,
  `department_id` int(10) unsigned NOT NULL DEFAULT '0',
  `job_description` text,
  `skills` text,
  `website` varchar(255) DEFAULT NULL,
  `profile_picture_id` int(10) unsigned DEFAULT '0',
  `percentage_complete` int(10) unsigned NOT NULL DEFAULT '0',
  `date_created` char(15) DEFAULT NULL,
  `last_updated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `active` tinyint(3) NOT NULL DEFAULT '1',
  `out_of_office` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `is_external` tinyint(3) DEFAULT '0',
  `last_seen` char(15) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

/*Table structure for table `user_emails` */

DROP TABLE IF EXISTS `user_emails`;

CREATE TABLE `user_emails` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `password` varchar(255) DEFAULT NULL,
  `server` varchar(255) DEFAULT NULL,
  `port` char(10) DEFAULT NULL,
  `ssl` char(4) DEFAULT NULL,
  `date_created` char(15) DEFAULT NULL,
  `active` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Table structure for table `user_events` */

DROP TABLE IF EXISTS `user_events`;

CREATE TABLE `user_events` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `event_id` int(10) unsigned NOT NULL,
  `user_id` int(11) DEFAULT NULL COMMENT 'user who invited. usually the owner of the event',
  `invitee_id` int(10) unsigned NOT NULL COMMENT 'user who is invited',
  `date_created` char(15) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

/*Table structure for table `user_groups` */

DROP TABLE IF EXISTS `user_groups`;

CREATE TABLE `user_groups` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `group_id` int(10) unsigned DEFAULT NULL,
  `date_created` char(15) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

/*Table structure for table `user_process_history` */

DROP TABLE IF EXISTS `user_process_history`;

CREATE TABLE `user_process_history` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_process_id` int(10) unsigned DEFAULT NULL,
  `user_id` int(10) unsigned DEFAULT NULL,
  `type` tinyint(3) unsigned DEFAULT NULL,
  `old_value` text,
  `new_value` text,
  `date_created` char(15) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

/*Table structure for table `user_process_reject` */

DROP TABLE IF EXISTS `user_process_reject`;

CREATE TABLE `user_process_reject` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `user_process_id` int(10) unsigned NOT NULL,
  `comment` text NOT NULL,
  `date_created` char(15) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Table structure for table `user_processes` */

DROP TABLE IF EXISTS `user_processes`;

CREATE TABLE `user_processes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `process_id` int(10) unsigned NOT NULL,
  `state_id` int(10) unsigned NOT NULL,
  `form_id` int(10) unsigned NOT NULL,
  `task_id` int(10) unsigned NOT NULL,
  `date_created` char(15) NOT NULL,
  `completed` tinyint(4) NOT NULL DEFAULT '0',
  `rejected` tinyint(4) NOT NULL DEFAULT '0',
  `active` tinyint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

/*Table structure for table `user_ratings` */

DROP TABLE IF EXISTS `user_ratings`;

CREATE TABLE `user_ratings` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `score` tinyint(3) NOT NULL DEFAULT '0',
  `user_id` int(10) unsigned NOT NULL,
  `type` char(30) NOT NULL DEFAULT 'LINK' COMMENT 'share the same type as user_tags',
  `item_id` int(10) unsigned NOT NULL COMMENT 'id of whatever item is being tagged',
  `date_created` char(20) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Table structure for table `user_search` */

DROP TABLE IF EXISTS `user_search`;

CREATE TABLE `user_search` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `query` varchar(255) DEFAULT NULL,
  `hit_count` int(10) unsigned NOT NULL DEFAULT '0',
  `date_created` char(15) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

/*Table structure for table `user_settings` */

DROP TABLE IF EXISTS `user_settings`;

CREATE TABLE `user_settings` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `locale` char(10) NOT NULL DEFAULT 'en_GB',
  `widgets` text NOT NULL,
  `blocked_users` text NOT NULL,
  `last_updated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `date_created` char(15) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

/*Table structure for table `user_tags` */

DROP TABLE IF EXISTS `user_tags`;

CREATE TABLE `user_tags` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `tag_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `type` char(30) NOT NULL DEFAULT 'LINK',
  `item_id` int(10) unsigned NOT NULL COMMENT 'id of whatever item is being tagged',
  `date_created` char(20) DEFAULT NULL,
  `active` tinyint(1) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Table structure for table `votes_users` */

DROP TABLE IF EXISTS `votes_users`;

CREATE TABLE `votes_users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `poll_id` int(11) unsigned DEFAULT NULL,
  `poll_option_id` int(11) unsigned DEFAULT NULL,
  `user_id` int(11) unsigned DEFAULT NULL,
  `date_created` char(15) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

/*Table structure for table `wf_cash_advance_form` */

DROP TABLE IF EXISTS `wf_cash_advance_form`;

CREATE TABLE `wf_cash_advance_form` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `amount` varchar(255) DEFAULT NULL,
  `purpose` text,
  `date` varchar(255) DEFAULT NULL,
  `date_to` varchar(255) DEFAULT NULL,
  `signature` varchar(255) DEFAULT NULL,
  `signature_2` varchar(255) DEFAULT NULL,
  `amount_issued` varchar(255) DEFAULT NULL,
  `date_issued` varchar(255) DEFAULT NULL,
  `date_created` char(15) DEFAULT NULL,
  `last_updated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

/*Table structure for table `wf_cash_reimbursement_request` */

DROP TABLE IF EXISTS `wf_cash_reimbursement_request`;

CREATE TABLE `wf_cash_reimbursement_request` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `amount` varchar(255) DEFAULT NULL,
  `description` text,
  `account` varchar(255) DEFAULT NULL,
  `signature` varchar(255) DEFAULT NULL,
  `signature_2` varchar(255) DEFAULT NULL,
  `amount_approved` varchar(255) DEFAULT NULL,
  `date` varchar(255) DEFAULT NULL,
  `date_created` char(15) DEFAULT NULL,
  `last_updated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

/*Table structure for table `wf_leave_request_form` */

DROP TABLE IF EXISTS `wf_leave_request_form`;

CREATE TABLE `wf_leave_request_form` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `type` varchar(255) DEFAULT NULL,
  `number` varchar(255) DEFAULT NULL,
  `start` varchar(255) DEFAULT NULL,
  `end` varchar(255) DEFAULT NULL,
  `contact` varchar(255) DEFAULT NULL,
  `contact_address` text,
  `notes` text,
  `signature` varchar(255) DEFAULT NULL,
  `signature_2` varchar(255) DEFAULT NULL,
  `date_created` char(15) DEFAULT NULL,
  `last_updated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

/*Table structure for table `wf_materials_requisition_form` */

DROP TABLE IF EXISTS `wf_materials_requisition_form`;

CREATE TABLE `wf_materials_requisition_form` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `item` varchar(255) DEFAULT NULL,
  `description` text,
  `quantity` varchar(255) DEFAULT NULL,
  `signature` varchar(255) DEFAULT NULL,
  `signature_2` varchar(255) DEFAULT NULL,
  `quantity_issued` varchar(255) DEFAULT NULL,
  `date` varchar(255) DEFAULT NULL,
  `date_created` char(15) DEFAULT NULL,
  `last_updated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Table structure for table `wf_meeting_room_request` */

DROP TABLE IF EXISTS `wf_meeting_room_request`;

CREATE TABLE `wf_meeting_room_request` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `room` varchar(255) DEFAULT NULL,
  `purpose` text,
  `date` varchar(255) DEFAULT NULL,
  `time` varchar(255) DEFAULT NULL,
  `duration` varchar(255) DEFAULT NULL,
  `recurring` varchar(255) DEFAULT NULL,
  `additional` text,
  `signature` varchar(255) DEFAULT NULL,
  `date_created` char(15) DEFAULT NULL,
  `last_updated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

/*Table structure for table `wf_purchase_request_form` */

DROP TABLE IF EXISTS `wf_purchase_request_form`;

CREATE TABLE `wf_purchase_request_form` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `item` varchar(255) DEFAULT NULL,
  `specifications` text,
  `purpose` text,
  `quantity` varchar(255) DEFAULT NULL,
  `price` varchar(255) DEFAULT NULL,
  `required` varchar(255) DEFAULT NULL,
  `suggested` text,
  `notes` text,
  `signature` varchar(255) DEFAULT NULL,
  `signature_2` varchar(255) DEFAULT NULL,
  `date_created` char(15) DEFAULT NULL,
  `last_updated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Table structure for table `wf_test_no_approval` */

DROP TABLE IF EXISTS `wf_test_no_approval`;

CREATE TABLE `wf_test_no_approval` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `date` varchar(255) DEFAULT NULL,
  `alternative` varchar(255) DEFAULT NULL,
  `signature` varchar(255) DEFAULT NULL,
  `finance` varchar(255) DEFAULT NULL,
  `date_created` char(15) DEFAULT NULL,
  `last_updated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

/*Table structure for table `wf_travel_request_form` */

DROP TABLE IF EXISTS `wf_travel_request_form`;

CREATE TABLE `wf_travel_request_form` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `department` varchar(255) DEFAULT NULL,
  `type` varchar(255) DEFAULT NULL,
  `purpose` text,
  `destination` varchar(255) DEFAULT NULL,
  `departure` varchar(255) DEFAULT NULL,
  `departure_time` varchar(255) DEFAULT NULL,
  `arrival` varchar(255) DEFAULT NULL,
  `arrival_time` varchar(255) DEFAULT NULL,
  `means` varchar(255) DEFAULT NULL,
  `preferences` varchar(255) DEFAULT NULL,
  `notes` text,
  `signature` varchar(255) DEFAULT NULL,
  `signature_2` varchar(255) DEFAULT NULL,
  `accommodation` varchar(255) DEFAULT NULL,
  `flight` varchar(255) DEFAULT NULL,
  `road` varchar(255) DEFAULT NULL,
  `other` varchar(255) DEFAULT NULL,
  `date_created` char(15) DEFAULT NULL,
  `last_updated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Table structure for table `wf_visitors_form` */

DROP TABLE IF EXISTS `wf_visitors_form`;

CREATE TABLE `wf_visitors_form` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `visitor` varchar(255) DEFAULT NULL,
  `visitor_type` varchar(255) DEFAULT NULL,
  `official` varchar(255) DEFAULT NULL,
  `signature` varchar(255) DEFAULT NULL,
  `date_created` char(15) DEFAULT NULL,
  `last_updated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

/*Table structure for table `wgt_precuriotweet` */

DROP TABLE IF EXISTS `wgt_precuriotweet`;

CREATE TABLE `wgt_precuriotweet` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `username` varchar(255) DEFAULT NULL,
  `twitter_user_id` int(10) unsigned DEFAULT NULL,
  `token` text,
  `date_created` char(15) DEFAULT NULL,
  `last_updated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Table structure for table `wgt_stock_ticker` */

DROP TABLE IF EXISTS `wgt_stock_ticker`;

CREATE TABLE `wgt_stock_ticker` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `stock_symbol` char(15) DEFAULT NULL,
  `stock_name` varchar(255) DEFAULT NULL,
  `date_created` char(20) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

/*Table structure for table `workflow` */

DROP TABLE IF EXISTS `workflow`;

CREATE TABLE `workflow` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `form_builder_formid` int(10) unsigned NOT NULL DEFAULT '0',
  `process` varchar(255) DEFAULT NULL COMMENT 'name of the process',
  `display_name` varchar(255) DEFAULT NULL,
  `code` char(20) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `department_id` int(255) unsigned NOT NULL DEFAULT '0' COMMENT 'this does not affect approval or request access. it is strictly for color coding.',
  `title_field` varchar(255) DEFAULT NULL,
  `date_created` char(15) NOT NULL,
  `active` tinyint(3) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

/*Table structure for table `workflow_approval_access` */

DROP TABLE IF EXISTS `workflow_approval_access`;

CREATE TABLE `workflow_approval_access` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `process_id` int(10) unsigned DEFAULT NULL,
  `state_id` int(10) unsigned DEFAULT NULL,
  `user_id` int(10) unsigned DEFAULT NULL COMMENT 'user id of person approving or rejecting',
  `group_id` int(11) DEFAULT NULL COMMENT 'approvals may also be tied to groups',
  `date_created` char(15) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

/*Table structure for table `workflow_request_access` */

DROP TABLE IF EXISTS `workflow_request_access`;

CREATE TABLE `workflow_request_access` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `process_id` int(10) unsigned DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  `group_id` int(10) unsigned DEFAULT NULL,
  `start_position` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'this determines at which state to start the process, default is state 0',
  `date_created` char(15) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

/*Table structure for table `workflow_states` */

DROP TABLE IF EXISTS `workflow_states`;

CREATE TABLE `workflow_states` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'state_id',
  `form_builder_sectionid` int(10) unsigned NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL COMMENT 'still cant remember what to use this for, may become useful later in dev.',
  `display_name` varchar(255) DEFAULT NULL COMMENT 'the name of the state. shows up as the label for the state.',
  `process_id` int(10) unsigned NOT NULL COMMENT 'process id , from workflow table',
  `position` int(10) unsigned NOT NULL DEFAULT '0',
  `duration` int(10) unsigned NOT NULL DEFAULT '24' COMMENT 'number of hours a process should spend in this state',
  `sla_email` varchar(255) NOT NULL,
  `departmental` tinyint(3) unsigned NOT NULL DEFAULT '1',
  `locational` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `allow_approver_change` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `is_approval` tinyint(3) unsigned NOT NULL DEFAULT '1',
  `use_supervisor` tinyint(3) NOT NULL DEFAULT '0',
  `include_form_in_notification` tinyint(3) NOT NULL DEFAULT '0',
  `date_created` char(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

/*Table structure for table `workflow_observers` */

DROP TABLE IF EXISTS `workflow_observers`;

CREATE TABLE `workflow_observers` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `process_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `group_id` int(10) unsigned NOT NULL,  
  `date_created` char(15) DEFAULT NULL,
  `active` tinyint(1) unsigned DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;