<!-- LDAP Connection Setting. This is the alternative third step of the installation (i.e. $step = 2). -->
<!-- Calling page defines $tr (translator) and $step (current step of the installation as an integer.) -->
<?php
$config = Zend_Registry::get('config');
$ldapConfig = $config->ldap->ldap->server1;
?>
<div class="panels">

	<div class="headtext">
		<h1><?php echo $tr->translate('Active Directory Integration');?></h1>
		<?php

		echo $tr->translate ( 'Please enter your Active Directory/LDAP connection settings. If you are not sure
of your settings, please get in touch with your AD Manager.' );
		?>
	</div>

	<div class="invalid" id="submitError"></div>
	<div id="mainBody">
	<div class="mainform">

		<form action="#" method="post" class="userform" id="ldapForm">
			<ul>
				<li><label><?php echo $tr->translate('Host');?> </label> <input
						 name="host" type="text" value="<?php echo $ldapConfig->host;?>" /></li>

				<li><label><?php echo $tr->translate('Port');?> </label> <input
						 name="port" type="text" value="<?php echo $ldapConfig->port;?>" /></li>

				<li>
				<label><?php echo $tr->translate('Use SSL');?> </label>
				<select name="useSsl">
					<option value="0" selected="selected"><?php echo $tr->translate("No");?></option>
					<option value="1"><?php echo $tr->translate("Yes");?></option>
				</select>
				</li>

				<li><label><?php echo $tr->translate('Base DN');?> </label>
					<input type="text" name="baseDn"  value="<?php echo $ldapConfig->baseDn;?>" /></li>

				<li>
					<label><?php echo $tr->translate('Bind Requires DN');?> </label>
					<select name="bindRequiresDn" id="bindRequiresDn">
					    <option value="0"  selected="selected"><?php echo $tr->translate("No");?></option>
					    <option value="1"><?php echo $tr->translate("Yes");?></option>
					</select>
					<div class="riders"><?php echo $tr->translate('Usually "Yes" if not using Microsoft Active Directory');?></div>
				</li>

				<li><label><?php echo $tr->translate('Account Domain Name');?> </label> <input
						 name="accountDomainName" type="text" value="<?php echo $ldapConfig->accountDomainName;?>"/>
				</li>
				<li>
					<label><?php echo $tr->translate("Username");?></label>
						<input name="username" type="text"	value="<?php echo $ldapConfig->username;?>" autocomplete="off" />
					<div class="riders"></div>
				</li>
				<li>
					<label><?php echo $tr->translate("Password");?> </label>
					<input name="password" type="password" value="<?php echo $ldapConfig->password;?>"/>
				</li>
			</ul>
		</form>
	</div>
	</div>
</div>
<script type="text/javascript">
$(document).ready(function(){

	$("#submitError").hide();
	var mainForm = "";
	//on click "Next", submit forms
	$("#btnNext").click(function(){
		//first get data from form
		var postData = $("#ldapForm").serialize();
		//detach the form
		mainForm = $(".mainform").detach();
		//show waiting gif
		$("#mainBody").html('<div class="panels"><img alt="" src="css/images/wait2.gif" style="display:block; margin-left: 40%"></div>');
		//hide error message
		$('#submitError').hide();
		//post data
	 	$.post("forms_handler.php?fn=ldap", postData,
			  function(result){
			  	//handle result
		  		if(result.error)
		  		{
			  		$('#submitError').html(result.message);
			  		$('#submitError').show();
			  		$("#mainBody").html("");$("#mainBody").append(mainForm);
			  		return false;
		  		}
		  		window.location.href = qualifyURL('start.php?step=<?php echo ($step + 1);?>');
		  		return false;
			  },
		 "json");
		 return false;
	});
});
</script>