<?php
	require_once 'forms_handler.php';

	/**
		POST data should follow structure.
	 */

	$data = array(
			"admin"=>array(
				"first_name"=>"Aaron",
				"last_name"=>"Schustler",
				"company_name"=>"Demo company",
				"email"=>"aaron@precuriodemo.com",
				"password"=>"pass1234"
			),
			"database"=>array(
				"host"=>"localhost",
				"port"=>"3306",
				"username"=>"root",
				"password"=>"",
				"database"=>"precurio4"
			),
			"settings"=>array(
				"locale"=>"en_GB",
				"demo_data"=>"1",
			)
		);
	//$data = $_POST;//comment this line to test script.

	$settings = $data['settings'];
	$database = $data['database'];
	$admin = $data['admin'];


	//write settings to config
	$config = Zend_Registry::get('config');
	$root = Zend_Registry::get('root');

	$email = $admin['email'];
	$company_name = $admin['company_name'];
	$domain = substr($email, stripos($email,"@"));

	$timezone = @date_default_timezone_get();

	if(!($timezone && strlen($timezone) > 6))
		$timezone = "Europe/London";

	//general settings
	$config->welcome_text = "Welcome to your Portal";
	$config->timezone = $timezone;
	$config->enviroment = "production";
	$config->company_name = $company_name;
	$config->auth_mech = "DatabaseAuth";
	$config->base_url = getBaseUrl();
	$config->email_domain = $domain;
	$config->domain = $domain;
	$config->default_locale = $settings['locale'];
	$config->session_id_prefix = "PRECURIOSESSID".time();

	//database settings
	$config->mysql->database->host = $database['host'];
	$config->mysql->database->port = $database['port'];
	$config->mysql->database->username = $database['username'];
	$config->mysql->database->password = $database['password'];
	$config->mysql->database->dbname = $database['database'];

	$item = new Precurio_ConfigWriter(array('config'   => $config,
			'filename' => $root.'/application/configs/precurio_tmp.ini'));
	$item->write();

	//create database
	$result = createMySQLDatabase($database);
	if($result && isset($result->error))//if there was an error creating the database
	{
		sendToBrowser($result);
		return;
	}

	//create user
	unset($result);
	$result = createUser($admin);
	if($result && isset($result->error))//if there was an error creating the user
	{
		sendToBrowser($result);
		return;
	}

	//install necessary data
	$obj = new stdClass();
	try {
		if($settings['demo_data'])
		{
			$_SESSION['database'] = $data['database'];
			$_SESSION['admin'] = $data['admin'];
			insertDemoData();
		}
		else
		{
			insertDefaultData();
		}

	}
	catch (Exception $e)
	{
		$obj->error = true;
		$obj->message = $e->getMessage();
		sendToBrowser($obj);
		return;
	}

	//copy the htaccess file to public folder. Remember we didn't include the .htaccess file in installation
	//package because of error 505 on some servers.
	@copy("htaccess.txt", $root."/public/.htaccess");
	//replace root index file with one that redirects to login page rather than install page
	@unlink($root."/index.php");
	@copy("temp.php", $root."/index.php");
	//replace public index file
	@unlink($root."/public/index.php");
	@copy("original/index.php", $root."/public/index.php");

	//replace install index file with one that tells user "installation is complete"
	@unlink("index.php");
	@copy("index2.php", "index.php");

	//rename tmp config as permanent config.
	copy($root.'/application/configs/precurio_tmp.ini', $root.'/application/configs/precurio.ini');

	$_SESSION['settings'] = $settings;//used by finish.php do display demo users login info
	$_SESSION['admin'] = $admin;

	require 'finish.php';
?>