<?php

class Precurio_Utils {
	public static function currency_format($number)
	{
		$config = Zend_Registry::get('config');
		return $config->currency_symbol.number_format($number);
	}
	public static function isNull($var)
	{
		return (empty($var) || $var==='NULL' ||  $var==='null');
	}
	/**
	 * this function returns the content of the second level arrary as those of the top level,
	 * such that a 2-Dimensional array becomes a linear array
	 * @param array $topArray
	 * @param int|string $column
	 * @return array
	 */
	public static function getSecondLevelArray($topArray,$column=null)
	{
		$newArray = array();
		foreach($topArray as $secondArray)
		{
			if(!is_array($secondArray))
			{
				if(is_a($secondArray, 'Zend_Db_Table_Row_Abstract'))
				{
					$secondArray = $secondArray->toArray();
				}
				else
					return $topArray;
			}
			//if column is not null and its index is an array
			if(!self::isNull($column))
			{
				if(is_array($secondArray[$column]))
					$newArray =	array_merge($newArray,$secondArray[$column]);
				else
					$newArray[] = $secondArray[$column];
			}
			else
				$newArray =	array_merge($newArray,$secondArray);
		}

		return $newArray;
	}
	public static function encrypt($str)
	{
		$str = base64_encode($str);
		$x = new Precurio_EnDecryptText();
		return $x->Encrypt_Text($str);
	}
	public static function decrypt($str)
	{
		$x = new Precurio_EnDecryptText();
		$str =  $x->Decrypt_Text($str);
		$str = base64_decode($str);
		return $str;
	}
	/**
	 * @method strictly for testing purpose
	 * @param $var Object
	 * @return void
	 */
	public static function debug($var)
	{
		$log = Zend_Registry::get('log');
		$log->debug($var);
	}

	/**
	 * Converts a multi-dimensional array to a table string
	 * @param $arr Array
	 * @param $header Array - An array of strings to use as table header
	 * @param $pathToController string, The path to the controller eg "/admin/poll/", must contain the last slash
	 * @param $options Array - An array of options. e.g. array('enable_view'=>1,'enable_edit'=1,'view_href'=>' href="/cms/view/1" ')
	 * @return string
	 */
	public static function array2Table($arr,$header,$pathToController,$options=array())
	{
		$tr = Zend_Registry::get('Zend_Translate');
		if(empty($options['view_href']))$options['view_href'] = " target='_blank' href='{$pathToController}view/id/%1\$s' ";
		if(empty($options['edit_href']))$options['edit_href'] = " href='{$pathToController}edit/id/%1\$s' ";
		if(empty($options['view_label']))$options['view_label'] = $tr->translate('View');
		if(empty($options['edit_label']))$options['edit_label'] = $tr->translate('Edit');
		//if(!isset($options['enable_edit']))$options['enable_edit'] = 1;//enable edit by default
		$str = "<table border='1' width='100%'>";

		$str .= "<tr>";
		$str .= "<th><input type='checkbox' name='id' id='id'   onclick='selectAll(this)'></th>";
		foreach($header as $i)
		{
			$str .= "<th>$i </th>";
		}
		if($options['enable_view'])
			$str .= "<th></th>";
		if($options['enable_edit'])
			$str .= "<th></th>";

		$str .= "</tr>";

		foreach($arr as $value)
		{
			$key = $value['id'];
			$str .= "<tr>";
			$str .= "<td><input type='checkbox' name='ids[]' id='ids[]'  value='$key'>	</td>";
			foreach($value as $prop=>$j)
			{
				if($prop === "id")continue;
				if($prop === "title")
				{
					$j = "<a ".sprintf($options['edit_href'],$key).">$j</a>";
				}
				$str .= "<td>$j </td>";
			}
			if($options['enable_view'])
				$str .="<td><a ".sprintf($options['view_href'],$key)."'>".$options['view_label']." </a></td>";
			if($options['enable_edit'])
				$str .="<td><a ".sprintf($options['edit_href'],$key)."'>".$options['edit_label']." </a></td>";
			$str .= "</tr>";
		}
		$str .= "</table>";
		return $str;
	}
	/**
	 * Coverts an array or rowset to an option string suitable for use in select components
	 * @param Array,Zend_Db_Table_Rowset_Abstract $array
	 * @param int $selected - id of selected element
	 */
	public static function array2Options($array,$selected=0)
	{
		$str = "";
		foreach($array as $obj)
		{
			if($obj->id == $selected)
				$str.= "<option value='".$obj->id."' selected='selected'>$obj</option>";
			else
				$str.= "<option value='".$obj->id."'>$obj</option>";
		}
		return $str;
	}
	public static function isNewInstallation()
	{
		$root = Zend_Registry::get('root');
		return file_exists($root.'/application/configs/precurio_tmp.ini');//the precurio_tmp file is always deleted after an installation
	}
	public static function isUpgradeInstallation()
	{
		$root = Zend_Registry::get('root');
		if(!file_exists($root.'/application/configs/precurio_tmp.ini'))return false;

		$root = Zend_Registry::get('root');
		$config1 = new Zend_Config_Ini($root.'/application/configs/precurio.ini');
		$config2 = new Zend_Config_Ini($root.'/application/configs/precurio_tmp.ini');

		if(!isset($config1->license->version))return true;//to handle upgrade old installations especially v2.01

		return ($config1->license->version != $config2->license->version);
	}
	/**
	 * Returns a somewhat readable string
	 * @param $nameLength int length of the name
	 * @return String
	 */
	public static function randomName( $nameLength =8)
	{
	 $NameChars = 'abcdefghijklmnopqrstuvwxyz';
	 $Vouel = 'aeiou';
	 $Name = "";
	 for ($index = 1; $index <= $nameLength; $index++)
	 {
	    if ($index % 3 == 0)
	    {
	      $randomNumber = rand(1,strlen($Vouel));
	      $Name .= substr($Vouel,$randomNumber-1,1);
	    }else
	      {
	        $randomNumber = rand(1,strlen($NameChars));
	        $Name .= substr($NameChars,$randomNumber-1,1);
	      }
	 }
	 return $Name;
	}
	public static function randomPassword($length = 8)
	{

		// start with a blank password
		$password = "";

		// define possible characters - any character in this string can be
		// picked for use in the password, so if you want to put vowels back in
		// or add special characters such as exclamation marks, this is where
		// you should do it
		$possible = "2346789bcdfghjkmnpqrtvwxyzBCDFGHJKLMNPQRTVWXYZ";

		// we refer to the length of $possible a few times, so let's grab it now
		$maxlength = strlen($possible);

		// check for length overflow and truncate if necessary
		if ($length > $maxlength) {
			$length = $maxlength;
		}

		// set up a counter for how many characters are in the password so far
		$i = 0;

		// add random characters to $password until $length is reached
		while ($i < $length) {

			// pick a random character from the possible ones
			$char = substr($possible, mt_rand(0, $maxlength-1), 1);

			// have we already used this character in $password?
			if (!strstr($password, $char)) {
				// no, so it's OK to add it onto the end of whatever we've already got...
				$password .= $char;
				// ... and increase the counter by one
				$i++;
			}

		}

		// done!
		return $password;

	}
	/**
	 * Cleans a post data from possible malicious attack
	 * @param array,string $data
	 * @todo implement this function
	 */
	public static function cleanPostData($data)
	{
		return $data;

	}
	/**
	 * Get Precurio database configuration parameters. "dbname", "host","username","password".
	 * Currently used by Precurio_FormElement
	 * @return array
	 */
	public static function getDbConfig()
	{
		$root = Zend_Registry::get('root');
		$config = Zend_Registry::get('config');

		$active_db = $config->active_database;
		$db_config = new Zend_Config_Ini($root.'/application/configs/precurio.ini',$active_db);

		$db_config = $db_config->toArray();
		$db_config = $db_config['database'];
		return $db_config;
	}
}

?>