<?php
	/**
     * Array containing the valid file types
     * @var  array
     * @access   global
     */
     $GLOBALS['VALID_TYPES'] =
     			array('jpg', 'jpeg', 'png', 'doc', 'txt', 'gif','bmp',
				      'rtf', 'pdf', 'xls', 'rar', 'tar', 'zip', 'tgz', 'gz','csv','vcf',
				      'ppt','xml'
     			);

/**
* Upload files to the server
*
* @author      Andrey Yasinecky <andrey@yasinecky.com>
* @version     1.0
*/
class Precurio_Upload
{
	/**
	 * Flag to determine if upload should enforce type check.
	 * If set to true, file types not specified in $GLOBALS['VALID_TYPES'] will not be uploaded.
	 * @var boolean
	 */
	var $checkType = false;
	/**
     * Max file size
     * @var  	 integer
     * @access   private
     */
	var $max_file_size = 10485760; //10 Mb

	/**
     * Max image width
     * @var  	 integer
     * @access   private
     */
	var $max_image_width = 1024; //pixels

	/**
	 * an array which contains uploaded files
	 * @var array
	 * @access private
	 */
	var $_files = array();

	/**
	 * path to files's icons folder
	 * @var string
	 * @access private
	 */
	var $icons_path = 'ico/';

	/**
     * Class constructor
     * @param    integer    $file_size    max file size
     * @param    string     $target_dir   dir to upload
     * @access   public
     */


	// }}}
    // {{{ setMaxWidth()

    /**
     * Setting max image width
     */
    function setMaxWidth($width)
    {
    	$this->max_image_width = $width;
    }


    // }}}
    // {{{ setMaxSize()

    /**
     * Setting max file size
     */
    function setMaxSize($size)
    {
    	$this->max_file_size = $size;
    }
	private function checkServerSettings(){
        $uploadSize = $this->toBytes(ini_get('upload_max_filesize'));
        $this->setMaxSize($uploadSize);
    }

    private function toBytes($str){
        $val = trim($str);
        $last = strtolower($str[strlen($str)-1]);
        switch($last) {
            case 'g': $val *= 1024;
            case 'm': $val *= 1024;
            case 'k': $val *= 1024;
        }
        return $val;
    }

    // }}}
    // {{{ checkDir()

    /**
     * Check destination dir. If dir not exists, create new one.
     *
     * @param string  $dir  destination folder
     * @return absolute path to dir
     * @access  public
     */
	static function checkDir($dir)
	{
		//$dir is always begins with "/uploads/....."
	    //and we know this are the possible web urls
	    //1) http://server/precurio/public/ . Base Url "precurio/public"
	    //2) http://precurio.server/  . Base Url ""
	    //3) http://precurio.server/public. Base Url "public"
	    // Root url is ALWAY path to precurio folder
	    // This means the commented code block, previously used on older versions was unnecessary
	    /*
	    $baseUrl = Zend_Controller_Front::getInstance()->getRequest()->getBaseUrl();
		$dir = $baseUrl . $dir;

	    if(empty($baseUrl))
	   	 	$absolute_dir = Zend_Registry::get('root').'/public'.$dir;
	   	else
			$absolute_dir = $_SERVER['DOCUMENT_ROOT'].''.$dir;
	     */
		//now we replace with the single line below.
		$absolute_dir = Zend_Registry::get('root').'/public'.$dir;
	    $dir = preg_replace("/(.*)(\/)$/","\\1", $dir);
		if (!is_dir($absolute_dir)) {
			mkdir($absolute_dir, 0777);
			//eval("chmod(\"".$absolute_dir."\", 0777);"); // if php script has special rights to execute chmod
			chmod($absolute_dir, 0777);
		}
		return $absolute_dir;
	} // end checkDir()


	// }}}
    // {{{ checkGd()

    /**
     * Check GD library version.
     *
     * @return  GD version or false
     * @access  public
     */
	function checkGd()
	{
		$gd_content = get_extension_funcs('gd'); // Grab function list
		if (!$gd_content) {
			$this->message_err('Upload class: GD libarary is not installed!', '', '', E_USER_ERROR);

			return false;
		} else {
			ob_start();
			phpinfo(8);
			$buffer = ob_get_contents();
			ob_end_clean();

			if (strpos($buffer, '2.0')) {
			    return 'gd2';
			} else {
			    return 'gd';
			}
		}
	}


	// }}}
    // {{{ deleteFile()

    /**
     * Delete file from server
     *
     * @param string  $filename  filename
     * @param string  $source_dir   the dir in which is file
     * @return bool true|falses
     * @access  public
     */
	function deleteFile($filename, $source_dir)
	{
	    $source_dir = $this->checkDir($source_dir);
		if (file_exists($source_dir.'/'.$filename)) {
			if (unlink($source_dir.'/'.$filename)) {
				return true;
			}
		}
		return false;
	}


	// }}}
    // {{{ lantinEncode()

    /**
     * Encode string from russian to latin
     *
     * @param string  $str
     * @return string $new_string
     * @access  public
     */
	function lantinEncode($str)
	{
	    $accordance = array('a','b','v','g','d','e','zh','z','i','y','k','l','m','n','o','p',
							'r','s','t','u','f','h','ch','c','sh','sh','','i','','e','u','ya');
		$cirilyc = array('a','','','','','','','','','','','','','','','',
						 '','','','','','','','','','','','','','','','');

		$new_str = '';
		for ($i=0; $i<strlen($str); $i++) {
		    $symbol = substr($str, $i, 1);
			for($j=0; $j<count($cirilyc); $j++) {
			    if($symbol == $cirilyc[$j]) {
				    $symbol = $accordance[$j];
				}
			}
			$new_str.= $symbol;
		}

		return $new_str;
	}

	public $originalFileNames = array();
	public $fileExtensions = array();
    // }}}
	// {{{ uploadFile()

	/**
	 * Upload file to server
	 *
	 * @param string $target_dir destination dir
	 * @param string $encode encode type
	 * @param string $name_length filename length
	 * @access public
	 */
	function uploadFile($target_dir = '', $encode = 'md5', $name_length = 10)
	{
		$this->checkServerSettings();
		$tr = Zend_Registry::get('Zend_Translate');
		$target_dir = $this->checkDir($target_dir); //print_r($_FILES); exit;
	    foreach ($_FILES as $varname => $array) {
		    if (!empty($array['name'])) {
			    if (is_uploaded_file($array['tmp_name'])) {
			    	$filename = $array['name'];
				    //$filename = strtolower(str_replace(' ', '', $array['name']));
					$basefilename = preg_replace("/(.*)\.([^.]+)$/","\\1", $filename);
					$ext = preg_replace("/.*\.([^.]+)$/","\\1", $filename);
					$this->fileExtensions[$varname] = $ext;

					if ($array['size'] > $this->max_file_size) {
					    $this->message_err($tr->translate('Upload class: Impossible upload file size'), '', '', E_USER_WARNING);

					} elseif (!in_array(substr(strtolower($ext),0,3), $GLOBALS['VALID_TYPES']) && $this->checkType) {
					    $this->message_err($tr->translate('Upload class: Impossible upload file type'), '', '', E_USER_WARNING);

					} else {
						$this->originalFileNames[$varname] = $filename;
					    // encode filename
					    switch ($encode) {
						case 'md5':
						    $basefilename = substr(md5($basefilename), 0, $name_length);
						    break;

						case 'latin':
						    $basefilename = substr($this->lantinEncode($basefilename), 0, $name_length);
						    break;
						}

						$filename = $basefilename.time().'.'.$ext;

						if (!move_uploaded_file($array['tmp_name'], $target_dir.'/'.$filename)) {
						    $this->message_err($tr->translate('Upload class: cannot upload file'), '', '', E_USER_ERROR);
						}

						$this->_files[$varname] = $filename;
					}
				} else {
				    $this->message_err($tr->translate('Upload class: cannot create tmp file').': '.$array['tmp_name'], '', '', E_USER_ERROR);
				}
			}
		}
		return $this->_files;
	}


	// }}}
	// {{{ imgResize()

	/**
	 * Resize image on the server
	 *
	 * @param string $filename the filename of image
	 * @param string $source_dir the dir where this image stored
	 * @param string $dest_width destination image width
	 * @param bool $duplicate set true if you want to duplicate image
	 * @return bool true|false
	 * @access public
	 */
	function imgResize($filename, $source_dir, $dest_width, $duplicate = false,$dest_dir='',$crop=false)
	{
	    $source_dir = $this->checkDir($source_dir);
		$full_path = $source_dir.'/'.$filename;
		if($dest_dir=='')$dest_dir = $source_dir;
		$dest_dir = $this->checkDir($dest_dir);
		$dest_path = $dest_dir.'/'.$filename;

		$basefilename = preg_replace("/(.*)\.([^.]+)$/","\\1", $filename);
		$ext = preg_replace("/.*\.([^.]+)$/","\\1", $filename);

		$ext = strtolower($ext);
		switch ($ext) {
		case 'png':
		    $image = imagecreatefrompng($full_path);
		    break;

		case 'jpg':
		    $image = imagecreatefromjpeg($full_path);
		    break;

		case 'jpeg':
		    $image = imagecreatefromjpeg($full_path);
		    break;

		default:
		    $this->message_err('Upload class: the '.$ext.' format is not allowed in your GD version', '', '', E_USER_ERROR);
			break;
		}

		$image_width = imagesx($image);
    	$image_height = imagesy($image);

	//now crop to a perfect square
		$width = $image_width;
		$height = $image_height;
		$x = 0;
		$y = 0;
		if($crop == true)
		{

			if($height > $width)
			{
				$diff = $height - $width;
				$height = $width;


			}
	       else
	       {
	       		$diff = $width - $height;
				$width = $height;
	       }
	       $x = ($image_width - $width) * 0.5;
			$y = ($image_height - $height) * 0.5;
			$image_width = $width;
			$image_height = $height;
		}

		// resize image pro rata
		$coefficient = ($image_width > $this->max_image_width) ? (real)($this->max_image_width / $image_width) : 1;
		$dest_width = (int)($image_width * $coefficient);
		$dest_height = (int)($image_height * $coefficient);



		// create copy of original image and next working with copy.
		// an original image still old
		if (false !== $duplicate) {
		   $filename = $basefilename.'.'.$ext;
		    copy($full_path, $dest_path);
		}

		if ('gd2' == $this->checkGd()) {
		    $img_id = imagecreatetruecolor($dest_width, $dest_height);
    		imagecopyresampled($img_id, $image, 0, 0, $x, $y, $dest_width + 1, $dest_height + 1, $image_width, $image_height);
		} else {
		    $img_id = imagecreate($dest_width, $dest_height);
    		imagecopyresized($img_id, $image, 0, 0, $x, $y, $dest_width + 1, $dest_height + 1, $image_width, $image_height);
		}

        switch ($ext) {
		case 'png':
		    imagepng($img_id, $dest_dir.'/'.$filename);
		    break;

		case 'jpg':
		    imagejpeg($img_id, $dest_dir.'/'.$filename);
		    break;

		case 'jpeg':
		    imagejpeg($img_id, $dest_dir.'/'.$filename);
		    break;
        }

		imagedestroy($img_id);

		return true;
	}


	// }}}
    // {{{ displayFiles()

    /**
     * Display files in destination folder
     * @param $source_dir the dir where files stored
     * @access  public
     */
	function displayFiles($source_dir)
	{
	    $source_dir = $this->checkDir($source_dir);
		if ($contents = opendir($source_dir)) {
		    echo 'Directory contents:<br>';

			while (false !== ($file = readdir($contents))) {
			    if (is_dir($file)) continue;

			    $filesize = (real)(filesize($source_dir.'/'.$file) / 1024);
				$filesize = number_format($filesize, 3, ',', ' ');

			    $ext = preg_replace("/.*\.([^.]+)$/","\\1", $file);
			    echo '<p><img src="'.$this->icons_path.''.$ext.'.gif">&nbsp;'.$file.'&nbsp;('.$filesize.') Kb</p>';
			}
		}
	}


	// }}}
    // {{{ fileRename()

    /**
     * Rename target file
     * @param $source_dir the dir where files stored
	 * @param $filename the source filename
	 * @param $newname new filename
     * @access  public
     */
	function fileRename($source_dir, $filename, $newname)
	{
	    $source_dir = $this->checkDir($source_dir);
		if (rename($source_dir.'/'.$filename, $newname)) {
		    return true;
		} else {
		    return false;
		}
	}
	function getFileName($fileCtrl='document')
	{
		return $this->originalFileNames[$fileCtrl];
	}
	function getFileTitle($fileCtrl)
	{
		$file_name = $this->originalFileNames[$fileCtrl];
		return substr($file_name,0,strripos($file_name,'.'));
	}
	function getFileExt($fileCtrl)
	{
		return $this->fileExtensions[$fileCtrl];
	}
	function getFileOwner($filePath)
	{
		return "";
		$fileowneruid = fileowner($filePath);
		$fileownerarray = posix_getpwuid($fileownerid);
		$fileowner = $fileownerarray['name'];
		return $fileowner;
	}

	// }}}
    // {{{ message_err()

    /**
     * Trigger error
	 */
	function message_err($error_msg, $err_line, $err_file, $error_type = E_USER_WARNING)
    {
    	$error_msg.= (!empty($err_line)) ? 'on line '.$err_line : '';
		$error_msg.= (!empty($err_file)) ? 'in - '.$err_file : '';
		$log = Zend_Registry::get('log');
		$log->err(new Exception($error_msg));
		return true;
        trigger_error($error_msg, $error_type);
    }
}
?>