<?php
require_once "others/dUnzip2.inc.php";
class Precurio_Themes extends Precurio_FileFn{

	private $_themes;
	private $_default;

	public function __construct()
	{
		$config = Zend_Registry::get('config');

    	$themeConfig = $config->theme;

    	$this->_default = $themeConfig->default;
    	$this->_themes = $themeConfig->themes->toArray();
	}

	public function getAll()
	{
		return $this->_themes;
	}

	/**Returns the default theme
	 * @return string
	 */
	public function getDefaultTheme()
	{
		$browser = detectBrowser();
		if($browser == 'mobile')
			return 'mobile';
		return $this->_default;
	}
	/**sets the default theme
	 * @return void
	 */
	public function setDefaultTheme($theme)
	{
		$config = Zend_Registry::get('config');
		$rootPath = Zend_Registry::get('root');

		$config->theme->default = $theme;
		$item = new Precurio_ConfigWriter(array('config'   => $config,
                                           'filename' => $rootPath.'/application/configs/precurio.ini'));

		$item->write();
	}

	/**
	 * sets the default style for a theme
	 * @param $theme string, theme name
	 * @param $styleIndex string, style index i.e style1,style2 etc
	 * @return void
	 */
	public function setDefaultThemeStyle($theme,$styleIndex)
	{
		$config = Zend_Registry::get('config');
		$rootPath = Zend_Registry::get('root');

		$styles = $this->getThemeStyles($theme);


		$style = $styles[$styleIndex];

		$config->theme->themes->{$theme}->default = $style;

		$item = new Precurio_ConfigWriter(array('config'   => $config,
                                           'filename' => $rootPath.'/application/configs/precurio.ini'));

		$item->write();
	}
	/**
	 * Returns an array of styles available for a particular theme
	 * @param $theme string
	 * @return Array
	 */
	public function getThemeStyles($theme)
	{
		return $this->_themes[$theme]['styles'];
	}

	/**
	 * Returns the default style for a theme
	 * @param $theme string
	 * @return string
	 */
	public function getDefaultThemeStyle($theme)
	{
		if(isset($this->_themes[$theme]['default']))
			return  $this->_themes[$theme]['default'];

		return $this->_themes[$theme]['styles']['style1'];//no default was set, return the first style
	}

	/**
	 * Returns the default style being used by a user.
	 * @return string
	 */
	public function getUserStyle($currentTheme = "")
	{
		//first get previously used style from user session
		$userStyle =  Precurio_Session::getStyle();

		if(Precurio_Utils::isNull($userStyle))//if no style was set in user session
			return $this->getDefaultThemeStyle($currentTheme);

		//now get all available styles for current theme.
		$themeStyles = $this->getThemeStyles($currentTheme);

		//if previously used style is NOT under current theme, return
		//default style for current theme
		if(array_search($userStyle,$themeStyles) === false)
			return $this->getDefaultThemeStyle($currentTheme);
		//else return previously used style.
		return $userStyle;
	}

	/**
	 * Returns the default theme being used by a user.
	 * @return string
	 */
	public function getUserTheme()
	{
		return $this->getDefaultTheme();
	}

	public function delete($theme)
	{
		if($theme == $this->_default)return ;

		$config = Zend_Registry::get('config');
		$rootPath = Zend_Registry::get('root');
		unset($config->theme->themes->{$theme});
		$item = new Precurio_ConfigWriter(array('config'   => $config,
                                           'filename' => $rootPath.'/application/configs/precurio.ini'));

		$item->write();

		$this->deldir($rootPath.'/application/default/layouts/'.$theme);
		$this->deldir($rootPath.'/public/library/css/'.$theme);

	}
	/**
	 * Removes a style from a theme
	 * @param $theme string, name of theme
	 * @param $styleIndex string, style index i.e style1,style2 etc
	 * @return void
	 */
	public function deleteStyle($theme,$styleIndex)
	{
		$config = Zend_Registry::get('config');
		$rootPath = Zend_Registry::get('root');

		$styles = $this->getThemeStyles($theme);

		if(count($styles) == 1)return;//you cannot delete the only style left in a theme,

		$style = $styles[$styleIndex];

		unset($styles[$styleIndex]);
		if($config->theme->themes->{$theme}->default == $style)
		{
			//if you are deleting theme default style, then set another style as the default
			$temp = array_values($styles);//holds all styles with their index as numbers instead of strings
			$config->theme->themes->{$theme}->default = $temp[0];
			unset($temp);//we don't need it anymore
		}

		unset($config->theme->themes->{$theme}->styles->{$styleIndex});//deleted

		//now reorder style indexes
		//but first remove existing order
		foreach($styles as $styleIndex=>$style)
		{
			unset($config->theme->themes->{$theme}->styles->{$styleIndex});//deleted
		}
		$styles = array_values($styles);//convert to numeric indexed array
		//create new order
		foreach($styles as $i=>$style)
		{
			$newStyleIndex = 'style'.++$i;
			$config->theme->themes->{$theme}->styles->{$newStyleIndex} = $style;
		}

		$item = new Precurio_ConfigWriter(array('config'   => $config,
                                           'filename' => $rootPath.'/application/configs/precurio.ini'));

		$item->write();

		$this->deldir($rootPath.'/public/library/css/'.$theme.'/'.$style);
	}

	/**
	 *@todo make this function version 4 compatible
	 */
	public function install()
	{
		$target_dir = $this->checkDir('/uploads/tmp/');
		$file = $_FILES['file'];

		$tr = Zend_Registry::get('Zend_Translate');
		//first handle file upload
		if (is_uploaded_file($file['tmp_name']))
		{
	    	$filename = $file['name'];
			$basefilename = preg_replace("/(.*)\.([^.]+)$/","\\1", $filename);
			$ext = preg_replace("/.*\.([^.]+)$/","\\1", $filename);
			if(strtolower($ext) !== 'zip')
			{
				echo ($tr->translate('Incorrect file format'));
				return;
			}
			if (!move_uploaded_file($file['tmp_name'], $target_dir.'/'.$filename))
			{
			    echo($tr->translate('Cannot upload file'));
			    return;
			}
			$themeFile = ($target_dir.'/'.$filename);
		}
		//then unzip file
		$zip = new dUnzip2($themeFile);
		$zip->unzipAll($target_dir.'/'.$basefilename);
		$themePath = $target_dir.'/'.$basefilename.'/'.$basefilename;
		//then confirm everything is ok with the theme. i.e. styles exist, config is correct , etc.
		//we now need to know the available styles there
		$styles = array();
		$dir = opendir($themePath.'/css/'.$basefilename.'/');
		if($dir == false )
		{
			echo $tr->translate("INSTALL FAILED : Could not open unzipped directory");
			return;
		}
		// Read the directory and get the sub directories
	    while (($file = readdir($dir)) !== false) {

	        if ($file[0] == '.'){ continue; }

	        if (is_dir($themePath.'/css/'.$basefilename.'/'.$file))
	        {
					$styles[] = $file;
	        }
	    }
	    $dir = closedir($dir);

	    if(count($styles) == 0)
	    {
	    	echo $tr->translate("INSTALL FAILED : This theme does not contain any style.");
	    	echo $themePath.'/css/'.$basefilename;
	    	return;
	    }
	    //ok we now have styles, now get theme configuration from ini file
		try
		{
			$author = $tr->translate('Unknown');
			$version = '1.0';
			$default = $styles[0];
			if(file_exists($themePath.'/'.$basefilename.'.ini'))
			{
				$themeConfig = new Zend_Config_Ini($themePath.'/'.$basefilename.'.ini',null,array('allowModifications'=>true));
				$author = isset($themeConfig->author) ? $themeConfig->author : $author;
				$version = isset($themeConfig->version) ? $themeConfig->version : $version;
				$default = isset($themeConfig->default) ? $themeConfig->default : $default;
			}

		}
		catch(Exception $e)
		{
			echo "INSTALL FAILED : ".$e->getMessage();
	    	return;
		}

		//ok everything seems to be fine with new theme.
		$appPath = Zend_Registry::get('root');

		//now copy the layouts file
		$this->copy($themePath.'/layouts/'.$basefilename,$appPath.'/application/default/layouts/'.$basefilename);
		//then copy the css file
		$this->copy($themePath.'/css/'.$basefilename,$appPath.'/public/library/themes/'.$basefilename);

		//ok we almost through. we just need to alter application configuration to reflect new theme
		$config = Zend_Registry::get('config');

		$newConfig = new Zend_Config($config->toArray(),true);

		$newConfig->theme->themes->{$basefilename} = array();
		$newConfig->theme->themes->{$basefilename}->theme = $basefilename;
		$newConfig->theme->themes->{$basefilename}->author = $author;
		$newConfig->theme->themes->{$basefilename}->version = $version;
		$newConfig->theme->themes->{$basefilename}->default = $default;
		$newConfig->theme->themes->{$basefilename}->styles = array();
		$i = 1;
		foreach($styles as $style)
		{
			$newConfig->theme->themes->{$basefilename}->styles->{'style'.$i++} = $style;
		}

		$item = new Precurio_ConfigWriter(array('config'   => $newConfig,
                                           'filename' => $appPath.'/application/configs/precurio.ini'));

		$item->write();

		//finally, delete temporary files. we are done here.
		unset($zip);
		$this->deldir($target_dir.'/'.$basefilename);

		unlink($themeFile);
		echo $tr->translate("Theme")." '$basefilename' ". $tr->translate("has been successfully installed.");
	}
	public function uploadLogo()
	{
	    $temp_dir = $this->checkDir('/uploads/tmp/');
		$file = $_FILES['file'];

		$log = Zend_Registry::get('log');
		//first handle file upload
		if (is_uploaded_file($file['tmp_name']))
		{
	    	$filename = $file['name'];
			$basefilename = preg_replace("/(.*)\.([^.]+)$/","\\1", $filename);
			$ext = preg_replace("/.*\.([^.]+)$/","\\1", $filename);
			if(strtolower($ext) !== 'png')
			{
				$log->err('Incorrect file format. Only .png files allowed');
				return;
			}
			if (!move_uploaded_file($file['tmp_name'], $temp_dir.'/'.$filename))
			{
			    $log->err('Cannot upload logo file');
			    return;
			}
		}
	    else
		{
		    $log->err('No file was selected');
			return;
		}

		//ok, upload was successful, now lets rename the file, and copy it to selected style folder
		$tempFile = $temp_dir.'/logo.'.$ext;
		if(!rename($temp_dir.'/'.$filename,$tempFile))
		{
		    $log->err('Could not complete upload');
			return;
		}

        $logoPath  = $this->checkDir('/library/themes/'.$this->getUserTheme().'/css/images/');
		copy($tempFile,$logoPath.'/logo.png');

		unlink($tempFile);
	}
	public function installStyle($theme)
	{
		$target_dir = $this->checkDir('/uploads/tmp/');
		$file = $_FILES['file'];
		$tr = Zend_Registry::get('Zend_Translate');
		//first handle file upload
		if (is_uploaded_file($file['tmp_name']))
		{
	    	$filename = $file['name'];
			$basefilename = preg_replace("/(.*)\.([^.]+)$/","\\1", $filename);
			$ext = preg_replace("/.*\.([^.]+)$/","\\1", $filename);
			if(strtolower($ext) !== 'zip')
			{
				echo ($tr->translate('Incorrect file format'));
				return;
			}
			if (!move_uploaded_file($file['tmp_name'], $target_dir.'/'.$filename))
			{
			    echo($tr->translate('Cannot upload file'));
			    return;
			}
			$styleFile = ($target_dir.'/'.$filename);
		}
		//then unzip file
		$zip = new dUnzip2($styleFile);
		$zip->unzipAll($target_dir.'/'.$basefilename);
		$stylePath = $target_dir.'/'.$basefilename;

		$appPath = Zend_Registry::get('root');

		//then copy the style css folder
		$this->copy($stylePath,$appPath.'/public/library/css/'.$theme.'/');

		//ok we almost through. we just need to alter application configuration to reflect new style
		$config = Zend_Registry::get('config');

		$styles = $this->getThemeStyles($theme);
		$styleIndexes = array_keys($styles);
		sort($styleIndexes);
		$lastIndex = array_pop($styleIndexes);
		$chars = preg_split('//', $lastIndex, -1, PREG_SPLIT_NO_EMPTY); //splits a string into component characters
		$i = array_pop($chars);//the last character will be a digit. i.e style1, style2
		$newStyleIndex = 'style'.++$i;

		$config->theme->themes->{$theme}->styles->{$newStyleIndex} = $basefilename;

		$item = new Precurio_ConfigWriter(array('config'   => $config,
                                           'filename' => $appPath.'/application/configs/precurio.ini'));

		$item->write();
		//finally, delete temporary files. we are done here.
		unset($zip);
		$this->deldir($stylePath);

		unlink($styleFile);
		echo $tr->translate("Style")." '$basefilename' ".$tr->translate("has been successfully added to")." '$theme'.";

	}


}

?>