<?php

require_once ('Zend/Acl/Resource.php');

class Precurio_Resource extends Zend_Acl_Resource {
	
	/**
	 * 
	 *@param string $resourceId 
	 *@return void 
	 */
	public function __construct($resourceId) {
		parent::__construct ( $resourceId );
	
	}
	
	/**
	 * @return Precurio_Resource
	 */
	public function getParent()
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::RESOURCES));
		$row = $table->fetchRow($table->select()->where('resource = ?',$this->getResourceId()));
		return $row == null ? null : new Precurio_Resource($row->parent);
	}
	
	public function isValid()
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::RESOURCES));
		$row = $table->fetchRow($table->select()->where('resource = ?',$this->getResourceId()));
		return $row != null;
	}
	public static function getAll()
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::RESOURCES));
		$rows = $table->fetchAll($table->select()->where('display_name <> ""'));
		
		$arr = array();
		foreach($rows as $row)
		{
			$arr[] = new Precurio_Resource($row->resource);
		}
		return $arr;
	}
	public function  getDisplayName()
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::RESOURCES));
		$row = $table->fetchRow($table->select()->where('resource = ?',$this->getResourceId()));
		return $row->display_name;
	}
	public function __toString()
	{
		return $this->getDisplayName();
	}
}

?>