<?php

class Precurio_Privilege extends stdClass{
	private $_privilegeId;

	function __construct($_privilegeId)
	{

		if($_privilegeId == 'new' || substr($_privilegeId,0,6) == 'submit' || $_privilegeId == 'reject' || $_privilegeId == 'cancel' || $_privilegeId == 'settings' || $_privilegeId == 'setting')
			$_privilegeId = 'add';

		if($_privilegeId == 'vcard' )//vcard in contacts module is a kind of export
			$_privilegeId = 'export';

		if($_privilegeId == 'configure' )//configure in widgets is a kind of edit
			$_privilegeId = 'edit';
		if($_privilegeId == 'select' || $_privilegeId == 'user' )//select in user module is used to share with users
			$_privilegeId = 'share';
		//if the privilege does not exist, give it the 'view' privilege
		if(!in_array($_privilegeId,array('view','edit','add','delete','details','share','export','import','executive')))
			$_privilegeId = 'view';
		$this->_privilegeId = (string) $_privilegeId;
	}
	/**
	 * @return string
	 */
	function getPrivilegeId()
	{
		return $this->_privilegeId;
	}

	function isValid()
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::PRIVILEGES));
		$row = $table->fetchRow($table->select()->where('privilege = ?',$this->getPrivilegeId()));
		return !Precurio_Utils::isNull($row);
	}
	public function __toString()
	{
		return $this->getPrivilegeId();
	}
	public function __toValue()
	{
		return $this->getPrivilegeId();
	}
}

?>