<?php
require_once ('user/models/vo/UserActivity.php');
/**
 * This class will simply check each activity type against a set of notification
 * channel settings.
 * @author Brain
 *
 */
class Precurio_Notification {


	public function __construct($activity_id)
	{
	    set_include_path(implode(PATH_SEPARATOR, array(
    	    realpath(APPLICATION_PATH . '/../library/Twilio'),
    	    get_include_path()
	    )));
	    
		$activity = UserActivity::get($activity_id);
		if(empty($activity))return;
		$activityR = $activity->getRegistry();

		if($activityR->mail_enabled)
		{
			$mail = new Precurio_Mail();
			$mail->notify($activity);
		}
		$config = Zend_Registry::get('config');
		if($activityR->sms_enabled && isset($config->twilio) && isset($config->account_sid))
		{
			$sms = new Precurio_Sms();
			$sms->notify($activity);
		}
	}
}

?>