<?php

require_once ('Zend/Mail.php');
require_once ('user/models/UserUtil.php');
class Precurio_Mail extends Zend_Mail {

	public function __construct()
	{
		parent::__construct();

		$config = Zend_Registry::get('config');
		$mail = $config->mail;
		$config = array();
		if($mail->use_auth)
		{
			$config = array('auth' => $mail->auth,
			'username' => $mail->username,
			'password' => $mail->password);
			if($mail->use_secure)
				$config['ssl'] = $mail->ssl;
		}
		else
		{
			$config = array();
		}
		$config['port'] = $mail->port;

		//$this->setDefaultFrom($mail->admin_email,$mail->admin_name);

		$tr = new Zend_Mail_Transport_Smtp($mail->server,$config);
		self::setDefaultTransport($tr);
	}
	/* (non-PHPdoc)
	 * @see Zend_Mail::send()
	 */
	public function send($transport = null)
    {
    	if (null === $this->_from)
    	{
    		$config = Zend_Registry::get('config');
    		$this->setFrom($config->mail->admin_email,$config->mail->admin_name);
    	}
    	parent::send($transport);

    }
	/**
	 * @param $activity UserActivity
	 * @return null
	 */
	public function notify($activity)
	{
		$data = array();
		if($activity->only_notify_id)
		{
			$users = array();
			try{$users[] = UserUtil::getUser($activity->only_notify_id,true);}
			catch(Precurio_Exception $e){return;}
		}
		else
			$users = $activity->getItem()->getUsers();

		$config = Zend_Registry::get('config');
		if(empty($users) || count($users) == 0)//public activity. See if system allows general email
		{
			 if($config->allow_general_emails)
			 	$users = UserUtil::getUsers();
			 else
			 	return;
		}

		$this->setFrom($config->mail->admin_email,$config->mail->admin_name);

		$data['subject'] = $activity->getMailSubject();
		$data['date_created'] = Precurio_Date::now()->getTimestamp();
		$data['activity_id'] = $activity->getId();
		foreach($users as $user)
		{
			if(!(is_a($user,'User')))$user = UserUtil::getUser($user->user_id);
			if(empty($user))continue;
			if($user->getId() == $activity->user_id)continue;//do not notify me of my activiy
			$data['to'] = $user->getEmail();
			$data['body'] = $activity->getMessage('mail',$user->getId());
			$data['from'] = $this->getFrom();

			$this->sendData($data);
		}
	}
	/**
	 * @param array $data - Array contain keys "to", "subject" and "body"
	 */
	public function sendData($data)
	{
		$config = Zend_Registry::get('config');
		if(empty($data['from']))$data['from'] = $config->mail->admin_email;
		if(empty($data['date_created']))$data['date_created'] = Precurio_Date::now()->getTimestamp();

		if(empty($config->no_mail_queue))//i.e. no_mail_queue option is not enabled
		{
			$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::MAIL_QUEUE));
			$row = $table->createRow($data);
			$row->save();
		}
		else
		{
			$this->addTo($data['to']);
			$this->setBodyHtml($data['body']);

			$tr = Zend_Registry::get('Zend_Translate');
			$this->setSubject($data['subject']);
			$this->send();
		}
	}

	/**
	 * @param $type
	 * @return string
	 * @deprecated - use UserActivity::getMailSubject() instead
	 */
	private function getMailSubject($type)
	{
		$tr = Zend_Registry::get('Zend_Translate');
		return '[PRECURIO]'.$tr->translate('New Activity');
	}
	/**
	 * Sends mail in the queue periodicially.
	 * @param $queueSize int -  The maximum number of mails that can be in the queue
	 */
	public function handleQueue($queueSize = 5)
	{
		set_time_limit(60);//must send 5 emails in 60seconds
		//immediately lock notification.
		$config = Zend_Registry::get("config");
		$root = Zend_Registry::get('root');

		$filename = $root.'/application/tmp/notification.lock';

		$str = "1:".time();
		$locked = file_put_contents($filename,$str);//locked.
		if(!$locked)return false;//could not lock, problem writing to directory. Do not execute


		require_once $root.'/bin/sendmail.php';
		//get mails to be sent
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::MAIL_QUEUE));
		$rows = $table->fetchAll($table->select()->where("sent = 0")->where("error_count = 0")->order("date_created asc")->limit($queueSize));

		//get mail template being used by daemon server
		$template = file_get_contents($root.'/bin/email_template.tpl');

		//now send mails.
		foreach($rows as $mail)
		{
			try
			{
				$m = new Precurio_Mail();
				$m->setFrom($config->mail->admin_email,$config->mail->admin_name);
				$m->addTo($mail->to);
				$m->setBodyText(strip_tags($mail->body));
				$m->setBodyHtml(htmlWrap($mail->body,$mail->subject,$template));
				$m->setSubject($mail->subject);

				$m->send();
				//update send status. Note that if there was a problem with sending the mail an error will be thrown..
				$mail->sent = 1;
				$mail->save();
			}
			catch (Exception $e)
			{
				//echo $e->getMessage();
			}
		}

		//finished with queue, now unlock.
		$str = "0:".time();
		file_put_contents($filename,$str);//unlocked.
		return isset($e) ? 0 : 1;
	}
}

?>