<?php

class Precurio_Language {
	
	/**
	 * @var string
	 */
	protected $locale;
	
	/**
	 * @var arr
	 */
	protected $data;
	/**
	 * @param string $locale - the locale eg en_GM
	 * @param array $data - Contains information such as author and data
	 * @return Precurio_Language
	 */
	public function __construct($locale,$data=array())
	{
		$this->locale = $locale;
		$this->data = $data;
	}
	/**
	 * @return string
	 */
	public function getAuthor()
	{
		return empty($this->data['author']) ? 'Community' :  $this->data['author'];
	}
	/**
	 * @return string
	 */
	public function getVersion()
	{
		return empty($this->data['version']) ? 'Unknown' :  $this->data['version'];
	}
	/**
	 * @return string
	 */
	public function getLabel()
	{
		return empty($this->data['label']) ? $this->locale :  $this->data['label'];
	}
	/**
	 * @return string
	 */
	public function getLocaleString()
	{
		return $this->locale;
	}
	/**
	 * @return Zend_Locale
	 */
	public function getLocale()
	{
		return new Zend_Locale($this->locale);
	}
	public function __toString()
	{
		return $this->getLabel();
	}
}

?>