<?php
//special form element types are : user, currency, date, location,department
  class Precurio_FormElement  {


  	/**
  	 * @var Precurio_ProcessForm
  	 */
  	private $form;

  /**
   * @var Zend_Form_Element or its subclasses
   */
  public $formElement;
  /**
   * @var Array of Zend_Form_Element_Submit
   */
  public $formButtons;
  public $elementSchema;


    /**
     * @param $elementSchema array
     * @param $form Precurio_ProcessForm
     * @return unknown_type
     */
    function __construct($elementSchema,$form)
	{
		$this->elementSchema = $elementSchema;
		$this->form = $form;

	}
	/**
	 * Returns Array of 2 Buttons(i.e Submit and Cancel)
	 * @return Array
	 */
	public static function generateSubmitCancelButtons()
	{
		$tr = Zend_Registry::get('Zend_Translate');
		//submitbutton
		$submit = new Zend_Form_Element_Submit('submit',array('class'=>'standout'));

		$submit->setDecorators(array(
//        'ViewHelper',
		array('Description',array('escape'=>false,'tag'=>'span')), //escape false because I want html output
		array(array('button' => 'HtmlTag'), array('tag' => 'div', 'class' => 'buttons')),
        array('HtmlTag', array('tag' => 'td','class'=>'alt','colspan'=>'3')),
        array(array('label' => 'HtmlTag'), array('tag' => 'td','class'=>'alt')),
		array(array('row' => 'HtmlTag'), array('tag' => 'tr')),
        ));
		$baseUrl = Zend_Controller_Front::getInstance()->getRequest()->getBaseUrl();

		$submit->setDescription('<button type="submit" class="standout">
    	    		'.$tr->translate('Submit').'
    	</button>  <a class="negative" style="float: auto;" href="' . $baseUrl . '/workflow">'.$tr->translate('Cancel').'</a>');
		//$submit->setLabel('Approve');
		return $submit;

	}
	public function processSchema()
	{
		$this->formElement = $this->getFormElement();
		//if($this->elementSchema['control'] == 'file')return $this->formElement;
		if($this->formElement->getType() == 'Zend_Form_Element_Radio')
		{
			$this->formElement->addMultiOption($this->formElement->getName(),$this->formElement->getLabel());
		}
		$this->processDisplay();
		$this->processDataSource();
		$this->processData();
		$this->processValue();
		//@todo process validatiors
		//@todo process filters
		return $this->formElement;
	}

	/**
	 * this function processes any option that has to do with disply i.e display logic
	 * @return void
	 */
	private function processDisplay()
	{
		if($this->elementSchema['control'] == 'hidden' || $this->elementSchema['type'] == 'signature')return;
		$this->formElement->setLabel($this->elementSchema['label'])
							->setRequired(($this->elementSchema['required']=='true' ? true : false))
							->setDisableLoadDefaultDecorators(true);

		if(Precurio_Utils::isNull($this->elementSchema['label']))
		{
			$this->formElement->removeDecorator('Label');
		}


		if($this->elementSchema['control']=='textarea')
			$this->formElement->setOptions(array('rows'=>'3','cols'=>'60'));

		if($this->elementSchema['type']=='date')
			$this->formElement->setOptions(array('class'=>'date_input'));

		$decorators = $this->elementSchema['options']['display']['decorator'];
		foreach($decorators as $decorator)
		{
			$decorator = $this->generateDecorator($decorator);
			$this->formElement->addDecorator($decorator->name,$decorator->options);
		}
		$label = $this->formElement->getDecorator('Label');
		if($label)
		{
			$label->setOption('style','font-weight:bold;');
			$label->setOption('escape',false);
		}
	}
	/**
	 * @param array $decoratorStruct
	 * @return object with properties 'name' and 'options'
	 */
	private function generateDecorator($decoratorStruct)
	{
		$obj = new stdclass();
		$obj->name = $decoratorStruct['name']['value'];
		if(isset($decoratorStruct['name']['alias']))
			$obj->name = array($decoratorStruct['name']['alias']=>$decoratorStruct['name']['value']);

		$obj->options = $decoratorStruct['options'];
		return $obj;
	}
  /**
	 * If the schema  contains a datasource property, it processes it.
	 * @return void
	 */
	private function processDataSource()
	{
		if($this->form->viewMode)return;

		if(!isset($this->elementSchema['datasource']))
			return;
		$datasource = $this->elementSchema['datasource'];
		$fields = array();

		if(isset($datasource['database']))
			$table = $this->getTable($datasource['tablename'],$datasource['database']);
		else
			$table = new Zend_Db_Table(array('name'=>$datasource['tablename']));

		$where = null;
		if(isset($datasource['where']) && !empty($datasource['where']))
			$where = $datasource['where'];

		$rows = $table->fetchAll($where);
		//$data = self::getOptionsArray($rows,$datasource['indexfield'],$datasource['labelfield']);//to be used if you want to insert value field (usually id)
		$data = $this->getDataSourceArray($rows,$datasource['labelfield']);
		$this->formElement->setOptions(array('multiOptions'=>$data));
	}
	/**
	 * Gets a table object from any database
	 * @param string $table - name of the table
	 * @param string $database - Name of the database. Defaults to the precurio database
	 * @throws Precurio_Exception
	 * @return Zend_Db_Table
	 */
	public function getTable($table, $database="")
	{
		$db_config = Precurio_Utils::getDbConfig();

		//if no database was provided, or we are connecting to the Precurio database
		if(empty($database) || $database == $db_config['dbname'])
			return  new Zend_Db_Table(array('name'=>$table));

		$db_config['dbname'] = $database;

		$adapter = $db_config['adapter'];
		$params = array();
		foreach ($db_config as $key=>$value) {
			if($key == 'adapter')continue;
			$params[$key] = $value;
		}

		$db = Zend_Db::factory($adapter,$params);
		try
		{
			$db->getConnection();
		}
		catch(Zend_Db_Exception $e)
		{
			throw new Precurio_Exception($e->getMessage(),Precurio_Exception::EXCEPTION_DATABASE_CONNECTION);
		}
		catch(Zend_Exception $e)
		{
			throw new Precurio_Exception($e->getMessage(),Precurio_Exception::EXCEPTION_DATABASE_CONNECTION);
		}

		return new Zend_Db_Table(array('db'=>$db,'name'=>$table));
	}
  /**
	 * If the schema  contains a data property, it processes it.
	 * @return void
	 */
	private function processData()
	{
		if($this->form->viewMode)return;
		if(!isset($this->elementSchema['data']))
			return;

		$data = $this->elementSchema['data']['option'];
		$options = array();

		if(!is_array($data))$data = array($data);

		foreach($data as $option)
		{
			$options[$option] = $option;
		}

		$this->formElement->setOptions(array('multiOptions'=>$options));
	}
	private function processValue()
	{
		//if the form has not been filled at all, or if the form belongs to me and is not in viewMode
		if($this->form->form_id == 0 || ($this->form->isMyForm && !$this->form->viewMode))
		{
			if($this->elementSchema['type'] == 'user')
			{
				$this->setElementValue(Precurio_Session::getCurrentUserId());
			}
			elseif($this->elementSchema['type'] == 'date')
			{
				$this->setElementValue(Precurio_Date::now()->get(Precurio_Date::DATE_SHORT));
			}
			elseif($this->elementSchema['type'] == 'department')
			{
				$this->setElementValue(UserUtil::getUser(Precurio_Session::getCurrentUserId())->getDepartmentId());
			}
			elseif($this->elementSchema['type'] == 'location')
			{
				$this->setElementValue(UserUtil::getUser(Precurio_Session::getCurrentUserId())->getLocationId());
			}
			elseif($this->elementSchema['type'] == 'signature')
			{
				$this->setElementValue(Precurio_Session::getCurrentUserId());
			}
			else
			{
				if(isset($this->elementSchema['default']))
				{
					try
					{
						$this->setElementValue($this->elementSchema['default']);
					}
					catch(Exception $e)
					{

					}
				}
			}
			return;
		}

		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::USER_PROCESS,'rowClass'=>'UserProcess'));
		$userProcess = $table->fetchRow($table->select()->where('form_id = ?',$this->form->form_id)->where('process_id = ?',$this->form->process_id));

		$table = new Zend_Db_Table(array('name'=>$userProcess->getTableName()));
		$form = $table->fetchRow($table->select()->where('id = ?',$this->form->form_id));
		$elementName = $this->elementSchema['name'];
		$this->setElementValue($form[$elementName]);
	}
	private function setElementValue($value)
	{
		if(!$this->form->viewMode)
		{
			$this->formElement->setValue($value);
			return;
		}
		else
		{
			if($this->elementSchema['control'] == 'file')
			{
				$baseUrl = Zend_Controller_Front::getInstance()->getRequest()->getBaseUrl();
				$dir = Precurio_FileElement::DIR;
				$value = "<a href='$baseUrl$dir/$value' target='_blank'>$value</a>";
				$this->formElement->setAttrib('escape',false);
				$this->formElement->setValue($value);
				return;
			}
			if($this->elementSchema['type']=='currency')
			{
				$config = Zend_Registry::get('config');
				$symbol = isset($config->currency_symbol) ? $config->currency_symbol : '$';

				$amt = $value;
				$amt = $symbol.number_format($amt);
				$this->formElement->setValue($amt);
				return;

			}
			$this->formElement->setValue($value);
//			use code below if id was inserted into db insted of label @mayorbrain 24/04/2014
//			if(isset($this->elementSchema['datasource']))
//			{
//				$datasource = $this->elementSchema['datasource'];
//				$fields = array();
//
//				$table = new Zend_Db_Table(array('name'=>$datasource['tablename']));
//				$where =  (string)$datasource['indexfield'].' = '.(string)$value ;
//				$row = $table->fetchRow($where);
//
//				$labelKeys = explode(',',$datasource['labelfield']);
//				$seperator = " ";
//				$str = "";
//				if(count($labelKeys)==1)//if the label keys are NOT more than one
//				{
//					$str = $row[$datasource['labelfield']];
//				}
//				else
//				{
//					foreach($labelKeys as $labelKey)
//					{
//						$str .= $row[$labelKey] . $seperator;
//					}
//				}
//				$this->formElement->setValue($str);
//				unset($table);unset($row);
//				return;
//			}


		}
	}
    public function processApprovalButtons()
	{
		$tr = Zend_Registry::get('Zend_Translate');
		$approve = new Zend_Form_Element_Submit('submit',array('class'=>'standout'));

		$approve->setDecorators(array(
//        'ViewHelper',
		array('Description',array('escape'=>false,'tag'=>'span')), //escape false because I want html output
		array(array('button' => 'HtmlTag'), array('tag' => 'div', 'class' => 'buttons')),
        array('HtmlTag', array('tag' => 'td','class'=>'alt','colspan'=>'3')),
        array(array('label' => 'HtmlTag'), array('tag' => 'td','class'=>'alt')),
		array(array('row' => 'HtmlTag'), array('tag' => 'tr')),
        ));
		$baseUrl = Zend_Controller_Front::getInstance()->getRequest()->getBaseUrl();

		$approve->setDescription('<button type="submit" class="standout">
    	    		'.$tr->translate('Approve').'
    	</button>  <a class="negative" style="float: auto;" href="' . $baseUrl . '/workflow/process/reject/id/'.$this->form->getUserProcessId().'" rel="facebox">'.$tr->translate('Reject').'</a>');
		$approve->setLabel($tr->translate('Approve'));
		return $approve;

	}
  	public static function getOptionsArray($options,$valueKey='id',$labelKey='title',$addNullOption = false)
	{
		$return = array();
		if($addNullOption)
		{
			$return[0] = '';
		}
		$labelKeys = explode(',',$labelKey);
		$seperator = " ";
		foreach($options as $key=>$option)
		{
			if(isset($option[$valueKey]))
			{
				if(count($labelKeys)==1)//if the label keys are NOT more than one
				{
					$return[$option[$valueKey]] = $option[$labelKey];
				}
				else
				{
					foreach($labelKeys as $labelKey)
					{
						if(!isset($return[$option[$valueKey]]))$return[$option[$valueKey]] = "";
						$return[$option[$valueKey]] .= $option[$labelKey] . $seperator;
					}
				}
			}
			else
				$return[$key] = $option;//totally ignore other params
		}
		return $return;
	}
	/**
	 * @param $options Zend_Db_Rowset_Abstract
	 * @param $labelKey string
	 * @return array
	 */
	private function getDataSourceArray($options,$labelKey)
	{
		$required = $this->elementSchema['required']=='true' ? true : false;
		$return = array();
		if(!$required)
		{
			//$return[0] = '';
		}
		$labelKeys = explode(',',$labelKey);
		$seperator = " ";
		foreach($options as $key=>$option)
		{
				if(count($labelKeys)==1)//if the label keys are NOT more than one
				{
					$label = $option[$labelKey];
				}
				else
				{
					$label = "";
					foreach($labelKeys as $labelKey)
					{
						$label .= $option[$labelKey] . $seperator;
					}
				}
				$return[$label] = $label;

		}
		return $return;
	}
  /**
	 * @param $elementName
	 * @return Zend_Form_Element
	 */
	public function getFormElement($elementName='')
	{
		if($elementName == '')
			$elementName = $this->elementSchema['name'];

		if($this->form->viewMode)return new Precurio_PlainText($elementName);

		switch ($this->elementSchema['control'])
		{
			case 'button':
				return new Zend_Form_Element_Button($elementName);
				break;
			case 'captcha':
				return new Zend_Form_Element_Captcha($elementName);
				break;
			case 'checkbox':
				return new Precurio_Checkbox($elementName);
				break;
			case 'file':
				$e = new Precurio_FileElement($elementName);
				$root = Zend_Registry::get('root');
				$e->setRequired(false);
				return $e;
				break;
			case 'hash':
				return new Zend_Form_Element_Hash($elementName);
				break;
			case 'hidden':
				return new Zend_Form_Element_Hidden($elementName);
				break;
			case 'image':
				return new Zend_Form_Element_Image($elementName);
				break;
			case 'multi':
				return new Zend_Form_Element_Multi($elementName);
				break;
			case 'multicheckbox':
				return new Zend_Form_Element_MultiCheckbox($elementName);
				break;
			case 'multiselect':
				return new Zend_Form_Element_Multiselect($elementName);
				break;
			case 'password':
				return new Zend_Form_Element_Password($elementName);
				break;
			case 'radio':
				return new Zend_Form_Element_Radio($elementName);
				break;
			case 'reset':
				return new Zend_Form_Element_Reset($elementName);
				break;
			case 'select':
				return new Zend_Form_Element_Select($elementName);
				break;
			case 'submit':
				return new Zend_Form_Element_Submit($elementName);
				break;
			case 'text':
				return new Zend_Form_Element_Text($elementName);
				break;
			case 'textarea':
				return new Zend_Form_Element_Textarea($elementName);
				break;
			case 'label':
				return new Precurio_PlainText($elementName);
				break;
			default:
				return new Zend_Form_Element_Hidden($elementName);
				break;
		}
	}

}


?>