<?php
require_once ('user/models/vo/User.php');
require_once ('user/models/vo/Role.php');
class Precurio_Acl extends Zend_Acl {
	/**
	 * @var Precurio_Acl
	 */
	protected static $_instance = null;

	protected $_privileges;
	private function __construct()
	{}

	private function __clone()
	{}

	/**
	 * @param $resources Array of Precurio_Resource objects
	 * @param $roles Array of Role objects
	 * @return null
	 */
	public function initialise($resources,$roles)
	{
		$db = Zend_Registry::get('db');

		$count = 0;
		foreach($resources as $resource)
		{
			if(!$resource->isValid())continue;
			$count++;//count the number of valid resource
			$this->add($resource);
		}
		if($count == 0)return;//if there are no valid resources exit function.
		foreach($roles as $role)
		{
			$this->addRole($role);
		}

		//finally get rules and build access control list (acl);
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::RULES));
		$rules = $table->fetchAll();
		foreach ($rules as $rule)
		{
			if(!$this->has($rule['resource']))continue;
			if(!$this->hasRole($rule['role_id']))continue;

			if(Precurio_Utils::isNull($rule['privilege']))$rule['privilege'] = null;
			if(Precurio_Utils::isNull($rule['resource']))$rule['resource'] = null;
			if(Precurio_Utils::isNull($rule['role_id']))$rule['role_id'] = null;

			//echo($rule['role_id']." ".$rule['resource']." ".$rule['privilege']."<br>");
			if($rule['allow'] == 1)
				$this->allow($rule['role_id'],$rule['resource'],$rule['privilege']);
			else
				$this->deny($rule['role_id'],$rule['resource'],$rule['privilege']);

		}

	}
	/**
	 * This function is recursive
	 * @param Precurio_Resource $resource the resource you are adding
	 */
	public function add($resource)
	{
		$parent  = $resource->getParent();
		if(!$this->has($parent))
		{

			if(Precurio_Utils::isNull($parent))//there is no parent.
			{
				$parent = null; //this will make parent::add ignore the $parent param
			}
			else
			{
				$this->add($parent);
			}


		}


		if($this->has($resource))return;//dont bother if the resource already exists

		return parent::add($resource,$parent);

	}
	/**
	 * @param Role $role
	 */
	public function addRole($role)
	{
		if(Precurio_Utils::isNull($role))return;
		$parent = $role->getParent();

		if(!$this->hasRole($parent))
		{

			if(Precurio_Utils::isNull($parent))
			{
				$parent = null; //this will make parent::add ignore the $parent param
			}
			else
			{
				$this->addRole($parent);
			}

		}
		if($this->hasRole($role))return;


		parent::addRole($role,$parent);

	}
	/**
	 * @return Precurio_Acl
	 */
	public static function getInstance()
    {
	   if (null === self::$_instance) {
		self::$_instance = new self();
	   }

	   return self::$_instance;
    }

}

?>