<?php
/**
 * @author Mayor Brain
 * This file contains functions that will send mails in the mail queue
 */
	function runMailQueue()
	{
		$mails = getOutBox();
		if(empty($mails))
		{
			system_log("No mails in queue.");
			return;
		}

		foreach($mails as $mail)
		{
			sendMail($mail);
		}

	}
	function getOutBox()
	{
		$mails = array();
		//select the first 100 mails that have not been sent, and have not been re-tried 10 times
		$table = new Zend_Db_Table(array('name'=>"mail_queue"));

		$rows = $table->fetchAll($table->select()->where("sent = 0")->where("error_count < 10")->order("id DESC")->limit(100));
		foreach($rows as $row)
		{
			$mails[] = $row;
		}
		return $mails;
	}
	/**
	 * @param  Zend_Db_Table_Row_Abstract $mail
	 */
	function sendMail($mail)
	{
		$arr = explode(";",$mail->to);
		if(count($arr) > 1 || true)
		{
			failSafeMail($mail);
			return;
		}

		$from = $mail->from; // from mail address
		$to   = $mail->to; // to mail address

		if(!isValidEmail($to))
		{
			$result = $mail->delete();
			system_log("No Valid Recipient. Deleted Mail Queue".$mail->id );
			return;
		}

		$subj = $mail->subject; // mail subject
		$text = $mail->body; // text/plain version of message
		$html = htmlWrap($mail->body, $mail->subject); // text/html version of message

		// set text/plain version of message
		$msg1 = MIME5::message($text, 'text/plain');
		// set text/html version of message
		$msg2 = MIME5::message($html, 'text/html');
		// compose message in MIME format
		$mess = MIME5::compose($msg1, $msg2);
		// standard mail message RFC2822
		$body = 'From: '.$from."\r\n".
				'To: '.$to."\r\n".
				'Subject: '.$subj."\r\n".
				$mess['header']."\r\n\r\n".
				$mess['content'];

		// get client hostname
		$expl = explode('@', $to);

		// connect to SMTP server (direct) from MX hosts list
		$conn = SMTP5::mxconnect($expl[1]);
		$sent = false;
		if($conn)
			$sent = SMTP5::send($conn, array($to), $body, $from);

		// print result
		if ($sent)
		{
			$date_created = time();
			$mail->sent = 1;
			$mail->date_sent = $date_created;
			$mail->save();
			system_log( "SUCESS Mail [ID : $mail->id] sent, using hand-shaking mode");
		}
		else
		{
			$mail->error_count = $mail->error_count + 1;
			$mail->save();
            system_log( "FAILURE Mail [ID : $mail->id] not sent, using hand-shaking mode");
			failSafeMail($mail);
		}

		// disconnect from SMTP serv
		SMTP5::disconnect($conn);
	}

	/**
	 * This uses the normal smtp auth mail mechanism
	 * @param   Zend_Db_Table_Row_Abstract $mail
	 * @return void
	 */
	function failSafeMail($mail)
	{

		$config = Zend_Registry::get("config");

		$smtp_server = $config->mail->server;
		$smtp_port = (int)$config->mail->port;
		$auth_user =  $config->mail->username;
		$auth_pass =  $config->mail->password;
		$auth_mech =  $config->mail->auth;

		$ssl = empty($config->mail->use_secure) ? null :  $config->mail->ssl;
		$host = substr( $config->email_domain,1);//the substr removes the @ sign at the beginning
		// initialize MAIL class
		$m = new MAIL5;
		// set from address
		if(!isValidEmail($mail->from))
		{
			$mail->delete();
			system_log("Invalid Mail Sender. Deleted Mail Queue".$mail->id );
			return;
		}
		$m->From($mail->from);
		// add to address
		$arr = explode(";",$mail->to);
		$numOfRecepients = 0;
		foreach($arr as $email)
		{
			if(!isValidEmail($email))
				continue;
			$numOfRecepients++;
			system_log("Sending email to $email");
			$m->AddTo($email);
		}
		if($numOfRecepients == 0)
		{
			$mail->delete();
			system_log("No email recepients. Deleted Mail Queue".$mail->id );
			return;
		}

		// set subject
		$m->Subject($mail->subject);
		// set HTML message
		$m->Html(htmlWrap($mail->body,$mail->subject));

		// connect to MTA server 'smtp.gmail.com' port '465' via SSL ('tls' encryption) with authentication: 'username@gmail.com'/'password'
		// set the connection timeout to 10 seconds, the name of your host 'localhost' and the authentication method to 'plain'
		// make sure you have OpenSSL module (extension) enable on your php configuration
		$c = $m->Connect($smtp_server, $smtp_port, $auth_user,$auth_pass,$ssl,null,null,null,$auth_mech,true);
		if($c == false)
		{
			print_r($m->Result);
			return;
		}

		// send mail relay using the '$c' resource connection
		$sent = $m->Send($c);
		if ($sent)
		{
			$date_created = time();
			$mail->sent = 1;
			$mail->date_sent = $date_created;
			$mail->save();
			system_log( "SUCESS Mail [ID : $mail->id] sent, using fail safe mode");
		}
		else
		{
			$mail->error_count = $mail->error_count + 2;//this is the second time it is failing
			$mail->save();
            system_log( "FAILURE Mail [ID : $mail->id] not sent, using fail safe mode");
		}
		// disconnect from server
		$m->Disconnect();
	}
function isValidEmail($email)
	{
		if(empty($email))return false;
		if(eregi("^[_a-z0-9-]+(\.[_a-z0-9-]+)*@[a-z0-9-]+(\.[a-z0-9-]+)*(\.[a-z]{2,3})$", $email)) {
		  return true;
		}
		else {
		  return false;
		}
	}
	/**
	 * Returns a string with some variables replaced. This is a more robust version of the one used by the main app.
	 * E.g.:
	 * $str    = "Page {1}  ({1}/{2})";
	 * $arg1   = "1";
	 * $arg2   = "5";
	 * echo localizedString($str,$arg1,$arg2);
	 * would return: Page 1 (1/5)
	 * @author http://moinne.com/blog/ronald/php/php-function-localizedstring/
	 */
	function getLocalizedString2() {
		$patterns = array();
		$replacements = array();
		$text  = func_get_arg(0);
		$args  = func_get_arg(1);
		if(is_array($args))
		{
			foreach ($args as $name=>$value)
			{
				$patterns[]     = '/\{:'.$name.'\}/';
				$replacements[] = $value;
			}
		}
		else
		{
			$numArgs = func_num_args();
			for ($i = 1; $i < $numArgs; $i++)
			{
			$patterns[] = '/\{'.$i.'\}/';
			$replacements[] = func_get_arg($i);
			}
			}

			return preg_replace ($patterns, $replacements, $text);
	}
    function htmlWrap($message,$subject="",$email_template = "")
    {

    	$config = Zend_Registry::get("config");
        $baseUrl = $config->base_url;

        include 'template_config.php';
        include_once 'email_widgets/recent_contents.php';

        if(empty($email_template))
        	$email_template = file_get_contents('email_template.tpl');

         $data = array(
            'subject'=>$subject,
            'browser_view_url'=>'#',
            'message'=>$message,
            'salutation'=>'Hello,',
            'from'=>$config->mail->admin_name,
            'valediction'=>'Regards,',
            'twitter_page'=>'http://twitter.com/precurio',
            'linkedin_page'=>'http://ng.linkedin.com/in/mayorbrain/',
            'current_year'=>date("Y"),
            'company_name'=>$config->company_name,
            'logo'=>$config->base_url.'/uploads/logo_transparent.png',
            'wgt_recent_contents'=>$recent_contents
        );

        $data = array_merge($data,$template_config);//$template_config is from template_config.php;

        $str = getLocalizedString2($email_template,$data);
        return $str;

    }
?>