<?php
/**
 * @author Mayor Brain
 * This file contains functions that will fetch RSS contents from configured RSS links.
 * @TODO THIS FILE MAKES USE OF simplepie.inc, WHICH IS STILL WRITTEN IN DEPRECEATED MYSQL FUNCTIONS
 */
	function runRSS()
	{

		$table = new Zend_Db_Table(array('name'=>"rss"));
		$rssSources = $table->fetchAll($table->select()->where("active = 1"));

		if(empty($rssSources))
		{
			system_log("No RSS source has been added.");
			return;
		}
		foreach ($rssSources as $rssSource)
		{
			fetchRSS($rssSource->id, $rssSource->url, $rssSource->last_updated);
		}

	}
	function fetchRSS($id,$url,$last_updated)
	{
		$table = new Zend_Db_Table(array('name'=>"rss"));

		$feed = new SimplePie();
		$feed->set_feed_url($url);
		$feed->enable_order_by_date(true);
		$feed->set_cache_location('cache');
		$feed->init();
		$feed->handle_content_type();
		$i = 0;
		if ($feed->data)
		{
			$items = $feed->get_items();
			foreach($items as $item)
			{
				if(!isNewRSS($id,$item))continue;//if item is not new, skip
				insertRSS($id,$item);
				echo '<a href="' . $item->get_link() . '">';
				echo $item->get_title(); if ($item->get_link()) echo '</a> <br/>';
				$i++;//counts number of new inserts
			}

			//the query statement below, will make sure last_updated field is correct
			$rssSource = $table->fetchRow($table->select()->where("id = ?",$id));
			$rssSource->title = $feed->get_title();
			$rssSource->last_updated = time();
			$rssSource->save();

			system_log( "SUCCESS : $i RSS items fetched from '$url'");
		}
		else
		{
			system_log( "FAILURE : Data could not be fetched from '$url'");
		}
	}
	/**
	 * Determines whether a particular RSS Item already exists in the database
	 * @param $rss_id
	 * @param $item
	 * @return Boolean
	 */
	function isNewRSS($rss_id,$item)
	{

		$item_id = $item->get_id();

		$table = new Zend_Db_Table(array('name'=>"rss_content"));
		$row = $table->fetchRow($table->select()->where("rss_id = ?",$rss_id)->where("rss_item_id = ?",$item_id));

		return empty($row);

	}
	/**
	 * Inserts RSS item into database
	 * @param $rss_id
	 * @param $item SimplePie
	 * @return void
	 */
	function insertRSS($rss_id,$item)
	{
		$image_path = "";
		$keyword = "";
		$author = "";
		if($source = $item->get_source())
		{
			$image_path = $source->get_image_url();
		}
		if($categorys = $item->get_categories())
		{
			foreach($categorys as $category)
				$keyword .= $category->get_label().' ';
		}
		if($authorObj = $item->get_author())
		{
			$author = $authorObj->get_name();
		}
		$item_id = $item->get_id();
		$title = addslashes(strip_tags($item->get_title() ));
		$summary = addslashes(strip_tags($item->get_description()));
		$user_id = 0;
		$url = $item->get_permalink();
		$date_created  = strtotime($item->get_date());
		$active = 1;

		$table = new Zend_Db_Table(array('name'=>"content"));

		$content_id = $table->insert(array(
				'title'=>$title,
				'image_path'=>$image_path,
				'summary'=>$summary,
				'user_id'=>$user_id,
				'url'=>$url,
				'keyword'=>$keyword,
				'publish_as_news'=>1,
				'publish_as_rss'=>1,
				'is_document'=>0,
				'date_created'=>$date_created,
				'active'=>1,
				'is_public'=>1
		));

		if($content_id)
        {
        	$table = new Zend_Db_Table(array('name'=>"rss_content"));
        	$table->insert(array(
        			'rss_id'=>$rss_id,
        			'content_id'=>$content_id,
        			'rss_item_id'=>$item_id,
        			'author'=>$author,
        			'date_created'=>$date_created
        	));
		}
        else
        {
            system_log( "Could not insert new RSS item. '$title'");
        }

	}

?>