<?php
require_once ('EmailMessage.php');
require_once ('cms/models/vo/Content.php');
function runEmail()
{
	$userEmails = getUserEmails();
	foreach($userEmails as $userEmail)
	{
		getInbox($userEmail);
	}
}


/**
 * Return active user emails
 * @return Zend_Db_Table_Rowset_Abstract
 */
function getUserEmails()
{
	$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::USER_EMAILS));
	$rows = $table->fetchAll($table->select()->where('active = 1')->where('status = 1'));
	return $rows;

}
function getInbox($userEmail)
{
	$host = $userEmail->server.':'.$userEmail->port;
	if(!empty($userEmail->ssl))
		$host = $host.'/'.$userEmail->ssl;

	$mbox = imap_open ("{{$host}}INBOX",$userEmail->email,$userEmail->password);
	//@todo check if connection was succesful
	$lastMessage = getLastLocalMessage($userEmail);
	if(empty($lastMessage))//no message has been gotten from this email
	{
		//get most recent mail form server

		$lastMessage = getLastRemoteMessage($mbox,$userEmail);
		return;
	}



	$mailInfo = imap_mailboxmsginfo($mbox);
	if($mailInfo)
	{
		$message_count = imap_num_msg($mbox);
		$i = $message_count;
		$header = "";
		$body = "";
		$attachments = array();
		getRemoteMessage($mbox, $i, $header, $body,$attachments);

		$found = false;
		//Note that execution will not get to this point if there isn't atleast one message in the local db
		while (!empty($header) && $header->message_id != $lastMessage->message_id && !$found)
		{
			system_log("New Message found in ".$userEmail->email.'; From '.$header->fromaddress);

			saveRemoteMessage($userEmail, $header, $body,$attachments);

			$i--;
			$header = "";
			$body = "";
			$attachments = array();

			getRemoteMessage($mbox, $i, $header, $body,$attachments);
			$found = message_exists($userEmail->id,$header->message_id);
		}

		if(strtolower($mailInfo->Driver) == 'imap')
		{
			synchroniseOutbox($mbox);
		}
	}
	else
	{
		system_log("Failed getting mailbox info: " . imap_last_error() );
	}
	//$list = imap_list($mbox, "{imap.gmail.com:993/ssl}", "*");

	imap_close($mbox);
}
/**
 * Get last message on the local db
 * @param Zend_Db_Table_Row $userEmail
 * @return EmailMessage
 */
function getLastLocalMessage($userEmail)
{
	$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::EMAIL_MESSAGES,'rowClass'=>'EmailMessage'));
	return $table->fetchRow($table->select()->where('user_email_id = ?',$userEmail->id)
										->where("mailbox = 'INBOX'")
										->order('id desc'));
}

/**
 * Gets the most recent email in that email account, saves it in local db and returns EmailMessage object
 * @param resource $mbox - mailbox connection resource
 * @param Zend_Db_Table_Row $userEmail
 * @return EmailMessage
 */
function getLastRemoteMessage($mbox,$userEmail)
{
	$message_count = imap_num_msg($mbox);
	$header = "";
	$body = "";
	getRemoteMessage($mbox, $message_count, $header, $body);
	return saveRemoteMessage($userEmail, $header, $body);
}
/**
 * Enter description here ...
 * @param resource $mbox
 * @param integer $msg_num
 * @param stdClass $header - Will contain the message header
 * @param string $body - Will contain the html part of the email (we ignore the plain text part)
 * @param array $attachments - Will contain the attachements in the email message, already saved as file. i.e. it will contain array of file names
 */
function getRemoteMessage($mbox,$msg_num,&$header,&$body=null,&$attachments=null)
{
	$header = imap_header($mbox, $msg_num);
	$fetchOption = FT_PEEK; //$fetchOption == message read option.
	if(!is_null($body))
	{
		$msg_txt = "";
		$msg_html = "";

		$msg = new message_components($mbox);
		$msg->fetch_structure($msg_num);

		foreach($msg->file_type[$msg_num] as $i=>$file_type)
		{

			$part = (string)$msg->pid[$msg_num][$i];
			if(strtolower($file_type) == 'text/html')
			{
				system_log("Fetching html part for email $msg_num");
				$msg_html = imap_fetchbody($mbox, $msg_num, $part ,$fetchOption);
				$msg_html = text_decode($msg_html,$msg->encoding[$msg_num][$i]);
			}

			if(strtolower($file_type) == 'text/plain')
			{
				system_log("Fetching plain part for email $msg_num");
				$msg_plain = imap_fetchbody($mbox, $msg_num, $part ,$fetchOption);
				$msg_plain = text_decode($msg_plain,$msg->encoding[$msg_num][$i]);
			}
		}

		$body = $msg_html;
		if (empty($body))
		    $body = $msg_plain;
	}

	if(!is_null($attachments))
	{
		$root = Zend_Registry::get('root');
		foreach($msg->disposition[$msg_num] as $i=>$disp)
		{
			$part = (string)$msg->pid[$msg_num][$i];
			if(strtolower($disp) == 'attachment')
			{
				system_log("Fetching attachment for email $msg_num");
				$content = imap_fetchbody($mbox, $msg_num, $part ,$fetchOption);
				$content = text_decode($content,$msg->encoding[$msg_num][$i]);
				$filename = $msg->fname[$msg_num][$i];
				file_put_contents($root.'/public/'.Content::PATH_TMP.$filename, $content);
				$attachments[] = $filename;
			}

		}
	}
	return;
}
function text_decode($text,$encoding)
{
	if($encoding == 'base64')
	{
   		return imap_base64($text);
   	} else if($encoding == 'quoted-printable' || $encoding == '7bit')
   	{
   		return imap_qprint($text);
   	} else
   	{
   		system_log("No decoding for encoding type $encoding" );
   		return $text;
   	}
}
/**
 * Saves a remote message to local db
 * @param Zend_Db_Table_Row $userEmail
 * @param stdClass $header
 * @param string $body
 * @param array $attachments
 * @return EmailMessage
 */
function saveRemoteMessage($userEmail,$header,$body,$attachments)
{
	//save message
	$data = array(
	'user_id'=>$userEmail->user_id,
	'user_email_id'=>$userEmail->id,
	'message'=>$body,
	'mailbox'=>'INBOX',
	'message_id'=>$header->message_id,
	'from_address'=>$header->fromaddress,
	'to_address'=>$header->toaddress,
	'cc_address'=>isset($header->ccaddress) ? $header->ccaddress : '',
	'bcc_address'=>isset($header->bccaddress) ? $header->bccaddress : '',
	'reply_address'=>isset($header->reply_toaddress) ? $header->reply_toaddress : '',
	'sender_address'=>isset($header->senderaddress) ? $header->senderaddress : '',
	'return_address'=>isset($header->return_pathaddress) ? $header->return_pathaddress : '',
	'subject'=>$header->subject,
	'in_reply_to'=>isset($header->in_reply_to) ? $header->in_reply_to : '',
	'followup_to'=>isset($header->followup_to) ? $header->followup_to : '',
	'is_recent'=>empty($header->Recent) || $header->Recent == ' ' ? 0 : 1,
	'is_seen'=> ($header->Recent == 'N' || $header->Unseen == 'U') ? 0 : 1 ,
	'is_flagged'=>empty($header->Flagged) || $header->Flagged == ' ' ? 0 : 1,
	'is_deleted'=>empty($header->Deleted) || $header->Deleted == ' ' ? 0 : 1,
	'is_draft'=>empty($header->Draft) || $header->Draft == ' ' ? 0 : 1,
	'message_size'=>$header->Size,
	'message_date'=>$header->udate,
	'date_created'=>time(),
	'active'=>1,
	);

	$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::EMAIL_MESSAGES,'rowClass'=>'EmailMessage'));
	$row = $table->createRow($data);
	$id = $row->save();

	system_log("Saved email message {$header->Msgno} with ID $id");

	//save attachments

	foreach($attachments as $filename)
	{
		try
		{
			$arr = array(
				'file'=>$filename,
				'parent_id'=>RootFolder::SPECIAL_ID_PRIVATE,
				'user_id'=>$userEmail->user_id,
				'date_created'=>time()
			);
			$document_id = Documents::createNew($arr, new RootFolder(Category::ACCESS_PRIVATE));

			$arr2 = array(
				'user_id'=>$userEmail->user_id,
				'email_message_id'=>$id,
				'document_id'=>$document_id,
				'date_created'=>time()
			);
			$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::EMAIL_DOCUMENTS));
			$table->insert($arr2);
			system_log("Saved email attachment $filename with Document ID $document_id");
		}
		catch (Exception $e)
		{
			echo "Error saving attachment.";print_r($arr);print_r($arr2);
		}
	}

	return $row;

}

function message_exists($user_email_id,$message_id)
{
	$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::EMAIL_MESSAGES));
	$row = $table->fetchRow($table->select()->where('user_email_id = ?',$user_email_id)
										->where("message_id = ?",$message_id));
	return !empty($row);
}
/**
 * Synchronise sent messages for an imap mailbox
 * @param imap_resource $mbox
 */
function synchroniseOutbox($mbox)
{

}














class message_components {

        /**
         *+----------------------------------------------------------------------------------------------------+
         *| IMAP message scanner - scans information provided by imap_fetchstructure()                         |
         *|                                                                                                    |
         *| Author: Richard York                                                                               |
         *| mailto:richy at smilingsouls.net                                                                    |
         *| http://www.smilingsouls.net                                                                        |
         *|                                                                                                    |
         *| (c) Copyright 2004, Richard York, All Rights Reseverd                                              |
         *+----------------------------------------------------------------------------------------------------+
         **
        */

        var $mailbox;           // (resource)              Imap stream

        var $data_types;        // (array)(string)         Various message part types
        var $encoding_types;    // (array)(string)         Various encoding types

        // first array uses message id as key
        // nested array is offset corresponding with the number of parts

        var $structure;         // (array)(object)         Contains the complete body structure
        var $pid;               // (array)(array)(str)     part id
        var $file_type;         // (array)(array)(str)     mime type
        var $disposition;       // (array)(array)(str)     inline | attachment
        var $fsize;             // (array)(array)(int)     part size in bytes
        var $encoding;          // (array)(array)(str)     message encoding
        var $fname;             // (array)(array)(str)     original file name
        var $inline_id;         // (array)(array)(str)     string containing the id for multipart/related
        var $has_attachments;   // (array)(array)(bool)

        /**
         * CONSTRUCTOR
         *
         * void message_components(resource imap stream)
         **
        */

        function __construct($mailbox)
        {
            $this->data_types = array();

                $this->data_types[0] = 'text';
                $this->data_types[1] = 'multipart';
                $this->data_types[2] = 'message';
                $this->data_types[3] = 'application';
                $this->data_types[4] = 'audio';
                $this->data_types[5] = 'image';
                $this->data_types[6] = 'video';
                $this->data_types[7] = 'other';

            $this->encoding_types = array();

                $this->encoding_types[0] = '7bit';
                $this->encoding_types[1] = '8bit';
                $this->encoding_types[2] = 'binary';
                $this->encoding_types[3] = 'base64';
                $this->encoding_types[4] = 'quoted-printable';
                $this->encoding_types[5] = 'other';

            $this->mailbox = $mailbox;

            return;
        }

        /**
         * void fetch_structure(int message id[, array recursive subpart[, array recursive parent part id[, int recursive counter[, bool recursive is a sub part[, bool recursive skip part]]]]])
         * Indexes the structure of a message body.
         *
         * Gather message information returned by imap_fetchstructure()
         * Recursively iterate through each parts array
         * Concatenate part numbers in the following format `1.1` each part id is separated by a period, each referring
         * to a part or subpart of a multipart message.  Create part numbers as such that they are compatible with imap_fetchbody()
         **
        */

        function fetch_structure($mid, $sub_part = null, $sub_pid = null, $n = 0, $is_sub_part = false, $skip_part = false)
        {
            if (!is_array($sub_part))
            {
                $this->structure[$mid] = imap_fetchstructure($this->mailbox, $mid);
            }

            if (isset($this->structure[$mid]->parts) || is_array($sub_part))
            {
                if ($is_sub_part == false)
                {
                    $parts = $this->structure[$mid]->parts;
                }

                else
                {
                    $parts = $sub_part;
                    $n++;
                }

                for($p = 0, $i = 1; $p < count($parts); $n++, $p++, $i++)
                {
                    // Skip the following...
                    // Skip multipart/mixed!
                    // Skip subsequent multipart/alternative if this part is message/rfc822
                    // Skip multipart/related

                    $ftype        = (empty($parts[$p]->type))?           $this->data_types[0].'/'.strtolower($parts[$p]->subtype) : $this->data_types[$parts[$p]->type].'/'.strtolower($parts[$p]->subtype);
                    $encoding     = (empty($parts[$p]->encoding))?       $this->encoding_types[0] : $this->encoding_types[$parts[$p]->encoding];
                    $skip_next    = ($ftype == 'message/rfc822')?        true : false;

                    if ($ftype == 'multipart/mixed' || $skip_part == true && $ftype == 'multipart/alternative' || $ftype == 'multipart/related')
                    {
                        $n--;
                    }

                    else
                    {
                        $this->pid[$mid][$n]       = ($is_sub_part == false)? $i : $sub_pid.'.'.$i;
                        $this->file_type[$mid][$n] = $ftype;
                        $this->encoding[$mid][$n]  = $encoding;
                        $this->fsize[$mid][$n]     = (!isset($parts[$p]->bytes) || empty($parts[$p]->bytes))? 0 : $parts[$p]->bytes;

                        # Force inline disposition if none is present

                        if ($parts[$p]->ifdisposition == true)
                        {
                            $this->disposition[$mid][$n] = strtolower($parts[$p]->disposition);

                            if (strtolower($parts[$p]->disposition) == 'attachment')
                            {
                                if ($parts[$p]->ifdparameters == true)
                                {
                                    $params = $parts[$p]->dparameters;

                                    foreach ($params as $param)
                                    {
                                        if(strtolower($param->attribute) == 'filename')
                                        {
                                            $this->fname[$mid][$n] = $param->value;
                                            break;
                                        }
                                    }
                                }
                            }
                        }

                        else
                        {
                            $this->disposition[$mid][$n] = 'inline';
                        }

                        if ($parts[$p]->ifid == true)
                        {
                            $this->inline_id[$mid][$n] = $parts[$p]->id;
                        }
                    }

                    if (isset($parts[$p]->parts) && is_array($parts[$p]->parts))
                    {
                        $this->has_attachments[$mid][$n] = true;
                        $n = $this->fetch_structure($mid, $parts[$p]->parts, $this->pid[$mid][$n], $n, true, $skip_next);
                    }

                    else
                    {
                        $this->has_attachments[$mid][$n] = false;
                    }
                }

                if ($is_sub_part == true)
                {
                    return $n;
                }
            }

            // $parts is not an array... message is flat
            else
            {
                $this->pid[$mid][0] = 1;

                if (empty($this->structure[$mid]->type))
                {
                    $this->structure[$mid]->type        = (int) 0;
                }

                if (isset($this->structure[$mid]->subtype))
                {
                    $this->file_type[$mid][0]            = $this->data_types[$this->structure[$mid]->type].'/'.strtolower($this->structure[$mid]->subtype);
                }

                if (empty($this->structure[$mid]->encoding))
                {
                    $this->structure[$mid]->encoding    = (int) 0;
                }

                $this->encoding[$mid][0]                = $this->encoding_types[$this->structure[$mid]->encoding];

                if (isset($this->structure[$mid]->bytes))
                {
                    $this->fsize[$mid][0]                = strtolower($this->structure[$mid]->bytes);
                }

                $this->disposition[$mid][0]             = 'inline';
            }

            return;
        }
    }
/*
    // Define $mb here in a call to imap_open()
    $mb = @imap_open('{mail.yourdomain.com:110/pop3/notls}INBOX', 'user', 'pass');

    // Example usage -- dump part ids for the specified message..

    $msg =& new message_components($mb);
    $msg->fetch_structure(3);

    echo '<pre>';
    var_dump($msg->pid[3]);
    echo '</pre>';

    // also important to note that the offset numbering in the sub array isn't precise... $msg->pid[$mid][0]..
    // I have a bug somewhere in there.. but I use foreach when accessing these arrays anyway.
*/
?>