<?php

require_once 'workflow/models/ProcessManager.php';

class UserProcessHistory extends Precurio_ItemHistory
{
	const TYPE_REQUEST_CREATED = 0;
	const TYPE_WAITING_APPROVAL = 1;
	const TYPE_REQUEST_APPROVED = 2;
	const TYPE_REQUEST_REJECTED = 3;
	const TYPE_REQUEST_TRANSFERED = 4;
	const TYPE_NEW_COMMENT = 5;
	const TYPE_FILE_ADDED = 6;
	const TYPE_FILE_REMOVED = 7;
	const TYPE_PROCESS_COMPLETED = 8;

	public function getMessage()
	{
		switch ($this->type) {
			case self::TYPE_REQUEST_CREATED:
				$user = UserUtil::getUser($this->user_id);
				$msg = $this->translate("Request created by").' '.$this->userProfileWrap($user);
				return $msg;
			break;
			case self::TYPE_WAITING_APPROVAL:
				$user = UserUtil::getUser($this->new_value);
				$msg = $this->translate('Request is pending approval from').' '.$this->userProfileWrap($user).'.';
				return $msg;
			break;
			case self::TYPE_REQUEST_APPROVED:
				$user = UserUtil::getUser($this->user_id);
				$msg = $this->translate("Request is approved by").' '.$this->userProfileWrap($user);
				return $msg;
			break;
			case self::TYPE_REQUEST_REJECTED:
				$user = UserUtil::getUser($this->user_id);
				$msg = $this->translate("Request is declined by").' '.$this->userProfileWrap($user);
				return $msg;
			break;
			case self::TYPE_REQUEST_TRANSFERED:
				$user = UserUtil::getUser($this->user_id);
				$msg = $this->translate("Request is transfered to").' '.$this->userProfileWrap($user);
				return $msg;
			break;
			case self::TYPE_NEW_COMMENT:
				$user = UserUtil::getUser($this->user_id);
				$msg = $this->translate("New comment on request by").' '.$this->userProfileWrap($user);
				return $msg;
			break;

			case self::TYPE_FILE_ADDED:
				$user = UserUtil::getUser($this->user_id);
				$document = Document::get($this->new_value);
				$msg = $document->getTitle().' '.$this->translate('has been attached to this request by').' '.$this->userProfileWrap($user);
				return $msg;
			break;
			case self::TYPE_FILE_REMOVED:
				$user = UserUtil::getUser($this->user_id);
				$document = Document::get($this->new_value);
				$msg = $document->getTitle().' '.$this->translate('has been deleted from this request.');
				return $msg;
			break;
			case self::TYPE_PROCESS_COMPLETED:
				$user = UserUtil::getUser($this->user_id);
				$msg = $this->translate('Request is now completed with status'.' '.$this->new_value);
				return $msg;
			break;
		}
	}

	public function getIconFile()
	{
		switch ($this->type) {
			case self::TYPE_REQUEST_CREATED:
				return 'workflow_small.png';
			case self::TYPE_WAITING_APPROVAL:
				return 'time.png';
			case self::TYPE_REQUEST_APPROVED:
				return 'tick.png';
			case self::TYPE_REQUEST_REJECTED:
				return 'delete.png';
			case self::TYPE_REQUEST_TRANSFERED:
				return 'transfer.png';
			case self::TYPE_FILE_ADDED:
				return 'add_file.png';
			case self::TYPE_FILE_REMOVED:
				return 'remove.png';
			case self::TYPE_NEW_COMMENT:
				return 'chat.png';
			case self::TYPE_PROCESS_COMPLETED:
				return 'workflow_small.png';
		}
	}

/**
	 * Creates a new history. (History is caused by change)
	 * @param int $user_process_id  - ID of UserProcess
	 * @param int $type - type of change
	 * @param multitype $new_value
	 * @param multitype $old_value
	 * @return null
	 */
	public static function createNew($user_process_id,$type,$new_value="",$old_value="")
	{
		$userProcess = ProcessManager::getUserProcess($user_process_id);
		$startProcess = $userProcess->getStartProcess();

		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::USER_PROCESS_HISTORY));
		$table->insert(array(
			'user_process_id'=>$startProcess->getId(),
			'user_id'=>Precurio_Session::getCurrentUserId(),
			'type'=>$type,
			'old_value'=>$old_value,
			'new_value'=>$new_value,
			'date_created'=>time()
		));
	}
}
?>