<?php

/**
 * TravelController
 * 
 * @author mayorbrain
 * @version 
 */
require_once 'Zend/Controller/Action.php';
require_once 'user/models/UserUtil.php';
require_once 'workflow/models/vo/Process.php';
require_once 'workflow/models/vo/ProcessState.php';
require_once 'workflow/models/vo/UserProcess.php';
require_once 'workflow/models/ProcessForm.php';
require_once 'workflow/models/ProcessManager.php';

class Workflow_TravelController extends Zend_Controller_Action
{

    /**
     * The default action - show the home page
     */
    public function indexAction()
    {
        $this->_forward("new");
    }
    /**
     * User wants to submit a new travel request
     */
    public function newAction()
    {
        $userId = Precurio_Session::getCurrentUserId();
        $this->view->user = UserUtil::getUser($userId,true);
        $this->view->currency = Zend_Registry::get("config")->currency_symbol;
        
    }
    public function submitAction()
    {
        $this->_helper->layout->disableLayout();
        $this->_helper->viewRenderer->setNoRender(true);
        
        $userId = Precurio_Session::getCurrentUserId();
        
        $params = $this->getRequest()->getParams();
        
        $table = new Zend_Db_Table(array('name'=>"wf_app_data"));
        //see if data already exists
        $row = $table->fetchRow($table->select()->where('form_id = ?',$params['post']['form_id'])->where('process_id = ?',$params['post']['process_id']));
        if(empty($row)){ //new form
            $table->insert(array(
                'form_id'=>$params['form_id'],
                'process_id'=>$params['process_id'],
                'user_id'=>$userId,
                'data'=>json_encode($params['post']),
                'date_created'=>time(),
                'active'=>1
            ));
        }
        else{ //update existing
            //do nothing for now
        }
        
        $this->_redirect('/workflow');
    }
    
    public function viewAction()
    {
        $userId = Precurio_Session::getCurrentUserId();
        $this->view->user = UserUtil::getUser($userId,true);
        $this->view->currency = Zend_Registry::get("config")->currency_symbol;
        
        $userProcess = $this->view->userProcess ;
        
        $table = new Zend_Db_Table(array('name'=>"wf_app_data"));
        $row = $table->fetchRow($table->select()->where('form_id = ?',$userProcess->form_id)->where('process_id = ?',$userProcess->process_id));
        
        $data = json_decode($row->data);
        $this->view->data = $data;
    }
    
    public function init()
    {
        $root = Zend_Registry::get('root');
        if($this->view->theme != 'default')
            $this->view->addScriptPath($root .  '/application/default/layouts/default/views/workflow/');
        $this->view->addScriptPath($root .  '/application/default/layouts/'.$this->view->theme.'/views/workflow/');
    }
}
