<?php
require_once ('Zend/Db/Table/Row/Abstract.php');
class PrecurioTweet {


	/**
	 * Gets a users twitter profile
	 * @param int $twitter_user_id
	 * @throws Exception
	 * @return UserProfile
	 */
	public static function getUserProfile($twitter_user_id)
	{
		$client = new Zend_Http_Client('http://api.twitter.com/1/users/show.json',self::getConfig());
		$client->setParameterGet('include_entities', 1);
		$client->setParameterGet('user_id', $twitter_user_id);
		try
		{
			$response = $client->request();
		}
		catch(Exception $e)
		{
			throw $e;
		}
		if($response->isError())
		{
			throw new Exception('Something went wrong while trying to retrieve update');
		}

		$data = Zend_Json::decode($response->getBody());
		return new UserProfile($data);
	}
	/**
	 * Returns the tweet user object
	 * @param int $user_id - optional
	 * @return TweetUser
	 */
	public static function getUser($user_id=0)
	{
		if(empty($user_id))$user_id = Precurio_Session::getCurrentUserId();
		$table = new Zend_Db_Table(array('name'=>'wgt_precuriotweet','rowClass'=>'TweetUser'));
		$user =  $table->fetchRow($table->select()->where('user_id=?',$user_id)->where('twitter_user_id IS NOT NULL'));
		if(empty($user))
		{
			throw new Exception('No user',1011);
		}
		return $user;
	}
	/**
	 * This is called once the user has accepted or reject the authorization request
	 */
	public function authenticationReceived()
	{
		$consumer = new Zend_Oauth_Consumer($this->getConfig());

		$user_id = Precurio_Session::getCurrentUserId();
		$table = new Zend_Db_Table(array('name'=>'wgt_precuriotweet','rowClass'=>'TweetUser'));
		$tweetUser =  $table->fetchRow($table->select()->where('user_id=?',$user_id));
		if (!empty($_GET))
		{
			try {
				$token = $consumer->getAccessToken($_GET, $tweetUser->getTokenObj());
			}
			catch (Exception $e)
			{
				$table = new Zend_Db_Table(array('name'=>'wgt_precuriotweet','rowClass'=>'TweetUser'));
				$table->delete("user_id = $user_id ");
				return;
			}
			$tweetUser->token = serialize($token);
			$tweetUser->username = $token->getParam('screen_name');
			$tweetUser->twitter_user_id = $token->getParam('user_id');
			$tweetUser->save();
		}
		else
		{
			// Mistaken request? Some malfeasant trying something?
			$tweetUser->username = 'error';
			$tweetUser->save();
		}
		return;
	}
	/**
	 * Returns the configuration
	 * @return array
	 */
	public static function getConfig()
	{
		$config = Zend_Registry::get('config');
		if(empty($config->base_url))
		{
			$table = new Zend_Db_Table(array('name'=>'wgt_precuriotweet','rowClass'=>'TweetUser'));
			$table->delete('user_id = '.Precurio_Session::getCurrentUserId());
			throw new Exception('Your administrator has not property set the intranet base url. <br/>Please do this in Admin->System Settings->General. <br/>');
		}

		$callback = $config->base_url.'/widget/twitter/callback';
		$config = array(
			'callbackUrl' => $callback,
			'siteUrl' => 'http://twitter.com/oauth',
			'consumerKey' => 'kWxzEuiP7ruvFugGJt5g',
			'consumerSecret' => '3dpCuSCnpRwvqRlD8waxGPWd3SKmvTLRe4Ry6yLc'
		);
		return $config;
	}
}

/**
 * This is a class to represent a PrecurioTweet user
 * @author brain
 *
 */
class TweetUser extends Zend_Db_Table_Row_Abstract {
	var $config;
	/**
	 * Token object
	 * @var Zend_Oauth_Token_Access
	 */
	var $tokenObj;
	public function init()
	{
		$app = new PrecurioTweet();
		$this->config = $app->getConfig();
		/*
		$doAuthenticate = false;
		if(empty($this->token))
		{
			$doAuthenticate = true;
		}
		else
		{
			//$this->tokenObj = unserialize($this->token);
			if(is_a($this->tokenObj, 'Zend_Oauth_Token_Request'))
			{
				$doAuthenticate = true;
			}
			else
			{
				throw new Exception("Invalid Token");
				//if(!method_exists($this->tokenObj,'getHttpClient') && !empty($this->twitter_user_id))
			}
		}

		if($doAuthenticate)
			$this->authenticate();
			*/
	}
	/**
	 * This would initiate the authorisation process
	 * by redirecting the user to twitter for access.
	 */
	public function authenticate()
	{
		$consumer = new Zend_Oauth_Consumer($this->config);
		// fetch a request token
		$token = $consumer->getRequestToken();
		// persist the token to storage
		$this->token = serialize($token);
		$this->save();
		// redirect the user
		$consumer->redirect();
	}
	/**
	 * Get token object
	 * @return Zend_Oauth_Token_Access
	 */
	public function getTokenObj()
	{
		if(empty($this->tokenObj))$this->tokenObj  = unserialize($this->token);
		return $this->tokenObj;
	}
	/**
	 * Returns an array of tweet objects
	 * @return array
	 */
	public function getTimeline()
	{
		$client = $this->getTokenObj()->getHttpClient($this->config);
		$client->setUri('http://twitter.com/statuses/home_timeline.json');
		$client->setMethod();
		$client->setParameterGet('include_entities', 1);
		try
		{
			$response = $client->request();
		}
		catch(Exception $e)
		{
			throw $e;
		}
		if($response->isError())
		{
			if($response->getStatus()== '401' )
			{
				$db = Zend_Registry::get('db');
				$db->query('UPDATE wgt_precuriotweet SET token = NULL WHERE user_id = '.$this->user_id);
			}
			throw new Exception('Something went wrong while trying to retrieve update',$response->getStatus());
		}

		$data = Zend_Json::decode($response->getBody());
		function fn(&$value,$key){$value = new Tweet($value);}
		array_walk($data, 'fn');
		return $data;
	}
	/**
	 * Posts a status message and returns the message tweet
	 * @param string $msg
	 * @return Tweet
	 */
	public function postUpdate($msg)
	{
		$client = $this->getTokenObj()->getHttpClient($this->config);
		$client->setUri('http://twitter.com/statuses/update.json');
		$client->setMethod(Zend_Http_Client::POST);
		$client->setParameterPost('status', $msg);
		try
		{
			$response = $client->request();
		}
		catch(Exception $e)
		{
			return false;
		}
		if($response->isError())
			return false;
		else
			return new Tweet(Zend_Json::decode($response->getBody()));
	}
	/**
	 * Returns the twitter user id
	 * @reuturn int(long)
	 */
	public function getTwitterId()
	{
		return $this->twitter_user_id;
	}
}

/**
 * This class represents a tweet
 * @author brain
 *
 */
class Tweet{
	/**
	 * The raw data
	 * @var array
	 */
	private $data;
	public function __construct($data)
	{
		$this->data = $data;
	}
	public function getImageUrl()
	{
		return $this->data['user']['profile_image_url'];
	}
	/**
	 * Returns the twitter's username
	 * @return string
	 */
	public function getUsername()
	{
		return $this->data['user']['screen_name'];
	}
	/**
	 * Returns the user's full name on twitter
	 * @return string
	 */
	public function getTwitterName()
	{
		return $this->data['user']['name'];
	}
	/**
	 * Returns the twitter user id.
	 * @return int
	 */
	public function getUserId()
	{
		return $this->data['user']['id'];
	}
	/**
	 * Returns the tweet message
	 * @param boolean $format - Indicate if you want the message formated.
	 * @return string
	 */
	public function getMessage($format = false)
	{
		$msg = $this->data['text'];
		if($format)
		{

			$a = stripos($msg,'http:');
			if($a !== false)
			{
				$b = stripos($msg,' ',$a);
				if($b === false)$b = strlen($msg);
				$link = substr($msg,$a,($b-$a+1));

				$newLink = '<a href="'.$link.'" target="_blank">'.$link.'</a>';
				$msg = str_ireplace($link, $newLink, $msg);
			}
		}
		return $msg;
	}
	/**
	 * Returns the date string
	 * @return string
	 */
	public function getDate()
	{
		$timestamp = strtotime($this->data['created_at']);
		$date = new Zend_Date($timestamp);
		return $date->toString('d MMM H:m:s');
	}
	/**
	 * Returns the tweet id
	 * @return string
	 */
	public function getId()
	{
		return $this->data['id_str'];
	}

	/**
	 * Determines if the tweet is actually a retweet
	 * @return boolean
	 */
	public function isRetweet()
	{
		return !empty($this->data['retweeted']);
	}
	public function isMention()
	{
		$mentions = $this->data['entities']['user_mentions'];
		if(empty($mentions))return false;
		$currentUser = PrecurioTweet::getUser();
		foreach($mentions as $mention)
		{
			if($mention['id'] == $currentUser->getTwitterId())
				return true;
		}
		return false;
	}
	/**
	 * Fetches the tweet from the twitter service
	 * @param int $tweet_id
	 * @return Tweet
	 */
	public static function get($tweet_id)
	{
		$app = new PrecurioTweet();
		$user = $app->getUser();
		$client = $user->getTokenObj()->getHttpClient($app->getConfig());
		$client->setUri('http://twitter.com/statuses/show/'.$tweet_id.'.json');
		$client->setMethod();
		$client->setParameterGet('include_entities', 1);
		try
		{
			$response = $client->request();
		}
		catch(Exception $e)
		{
			throw $e;
		}
		if($response->isError())
		{
			throw new Exception('Something went wrong while trying to retrieve update');
		}

		$data = Zend_Json::decode($response->getBody());
		return new Tweet($data);
	}
}

/**
 * Class represents a Twitter User profile.
 * @author brain
 *
 */
class UserProfile {
	/**
	 * The raw data
	 * @var array
	 */
	private $data;

	/**
	 * Array of Tweet objects
	 * @var array;
	 */
	private $timeline;
	public function __construct($data)
	{
		$this->data = $data;
	}
	/**
	 * @return string:
	 */
	public function getFullName()
	{
		return $this->data['name'];
	}
	/**
	 * @return string:
	 */
	public function getLocation()
	{
		$tr = Zend_Registry::get('Zend_Translate');
		return empty($this->data['location'])? $tr->translate('Not Available') : $this->data['location'];
	}
	/**
	 * @return string:
	 */
	public function getUsername()
	{
		return $this->data['screen_name'];
	}
	public function getImageUrl()
	{
		return str_ireplace('_normal', '_reasonably_small', $this->data['profile_image_url']);
	}
	/**
	 * Returns the date user joined twitter
	 * @return string
	 */
	public function getDateJoined()
	{
		$timestamp = strtotime($this->data['created_at']);
		$date = new Zend_Date($timestamp);
		return $date->toString('d MMM yyyy H:m:s');
	}
	/**
	 * @return string:
	 */
	public function getUrl()
	{
		return $this->data['url'];
	}
	/**
	 * Return twitter user id
	 * @return int
	 */
	public function getId()
	{
		return $this->data['id'];
	}
	/**
	 * Return user bio
	 * @return string:
	 */
	public function getDescription()
	{
		$tr = Zend_Registry::get('Zend_Translate');
		return empty($this->data['description'])? $tr->translate('Bio not available') : $this->data['description'];
	}
	/**
	 * @return int
	 */
	public function getNumTweets()
	{
		return $this->data['statuses_count'];
	}

	public function getNumFollowers()
	{
		return $this->data['followers_count'];
	}
	public function getNumFollowing()
	{
		return $this->data['friends_count'];
	}
	/**
	 * Returns the timeline of the user profile
	 * @param TweetUser $user - The user requesting to view the timeline.
	 * @throws Exception
	 * @return array - Array of Tweet objects
	 */
	public function getTimeline($user)
	{
		if(!empty($this->timeline))return $this->timeline;

		$client = $user->getTokenObj()->getHttpClient(PrecurioTweet::getConfig());
		$client->setUri('http://twitter.com/statuses/user_timeline.json');
		$client->setMethod();
		$client->setParameterGet('include_entities', 1);
		$client->setParameterGet('user_id', $this->getId());
		try
		{
			$response = $client->request();
		}
		catch(Exception $e)
		{
			throw $e;
		}
		if($response->isError())
		{
			throw new Exception('Something went wrong while trying to retrieve update',$response->getStatus());
		}

		$data = Zend_Json::decode($response->getBody());
		function fn(&$value,$key){$value = new Tweet($value);}
		array_walk($data,'fn');
		$this->timeline = $data;
		return $data;
	}
}

?>