<?php

/**
 * TwitterController
 *
 * @author
 * @version
 */

require_once ('widget/controllers/IndexController.php');
require_once ('widget/models/PrecurioTweet.php');
require_once ('user/models/UserSetting.php');
class Widget_TwitterController extends Widget_IndexController{

	public function indexAction()
	{
		try
		{
			$user = PrecurioTweet::getUser();//force authentication if not authenticated
		}
		catch (Exception $e)
		{
			//do nothing. The user will add a user
		}
		$this->render();
	}
	public function callbackAction()
	{
		$app = new PrecurioTweet();
		$app->authenticationReceived();
		return $this->_redirect('/default/index/home');
	}
	public function newtweetAction()
	{
		$tweet_id = $this->getRequest()->getParam('id',0);
		$this->view->message = '';
		if(!empty($tweet_id))
		{
			try
			{
				$tweet = Tweet::get($tweet_id);
			}
			catch(Exception $e)
			{
				return;
			}
			$action  = $this->getRequest()->getParam('f',0);
			if($action == 'retweet')
			{
				$this->view->message = 'RT @'.$tweet->getUsername().': '.$tweet->getMessage();
			}
			if($action == 'reply')
			{
				$this->view->message = '@'.$tweet->getUsername().': ';
			}
		}
		$this->render();
	}
	public function refreshAction()
	{
		try
		{
			$tweetUser = PrecurioTweet::getUser();
		}
		catch(Exception $e)
		{
			if($e->getCode() == '1011' || $e->getCode() == '0')
			{
				echo '<div id="noRecords">';
				echo $this->view->translate('No twitter account has been configured for PrecurioTweet.');
				echo '<br/>';
				echo '<a href="'.$this->view->baseUrl().'/widget/twitter/addaccount">';
				echo $this->view->translate('Click here to add a twitter account');
				echo '</a>';
				echo '</div>';
				return;
			}
			else
			{
				echo '<div id="noRecords">'.$this->view->translate('Could not connect to your twitter account, please check your internet connection.').'</div>';
				return;
			}
		}

		try
		{
			$tweets = $tweetUser->getTimeline();
		}
		catch(Exception $e)
		{
			echo '<div id="noRecords">'.$this->view->translate('Something went wrong while trying to retrieve updates').' ('.$e->getCode().')'.'</div>';
			$tweets = array();
		}
		$this->view->partialLoop()->setObjectKey('tweet');
		echo $this->view->partialLoop('/twitter/partial_tweet.phtml',$tweets);
	}
	public function submittweetAction()
	{
		try
		{
			$tweetUser = PrecurioTweet::getUser();
		}
		catch(Exception $e)
		{
			return;
		}
		$msg  = $this->getRequest()->getParam('msg','');
		if(empty($msg))return;
		try
		{
			$tweets = $tweetUser->postUpdate($msg);
		}
		catch(Exception $e)
		{
			echo $this->view->translate('Something went wrong while trying to post tweet');
		}

		$userSetting = new UserSetting(Precurio_Session::getCurrentUserId());
		$widget = $userSetting->getWidget('twitter');
		if($widget->getIntegrate() == 1)
		{
			$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::STATUS_MESSAGES,'rowClass'=>'UserStatus'));
	    	$data = array(
	    	'user_id'=>Precurio_Session::getCurrentUserId(),
	    	'message'=>$msg,
	    	'group_id'=>0,
	    	'content_id'=>0,
	    	'date_created'=>Precurio_Date::now()->getTimestamp()
	    	);
	    	$id = $table->insert($data);
		}
	}
	public function configureAction()
	{
		$twitter_id = $this->getRequest()->getParam('id',0);
		try
		{
			if(empty($twitter_id))
			{
				$currentUser = PrecurioTweet::getUser();
				$twitter_id = $currentUser->getTwitterId();
			}
		 	$userProfile = PrecurioTweet::getUserProfile($twitter_id);
		 	$this->view->userProfile = $userProfile;
		}
		catch (Exception $e)
		{
			$this->view->connection_error = 1;
		}
		$name  = $this->getRequest()->getControllerName();
		$userSetting = UserUtil::getUser()->getSettings();
		$this->view->widget = $userSetting->getWidget($name);
		$this->render();
	}
	public function preSubmitConfig(&$data)
	{
		if(!isset($data['integrate']))
		{
			$data['integrate'] = 0;
		}
	}
	public function addaccountAction()
	{
		$user_id = Precurio_Session::getCurrentUserId();

		$table = new Zend_Db_Table(array('name'=>'wgt_precuriotweet','rowClass'=>'TweetUser'));
		$table->delete("user_id = $user_id ");


		$id = $table->insert(
				array(
				'user_id'=>$user_id,
				'date_created'=>time()
				)
			);
		$user =  $table->fetchRow($table->select()->where('user_id=?',$user_id));
		$user->authenticate();
	}
	public function removeaccountAction()
	{
		$user_id = Precurio_Session::getCurrentUserId();
		$table = new Zend_Db_Table(array('name'=>'wgt_precuriotweet',));
		$row = $table->fetchRow($table->select()->where('user_id=?',$user_id));
		$ret = $row->delete();
		if($ret)
		{
			echo '<div id="noRecords">';
			echo $this->view->translate('No twitter account has been configured for PrecurioTweet.');
			echo '<br/>';
			echo '<a href="'.$this->view->baseUrl().'/widget/twitter/addaccount">';
			echo $this->view->translate('Click here to add a twitter account');
			echo '</a>';
			echo '</div>';
		}
		else
		{
			echo '<div id="noRecords">';
			echo $this->view->translate('Something went wront while trying to delete account, please try again later.');
			echo '</div>';
		}
	}
	public function profileAction()
	{
		$twitter_id = $this->getRequest()->getParam('id',0);
		$currentUser = PrecurioTweet::getUser();
		try
		{
			if(empty($twitter_id))
			{
				$twitter_id = $currentUser->getTwitterId();
			}
		 	$userProfile = PrecurioTweet::getUserProfile($twitter_id);
		 	$userProfile->getTimeline($currentUser);
		 	$this->view->userProfile = $userProfile;
		}
		catch (Exception $e)
		{
			$this->view->connection_error = 1;
		}
		$this->render();
	}
}
?>