<?php

/**
 * StockTickerController.php
 *
 * @author Mayor Brain
 * @version 2.1
 */

require_once ('widget/controllers/IndexController.php');
require_once ('widget/models/StockTicker.php');
class Widget_StockTickerController extends Widget_IndexController {
	public function indexAction()
	{
		$this->view->myStocks = StockTicker::getAll();
		$this->render();//renders the index.phtml view page
	}
	/**
	 * This action is called when the user removes a stock from the Stock Ticker widget.
	 * It is an AJAX call.
	 */
	public function removeAction()
	{
		//get the post data parameter 'symbol', or default to an empty string if no data.
		$symbol = $this->getRequest()->getParam('symbol',"");
		if(empty($symbol))
		{
			echo $this->view->translate("Invalid post data");
			return;
		}
		try{
			StockTicker::deleteStock($symbol);
		}
		catch(Exception $e)
		{
			echo $e->getMessage();
		}
		return;
	}
	/**
	 * This action is automatically called every 10 minutes by the Stock Ticker.
	 * It fetches updated data from the internet and returns in json format.
	 */
	public function refreshAction()
	{
		$arr = array();
		$myStocks = StockTicker::getAll();
		foreach($myStocks as $stock)
		{
			$stock->getData();//fetch from internet service (yahoo finance).

			$arr[$stock->getId()] = array('symbol'=>$stock->getSymbol(),
						'name'=>$stock->getName(),
						'price'=>$stock->getPrice(),
						'change'=>$stock->getChange(),
						'percent_change'=>$stock->getPercentChange());
		}
		$json = Zend_Json::encode($arr);
		echo $json;
	}
	/**
	 * Action is called when a user wants to add a stock to the Stock Ticker
	 */
	public function addAction()
	{
		$this->render();//render add.phtml
	}
	/**
	 * Action is called when the users searchs for a stock, in the add stock form.
	 * It is an AJAX action
	 */
	public function searchAction()
	{
		$name = $this->getRequest()->getParam('name',"");
		if(empty($name))
		{
			echo '<br/>'.$this->view->translate("Invalid Search");
			return;
		}
		$results = StockTicker::findStock($name);
		if(empty($results))
		{
			echo '<br/>'.$this->view->translate("Connection Error");
			return;
		}
		$results = $results['ResultSet']['Result'];
		if(!count($results))
		{
			echo '<br/>'.$this->view->translate("No results found");
			return;
		}
		foreach ($results as $stock)
		{
			$str .= $this->str_wrap($stock);
		}
		echo $str;

		return;
	}
	private function str_wrap($stock)
	{
		return '<div style="width: 350px">
	    	<div style="width: 170px;float: left;padding:0px;" class="secondline" title="'.$stock['name'].'">'.substr($stock['name'],0,25).(strlen($stock['name'])>25 ? '...' : '').'</div>
	    	<div style="width: 60px;float: left;padding:0px;" class="secondline" title="'.$stock['symbol'].'">'.substr($stock['symbol'],0,8).'</div>
	    	<div style="width: 60px;float: left;padding:0px;" class="secondline" title="'.$stock['exchDisp'].'">'.substr($stock['exch'],0,8).'</div>
	    	<div style="width: 50px;float: right;"><a href="#" onclick="add_stock(\''.$stock['symbol'].'\',\''.$stock['name'].'\');return false;">(add)</a></div>
    	</div>';
	}
	/**
	 * Action is called when a user adds a stock
	 * It is an AJAX call
	 */
	public function submitaddAction()
	{
		//get the post data parameter 'symbol', or default to an empty string if no data.
		$symbol = $this->getRequest()->getParam('symbol',"");
		$name = $this->getRequest()->getParam('name',"");
		if(empty($symbol))
		{
			echo $this->view->translate("Invalid post data");
			return;
		}
		try{
			StockTicker::addNew($symbol,$name);
		}
		catch(Exception $e)
		{
			echo $e->getMessage();
		}
		return;
	}
}
?>