<?php
require_once ('Zend/Db/Table/Row/Abstract.php');
require_once('link/models/vo/Link.php');
class UserTag extends Zend_Db_Table_Row_Abstract
{
	/**
	 * UserTag types must follow these conventions.
	 *
	 * a)They must also be module names. Such that "$this->baseUrl()/strtolower(TYPE)/index/index"
	 * will take you to the module page
	 * b)Also "$this->baseUrl()/strtolower(TYPE)/index/view/id/$id" should take you to the item
	 * c)After declaring the type, you should update UserTag::getTaggedItem() according
	 *
	 * Since most Items that a taggable are also rateable, Tags and User Rating use the same types.
	 */

	const TYPE_LINK = "LINK";

	/**
	 * Gets whatever item has been tagged from the type and item_id.
	 * Note that, no matter how many times an object is tagged, its item_id and type is always the same.
	 * @param int $item_id
	 * @param string $type
	 * @return Ambigous <Link, Zend_Db_Table_Row_Abstract, NULL>
	 */
	public static function getTaggedItem($item_id,$type)
	{
		switch ($type){
			case UserTag::TYPE_LINK:
				$item = Links::getLink($item_id);
				break;
		}
		return $item;
	}
	public function getTitle()
	{
		return $this->title;
	}
	public function getTagId()
	{
		return $this->tag_id;
	}
	public function getNumberofItems()
	{
		if(isset($this->num))return $this->num;
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::USER_TAGS));
		return $table->fetchAll($table->select()->where('tag_id = ?',$this->tag_id)->where('active = 1'))->count();
	}
	public function __toString()
	{
		return $this->getTitle();
	}
	/**
	 * Checks if tag exists and returns the id of the tag
	 * @param string $tag
	 * @return int
	 */
	public static function tagExists($tag)
	{
		$tag = (string)$tag;
		$tag = strtolower(trim($tag));
		$tag = str_ireplace(' ', '-', (preg_replace('/\s\s+/', ' ', $tag)));//if there is a space, replace with -
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::TAGS));
		$row = $table->fetchRow($table->select()->where('title = ?',$tag));
		return empty($row) ? 0 : $row->id;
	}
	/**
	 * Creates a new tag, and not a User Tag, to create a user tag, use ::creatNew()
	 * @param string $tag
	 * @return int  - Primary ket of inserted tag
	 */
	public static function createTag($tag)
	{
		$check = UserTag::tagExists($tag);
		if($check)return $check;

		$tag = (string)$tag;
		$tag = strtolower(trim($tag));
		$tag = str_ireplace(' ', '-', (preg_replace('/\s\s+/', ' ', $tag)));//if there is a space, replace with -
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::TAGS));
		$id = $table->insert(array('title'=>$tag,'date_created'=>time()));
		return $id;
	}
	/**
	 * @param string $tag
	 * @param int $user_id
	 * @param int $item_id
	 * @param string $type
	 * @return int - Primary key of user tag
	 */
	public static function createNew($tag,$user_id,$item_id,$type="")
	{
		if(empty($type))$type = self::TYPE_LINK;
		$tag = (string)$tag;
		$tag = strtolower(trim($tag));
		$tag_id = UserTag::tagExists($tag);
		if($tag_id == 0)
		{
			$tag_id = UserTag::createTag($tag);
		}

		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::USER_TAGS));
		$id = $table->insert(array(
			'tag_id'=>$tag_id,
			'user_id'=>$user_id,
			'type'=>$type,
			'item_id'=>$item_id,
			'date_created'=>time(),
			'active'=>1
		));
		return $id;
	}
	/**
	 * @param string $tag
	 * @param int $user_id
	 * @param int $item_id
	 * @param string $type
	 * @return null
	 */
	public static function remove($tag,$user_id,$item_id,$type="")
	{
		if(empty($type))$type = self::TYPE_LINK;
		$tag = (string)$tag;
		$tag = strtolower(trim($tag));
		$tag_id = UserTag::tagExists($tag);
		if($tag_id == 0)
		{
			return;
		}

		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::USER_TAGS));
		$row = $table->fetchRow($table->select()->where('tag_id = ?',$tag_id)
												->where('user_id = ?',$user_id)
												->where('type = ?',$type)
												->where('item_id = ?',$item_id)
												->where('active = 1'));

		if($row)
		{
			$row->active = 0;
			$row->save();
		}
		return ;
	}
	/**
	 * Get all available tags
	 * @param OPTIONAL, int $user_id - if specified, returns all tags for specified user
	 * @return Zend_Db_Table_Rowset_Abstract
	 */
	public static function getAll($user_id = 0)
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::USER_TAGS, 'rowClass'=>'UserTag'));
		$select = $table->select(false);
		$select->setIntegrityCheck(false);
		$select->setTable($table);

		$select = $select->distinct()
						->from(array('a' => PrecurioTableConstants::USER_TAGS))
						->join(array('b' => PrecurioTableConstants::TAGS),'a.tag_id = b.id',array('title'));

		if(!empty($user_id))
			$select = $select->where('user_id = ?',$user_id);

		$select = $select->where('active = 1')
						->group('tag_id')
						->order('title asc')
						->limit($limit);

		return $table->fetchAll($select);
	}

	/**
	 * Get all available tags sorted by popularity in descending order
	 * @return Zend_Db_Table_Rowset_Abstract
	 */
	public static function getPopularTags($limit = 10)
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::USER_TAGS, 'rowClass'=>'UserTag'));
		$select = $table->select(false);
		$select->setIntegrityCheck(false);
		$select->setTable($table);

		$select = $select->distinct()
						->from(array('a' => PrecurioTableConstants::USER_TAGS))
						->join(array('b' => PrecurioTableConstants::TAGS),'a.tag_id = b.id',array('title','num'=>'count(*)'))
						->where('active = 1')
						->group('tag_id')
						->order('num desc')
						->limit($limit);

		return $table->fetchAll($select);
	}
	/**
	 * Returns an array of recommended tags/keywords.
	 * @param string|array $keywords - The haystack to choose from
	 * @param string $title -  The title of the URL, keywords found in this title are always recommended
	 * @param OPTIONAL,string $description - The description of the site
	 * @param OPTIONAL,int $user_id -  Recommended keywords are also chosen based on user behaviour, defaults to the current user.
	 * @param array
	 */
	public static function getRecommended($keywords,$title,$description="",$user_id=0)
	{
		$recommended = array();
		$loopCount = 0;

		if(empty($user_id))$user_id = Precurio_Session::getCurrentUserId();

		//get all the user tags.
		$userTags = UserTag::getAll($user_id)->toArray();
		$userTags = Precurio_Utils::getSecondLevelArray($userTags,'title');//$userTags becomes a linear array containing strings of tags

		do	{
		if(is_string($keywords))
		{
			$keywords = explode(",",$keywords);
		}

		foreach($keywords as $keyword)
		{
			$keyword = strtolower(trim($keyword));
			$keyword = preg_replace('/\s\s+/', ' ', $keyword);//remove excess spaces


			if(stripos($keyword," ")!==false)
			{
				if(substr_count($keyword," ") == 1)
				{
					$keyword = str_ireplace(" ", "-",$keyword);
				}
				else
				{
					$extra = explode(" ",$keyword);
					$keyword = array_shift($extra);
					$description = implode(",", $extra).','.$description;
				}
			}

			if(in_array($keyword,$recommended))continue;
			if(is_numeric($keyword))continue;
			if(strlen($keyword) <= 4)continue;


			if(in_array($keyword, $userTags))//if user has used this keyword has a tag before
			{
				$recommended[] = $keyword;
				continue;
			}

			if(substr($keyword,-3) == 'ing' || substr($keyword,-2) == 'ly'
					|| substr($keyword,-2) == 'ive')//english specific optimisation
							continue;
			switch($keyword)//english specific optimization, some have now been made redundant with the string length check included above.
			{
				case 'the':	case 'these':case 'this':case 'that':case 'who':case 'whose':
				case 'those': case 'them': case 'there': case 'where': case 'when':
				case 'are': case 'on' : case 'why': case 'am' : case 'i': case 'you':
				case 'under': case 'above': case 'is': case 'we': case 'and': case 'or':
				case 'both':  case 'either': case 'neither': case 'nor': case 'his':
				case 'her': case 'him': case 'she': case 'for':
					continue;

			}

			$recommended[] = $keyword;
		}
		if(count($recommended) < 3)
			$keywords = $description.' '.$title;

		$loopCount++;

		}while(count($recommended) < 3 && $loopCount < 5);

		if(count($recommended) > 10)//we don't want more than 10 recommendations
		{
			/*
			function fn($a,$b)
			{
				return(strlen($a) == strlen($b)) ? 0 : (strlen($a) > strlen($b)? 1 : -1);
			usort($recommended, 'fn');
			$recommended = array_splice($recommended, 0,10);
			}*/

			//we are starting from behind because people usually start their keywords list
			//with the most important keywords.
			for($i = count($recommended)-1;$i>=0 ;$i--)
			{
				$keyword = $recommended[$i];
				if(strlen($keyword) > 10  )unset($recommended[$i]);//if keyword is too long
				if(substr_count($keyword," ") > 1)unset($recommended[$i]);
				if(count($recommended) < 10)break;
			}
		}

		return $recommended;
	}
}

?>