<?php

require_once ('Zend/Db/Table/Row/Abstract.php');

class UserStatus extends Zend_Db_Table_Row_Abstract implements Precurio_ObjectInterface{

	public function getMessage()
	{
		return $this->message;
	}
	public function getFullName()
	{
		$user = UserUtil::getUser($this->user_id);
		return $user->getFullName();
	}
	public function canAccess($user_id)
	{
		$user = UserUtil::getUser($this->user_id);
		return !$user->isBlocked($user_id);
	}
	public function getId()
	{
		return $this->id;
	}
	public function getItemId()
	{
		return $this->id;
	}
	public function getUsers()
	{
		return array();
	}
	public function isActive()
	{
		return true;
	}
	public function getUrl()
	{
		$user = UserUtil::getUser($this->user_id);
		return $user->getUrl();
	}
	public function __toString()
	{
		return $this->getMessage();
	}
	public function getTitle()
	{
		return $this->getMessage();
	}
}

?>