<?php

/**
 * UserCode is a reference class to table "secure_codes".
 * It contain additional methods for generating the secure code and validating it.
 *
 * Sometimes, certain activites require a "two step" process.
 * We use the process of "secure codes" to maintain security and identity accross each step.
 */

require_once ('Zend/Db/Table/Row/Abstract.php');
class UserCode extends Zend_Db_Table_Row_Abstract
{

	/**
	 * Generates a code, stores it and returns it. The code generated is always unique
	 * @param int $user_id
	 * @param UserActivity $activity
	 * @return string
	 */
	public static function generate($user_id,$activity)
	{
		$code = $activity->getId().$user_id.Precurio_Utils::randomPassword(12).time();//it will always be unique
		$code = base64_encode($code);
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::SECURE_CODES,'rowClass'=>'UserCode'));
		$row  = $table->createRow();
		$row->setFromArray(array(
				'activity_id'=>$activity->getId(),
				'user_id'=>$user_id,
				'secure_code'=>$code,
				'date_created'=>Precurio_Date::now()->getTimestamp()
		));
		$row->save();
		return $code;
	}
	/**
	 * @param string $code
	 * @return UserCode
	 */
	public static function getCode($code)
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::SECURE_CODES,'rowClass'=>'UserCode'));
		$row = $table->fetchRow($table->select()->where("secure_code = ?",$code));
		return $row;
	}
	/**
	 * Codes will automatically expire in 1hr.
	 */
	public function isExpired()
	{
		$now = Precurio_Date::now()->getTimestamp();

		$expireTime = $this->date_created + (1 * 60 * 60);
		return ($now >= $expireTime);
	}
	/**
	 * @return User
	 */
	public function getUser()
	{
		return UserUtil::getUser($this->user_id);
	}

}

?>