<?php
require_once ('Zend/Db/Table/Row/Abstract.php');
class Tag  extends Zend_Db_Table_Row_Abstract {

	public function getTitle()
	{
		return $this->title;
	}
	public function getId()
	{
		return $this->id;
	}
	public function getCount()
	{
		return isset($this->count)?$this->count:0;
	}
	public function __toString()
	{
		return $this->getTitle();
	}

	/**
	 * Removes a tag
	 * @param string $tag
	 * @param int $item_id
	 * @param string $app
	 * @return null
	 */
	public static function remove($tag,$item_id,$appid)
	{
		//get tag
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::TAGS));
		$row = $table->fetchRow($table->select()->where('title = ?',$tag));

		if(empty($row))
			return;

		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::APP_TAGS));
		$rows = $table->fetchAll($table->select()->where('appid = ?',$appid)
						->where('item_id = ?',$item_id)
						->where('tag_id = ?',$row->id));
		foreach ($rows as $row){$row->active = 0;$row->save();}//disable them al

		return;
	}

	/**
	 * @param string $tag
	 * @param int $user_id
	 * @param int $item_id
	 * @param string $app
	 * @return int - Primary key of user tag
	 */
	public static function createNew($tag,$user_id,$item_id,$appid)
	{
		$tag = (string)$tag;
		$tag = strtolower(trim($tag));
		$tag = str_ireplace(' ', '-', (preg_replace('/\s\s+/', ' ', $tag)));//if there is a space, replace with -

		$timestamp = Zend_Date::now()->getTimestamp();
		//see if tag exists
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::TAGS));
		$row = $table->fetchRow($table->select()->where('title = ?',$tag));

		//if it doesn't, create it.
		if(empty($row))
			$tag_id = $table->insert(array('title'=>$tag,'date_created'=>$timestamp));
		else
		{
			$tag_id = $row->id;
			//see if item has been tagged already
			$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::APP_TAGS));
			$row = $table->fetchRow($table->select()->where('tag_id = ?',$tag_id)
					->where('appid = ?',$appid)->where('item_id = ?',$item_id));

			//if it has, stop execution.
			if(!empty($row))return $tag_id;

		}

		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::APP_TAGS));
		$id = $table->insert(array(
				'tag_id'=>$tag_id,
				'user_id'=>$user_id,
				'appid'=>$appid,
				'item_id'=>$item_id,
				'date_created'=>$timestamp,
				'active'=>1
			));
		return $tag_id;
	}
	/**
	 * Get all tags on a particular object
	 * @param Precurio_ObjectInterface $object
	 * @return Zend_Db_Table_Rowset_Abstract
	 */
	public static function getObjectTags($object)
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::TAGS, 'rowClass'=>'Tag'));
		$select = $table->select(false);$select->setIntegrityCheck(false);$select->setTable($table);


		$select = $select->distinct()
						->from(array('a' => PrecurioTableConstants::TAGS))
						->join(array('b' => PrecurioTableConstants::APP_TAGS),'a.id = b.tag_id')
						->where('appid = ?',$object::APPID)->where('item_id = ?',$object->getItemId())
						->where('active = 1')
						->group('tag_id')
						->order('b.date_created desc');

		$select->columns(array('count'  => new Zend_Db_Expr('COUNT(tag_id)')));

		return $table->fetchAll($select);
	}
	/**
	 * Determine if an object has a tag
	 * @param Precurio_ObjectInterface $object
	 * @param string $tag
	 * @return boolean
	 */
	public static function objectIsTagged($object,$tag)
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::TAGS, 'rowClass'=>'Tag'));
		$select = $table->select(false);$select->setIntegrityCheck(false);$select->setTable($table);

		$select = $select->distinct()
		->from(array('a' => PrecurioTableConstants::TAGS))
		->join(array('b' => PrecurioTableConstants::APP_TAGS),'a.id = b.tag_id')
		->where('appid = ?',$object::APPID)->where('item_id = ?',$object->getItemId())
		->where('title = ?',$tag)->where('active = 1');

		$row = $table->fetchRow($select);

		return empty($row) ? false : true;
	}

	/**
	 * Get all tags on used in a app
	 * @param string $appid
	 * @return Zend_Db_Table_Rowset_Abstract
	 */
	public static function getAppTags($appid)
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::TAGS, 'rowClass'=>'Tag'));
		$select = $table->select(false);$select->setIntegrityCheck(false);$select->setTable($table);

		$select = $select->distinct()
						->from(array('a' => PrecurioTableConstants::TAGS))
						->join(array('b' => PrecurioTableConstants::APP_TAGS),'a.id = b.tag_id')
						->where('appid = ?',$appid)
						->where('active = 1')
						->group('tag_id')
						->order('b.date_created desc');

		$select->columns(array('count'  => new Zend_Db_Expr('COUNT(tag_id)')));

		return $table->fetchAll($select);
	}
}

?>