<?php

require_once ('Zend/Db/Table/Row/Abstract.php');
require_once ('user/models/vo/User.php');
require_once ('user/models/UserUtil.php');
class OutOfOffice extends Zend_Db_Table_Row_Abstract {

	public function getId()
	{
		return $this->id;
	}
	/**Get leave date
	 * @param $raw Boolean - indicated whether to return the unix timestamp (true) or a formated date (false). Default = false
	 * @return String
	 */
	public function getLeaveDate($raw = false)
	{
		if($raw)return $this->leave_date;
		$date = new Precurio_Date($this->leave_date);
		return $date->get(Precurio_Date::DAY).'-'.$date->get(Precurio_Date::MONTH_NAME);
	}
	/**Messaget to show to other members, i.e a leave status message
	 * @return String
	 */
	public function getMessage()
	{
		return $this->summary;
	}
	/**
	 * Get Return date
	 * @param $raw Boolean - indicated whether to return the unix timestamp (true) or a formated date (false). Default = false
	 * @return String
	 */
	public function getReturnDate($raw = false)
	{
		if($raw)return $this->return_date;
		$date = new Precurio_Date($this->return_date);
		return $date->get(Precurio_Date::DAY).'-'.$date->get(Precurio_Date::MONTH_NAME);
	}

	/**
	 * @return User
	 */
	public function getProxy()
	{
		return UserUtil::getUser($this->proxy_id);
	}
	public function init()
	{
		$this->_data['leave_date'] = trim($this->_data['leave_date']);
		$this->_data['return_date'] = trim($this->_data['return_date']);
		parent::init();
	}
	/**
	 * If the out of office is expired.
	 * @return boolean
	 */
	public function isExpired()
	{
		$now = Precurio_Date::now()->getTimestamp();
		return $this->return_date < $now ? true : false ;
	}
	/**
	 * Deactivates out of office.
	 */
	public function deactivate()
	{
		$this->active = 0;
		$this->save();
		
		$user = UserUtil::getUser($this->user_id);
		$user->out_of_office = 0;
		$user->save();
	}
	/**
	 * Returns object for user if user is out of office.
	 * @param int $user_id
	 * @return OutOfOffice, NULL
	 */
	public static function get($user_id)
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::OUT_OF_OFFICE,'rowClass'=>'OutOfOffice'));
		return $table->fetchRow($table->select()->where('user_id= ? ',$user_id)
				->where('active = 1 ')
				->order('id DESC'));
	}

}

?>