<?php
require_once ('Zend/Db/Table/Row/Abstract.php');
require_once ('user/models/vo/UserActivity.php');
class Comment extends Zend_Db_Table_Row_Abstract{

	const ACTIVITY_COMMENT = "comment";
	public function getId()
	{
		return $this->id;
	}
	public function getProfilePicture()
	{
		return UserUtil::getUser($this->user_id)->getProfilePicture();
	}
	public function getFullName()
	{
		return UserUtil::getUser($this->user_id)->getFullName();
	}
	public function getUser()
	{
		return UserUtil::getUser($this->user_id);
	}
	public function getMessage()
	{
		return $this->message;
	}
	public function getSinceWhen()
	{
		$date = $this->getDate();
		return $date->getHowLongAgo();

	}
	public function getUserId()
	{
		return $this->user_id;
	}
	public function getDate()
	{
		return new Precurio_Date(trim($this->date_created));
	}
	/**
	 * Creates a new comment, and inserts into database
	 * @param $user_id
	 * @param $comment
	 * @param $item_id
	 * @param $appid
	 * @param $group_id
	 * @return int comment_id if successful
	 */
	public static function create($user_id,$comment,$item_id,$appid,$group_id=0)
	{
		if(empty($comment))
			throw new Precurio_Exception(PrecurioStrings::INVALIDUSERACTION, Precurio_Exception::EXCEPTION_INVALID_USER_ACTION);
		//insert into comments table
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::COMMENTS));
		$date_created = Precurio_Date::now()->getTimestamp();
		$data = array('user_id'=>$user_id,'message'=>$comment,'item_id'=>$item_id,'appid'=>$appid,'date_created'=>$date_created,'active'=>1);
		$comment_id = $table->insert($data);

		//inserts into activity table
		Precurio_Activity::create($appid,self::ACTIVITY_COMMENT,$item_id,$user_id,null,0,$group_id);

		return $comment_id;
	}
	/**
	 * Gets a comment
	 * @param $id
	 * @return Comment
	 */
	public static function getComment($id)
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::COMMENTS, 'rowClass'=>'Comment'));
		$select  = $table->select(false);
		$select->setIntegrityCheck(false);
		$select = $select->from(array('a' => PrecurioTableConstants::COMMENTS))
						->join(array('b' => PrecurioTableConstants::USERS),'a.user_id = b.user_id',array('first_name','last_name','profile_picture_id','gender'))
						->where('a.id = ?',$id);
		return $table->fetchRow($select);
	}
	/**
	 * Get all the comments for a particular item in a module
	 * @param int $item_id
	 * @param string $appid
	 * @return Zend_Db_Table_Rowset_Abstract
	 */
	public static function getAll($item_id,$appid)
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::COMMENTS, 'rowClass'=>'Comment'));
		$select = $table->select();
		$select->setIntegrityCheck(false);
		$select->setTable($table);
		$select = $select->from(array('a' => PrecurioTableConstants::COMMENTS))
		->join(array('b' => PrecurioTableConstants::USERS),'b.user_id = a.user_id',array('first_name','last_name','profile_picture_id'))
		->where('a.item_id= ? ',$item_id)
		->where('a.appid= ? ',$appid)
		->where('a.active=1')
		->where('b.active=1')
		->order('id ASC');

		$all = $table->fetchAll($select);
		return $all;
	}

	public static function destroy($id)
	{
		//delete comment
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::COMMENTS));
		$comment = $table->fetchRow($table->select()->where('id = ?',$id));
		$comment->active = 0;
		$comment->save();
	}
	public function __toString()
	{
		return $this->getMessage();
	}
}

?>
