<?php
require_once ('Zend/Db/Table/Row/Abstract.php');
require_once ('user/models/UserUtil.php');
/**
 * This refers to a action log record and is used when we need to get a user activity as a log.
 * Think about it as a "log friendly" version of UserActivity.
 * Currently Used by Content::getViewLog and Document::getDownloadLog
 * @author brain
 *
 */
class ActionLog extends Zend_Db_Table_Row_Abstract
{
	public function getUser()
	{
		return UserUtil::getUser($this->user_id);
	}
	/**
	 * Gets the date it was performed
	 * @return Precurio_Date
	 */
	public function getDate()
	{
		return new Precurio_Date($this->date_created);
	}
	/**
	 * Return the number of similar log entries by the same user.
	 * @param string $type - OPTIONAL - If you do not want to get count for the exact same type, you can specify a different type.
	 * @return number
	 */
	public function getCount($type="")
	{
		if(empty($type))$type = $this->type;
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::ACTIVITY_LOG));
		$rows = $table->fetchAll($table->select()->where('active = 1')
				->where('item_id = ?',$this->item_id)
				->where('appid = ?',$this->appid)
				->where('type = ?',$type)
				->where('user_id = ?',$this->user_id)
				);
		return $rows->count();
	}
}
?>