<?php
require_once ('user/models/vo/User.php');
require_once ('user/models/vo/ActionLog.php');
require_once ('user/models/vo/Location.php');
require_once ('user/models/vo/Department.php');
require_once ('user/models/vo/Role.php');
require_once ('user/models/vo/Group.php');
//require_once ('user/models/vo/Tag.php');
require_once ('employee/models/Employees.php');
class UserUtil {

	public function __construct()
	{
		return $this;
	}
	/**
	 * Fetches all Locations
	 * @return Array
	 */
	public static function getLocations()
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::LOCATIONS,'rowClass'=>'Location'));
		$locations = $table->fetchAll($table->select()->where('active=1')->order('title asc'));
		return $locations;

	}
/**
	 * Returns user object with id = $user_id
	 * @param OPTIONAL int $user_id. Defaults to the current logged in user_id
	 * @param OPTIONAL boolean $throwError. If you want function to throw error instead of returning null. Defaults to false.
	 * @return User
	 */
	public static function getUser($user_id=null, $throwError = false)
	{
		try
		{
			if(Precurio_Utils::isNull($user_id))
				$user_id = Precurio_Session::getCurrentUserId();

				$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::USERS,'rowClass'=>'User'));
			     $userVo = $table->fetchRow($table->select()->where('user_id = ? ',$user_id));
			if(Precurio_Utils::isNull($userVo))
			{
				$msg =  PrecurioStrings::NOSUCHUSER;
				throw new Precurio_Exception($msg,Precurio_Exception::EXCEPTION_NO_SUCH_USER);
			}
		}
		catch(Exception $e)
		{
			if($throwError)throw $e;
			return null;
		}
		return $userVo;
	}
	public static function getUsers()
	{
		$employees = new Employees();
		return $employees->getAll(true);
	}
	/**
	 * @param $group_id int
	 * @return Group
	 */
	public static function getGroup($group_id)
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::GROUPS,'rowClass'=>'Group'));
	    return $table->fetchRow($table->select()->where('id = ? ',$group_id));//never add an 'active' where clause. Because of LdapAuth group import.
	}

	/**
	 * Fetches all Groups
	 * @return Zend_Db_Table_Rowset
	 */
	public static function getGroups()
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::GROUPS,'rowClass'=>'Group'));
		$groups = $table->fetchAll($table->select()->where('active=1')->order('title asc'));
		return $groups;

	}
	/**
	 * Fetches all departments
	 * @return Array
	 */
	public static function getDepartments()
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::DEPARTMENTS,'rowClass'=>'Department'));
		$depts = $table->fetchAll($table->select()->where('active=1')->order('title asc'));
		return $depts;
	}
	/**
	 * Fetches all Roles
	 * @return Zend_Db_Table_Rowset
	 */
	public function getRoles()
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::ROLES,'rowClass'=>'Role'));
		$roles = $table->fetchAll($table->select()->where('active=1')->order('title asc'));
		return $roles;

	}
	public function getRecentStatus($limit = 20, $user_id = 0)
	{
		if($user_id == 0)$user_id = Precurio_Session::getCurrentUserId();
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::STATUS_MESSAGES, 'rowClass'=>'UserStatus'));
		$select = $table->select();
		$select->setTable($table);

		$select = $select->from(array('a' => PrecurioTableConstants::STATUS_MESSAGES))
						->where('a.user_id = ?' ,$user_id)
						->order('id DESC')
						->limit($limit);
		return  $table->fetchAll($select);
	}
	public static function addUserToGroup($user_id,$group_id)
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::USER_GROUPS));

		$row = $table->fetchRow($table->select()->where('user_id = ?',$user_id)->where('group_id = ?',$group_id));
		if($row)return;//should probably throw an error here, but i think its better to ignore.
		//ok, user as not already been added, we can now add the user.
		$row = $table->createRow(array(
		'user_id'=>$user_id,
		'group_id'=>$group_id,
		'date_created'=>Precurio_Date::now()->getTimestamp()
		));

		$row->save();
	}

	/**
	 * Creates a new user on the intranet.
	 * @param array $data user data. Must contain the following keys
	 * array(
	 * 		'identity',
			'credential' (an hashed or unhashed version, preferrably unhashed. function will hash if unhashed),
			'first_name',
			'last_name',
		    )
	 * @return User
	 */
	public static function createUser($data)
	{
		$tr = Zend_Registry::get('Zend_Translate');
		//first check license, to see if limit not exceeded
		if(Precurio_Session::getLicense()->isFull())
			throw new Precurio_Exception($tr->translate(PrecurioStrings::LICENSEFULL),Precurio_Exception::EXCEPTION_LICENSE_FULL);

		$config = Zend_Registry::get('config');
		//some data validation
		if(empty($data['email']))
			$data['email'] = $data['identity'];
		if(empty($data['username']))
			$data['username'] = (stripos($data['email'],'@') === false ? $data['email'] : substr($data['email'],0,strpos($data['email'],'@')));
		if(empty($data['password']))
			$data['password'] = $data['credential'];
		if(empty($data['company']))
			$data['company'] = isset($config->company_name) ? $config->company_name : '';
		if(!isset($data['active']))
			$data['active'] = 1;
		if(!isset($data['out_of_office']))
			$data['out_of_office'] = 0;
		if(empty($data['location_id']))
			$data['location_id'] = 0;
		if(empty($data['department_id']))
			$data['department_id'] = 0;
		if(empty($data['date_created']))
			$data['date_created'] = time();
		if(strlen($data['password']) != 32)//password is not hashed
		{
			$data['readable_password'] = $data['password'];
			$data['password'] = md5($data['password']);
			$data['credential'] = $data['password'];
		}

		//first check if identity already exists
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::AUTH));
		$row = $table->fetchRow($table->select()->where('identity = ?',$data['identity']));
		if(!empty($row))
		{
			$existingUser = UserUtil::getUser($row->id);
			if(!empty($existingUser)){
			    if($existingUser->isActive())
			        throw new Precurio_Exception($tr->translate("A user with that login information already exists."), Precurio_Exception::EXCEPTION_APPLICATION_ERROR);
			    
			    $config  = Zend_Registry::get('config');
			    
			    //if reuse_users is set to 1, do not delete the user, instead reactivate the existing user.
			    if(!empty($config->reuse_users))
			    {
			        $existingUser->active = 1;
			        $existingUser->save();
			        return $existingUser;
			    }
			}
			//reuse_users not set,
			$row->delete();//permanently delete the record if the exiting user is not active
		}

		//create user in authentication table
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::AUTH));
		$user_id = $table->insert(array(
			'identity'=>$data['identity'],
			'credential'=>$data['credential'],
			'date_created'=>$data['date_created']
		));
		$data['user_id'] = $user_id;
		unset($data['identity']);unset($data['credential']);

		//then insert into user details
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::USERS));
		$row  = $table->createRow();$row->setFromArray($data);
		$id  = $row->save();

		//v3.0 feature - insert user into groups marked as default
		//v4 note: Even if admin can now set groups when adding user, other scenarios such as when
		//user logs in via active directory requires this feature.
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::GROUPS,'rowClass'=>'Group'));
		$defaultGroups = $table->fetchAll($table->select()->where('is_default = 1')->where('active = 1'));
		foreach($defaultGroups as $group)
		{
			$group->addUserMember($user_id);
		}


		//Add to depatmental group
		if(empty($data['group_ids']))$data['group_ids'] = array();
		if(!empty($data['department_id']))
		{
			$item = Department::get($data['department_id']);
			array_push($data['group_ids'],$item->getGroupId());
		}
		//Add to location group
		if(!empty($data['location_id']))
		{
			$item = Location::get($data['location_id']);
			array_push($data['group_ids'],$item->getGroupId());
		}
		//v4 feature. add user to selected groups
		if(count($data['group_ids']))
		{
			$groups  = $table->find($data['group_ids']);
			foreach($groups as $group)
			{
				$group->addUserMember($user_id);
			}
		}

		//notity and readable_password must be set for notification to be sent.
		//Both are set by the admin user controller, which is the actually the only scenario
		//where email needs to be sent i.e. because its the admin that is creating the user.
		//In other scenarios (during installation, when loggin in with active directory),
		//the user himself triggers the creation, so no notification really necessary
		if($data['notify'] && $data['readable_password'] )
		{
			$tr = Zend_Registry::get("Zend_Translate");
			$loginDetails = getLocalizedString($tr->translate("LOGIN: {1} <br/> PASSWORD: {2} <br/>"),$data['email'],$data['readable_password']);

			$activity_id = Precurio_Activity::create(User::APPID,User::ACTIVITY_NEW, $user_id,$user_id,null,-2);
			$activity = UserActivity::get($activity_id);

			$user = UserUtil::getUser($user_id);
			$baseUrl = $config->base_url;

			$format = Precurio_Activity::getMessageFormat($activity,"mail");
			$message = getLocalizedString($format,$user->getFullName(),$user->getGenderPronoun(),$baseUrl.$user->getUrl(),"",$user_id,"",$baseUrl,$loginDetails,$baseUrl.$user->getUrl());

			$mail = new Precurio_Mail();
			$mail->sendData(array(
					'to'=>$user->getEmail(),
					'subject'=>$activity->getMailSubject(),
					'body'=>$message,
					'activity_id'=>$activity_id
			));
		}

		return UserUtil::getUser($user_id);
	}

	public static function activateGuestUser()
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::USERS,'rowClass'=>'User'));
		$guest =  $table->fetchRow($table->select()->where('username = "guest"')->order('id desc'));
		$tr = Zend_Registry::get('Zend_Translate');
		if(empty($guest))
		{
			$config = Zend_Registry::get('config');

			$params = array(
				'identity' => 'guest',
				'credential' =>md5('guest'),
				'date_created'=>time(),
				'first_name'=>$tr->translate('Guest'),
				'last_name'=>'',
				'email'=>'guest'.$config->email_domain,
				'username'=>'guest',
				'password'=>md5('guest'),
				'date_created'=>time(),
			);

			$guest = UserUtil::createUser($params);
		}
		if(!$guest->isActive())
		{
			$guest->active = 1;
			$guest->first_name = $tr->translate('Guest');
			$guest->last_name = '';
			$guest->save();
		}
		return $guest;
	}
 	/**
	  * Check if the current user is given a certain privilege access to the specifed resource
	  * @param string $resource e.g. 'admin_index'
	  * @param string $privilege e.g. 'view','add','edit'
	  * @return boolean
	  */
	 public static function isAllowed($resource,$privilege = 'view',$user_id=0)//this function has a clone in report/views/scripts/index/index.phtml
	 {
	 	$ignoreAcl = Zend_Registry::get('ignoreAcl');//this is set in performAcl()::Initializer.php
	 	if($ignoreAcl)return true;
	 	
	 	$register_id = "acl".$resource.$privilege;//store access result in register. The process of determining access is resource intensive.
	 	if(Zend_Registry::isRegistered($register_id))
	 	    return Zend_Registry::get($register_id);
	 	
	 	try
	 	{
	 		if(empty($user_id))$user_id = Precurio_Session::getCurrentUserId();
	 		$userRoles = UserUtil::getUser($user_id,true)->getRoles();
	 	}
	 	catch(Exception $e)
	 	{
			return false;
	 	}

	 	$resource = new Precurio_Resource($resource);

		$frontController = Zend_Controller_Front::getInstance();
	 	$plugin = $frontController->getPlugin('Initializer');

	 	try
	 	{
	 		$access = $plugin->isAllowed($userRoles,$resource,$privilege);
	 	}
	 	catch (Exception $e)
	 	{
	 		return false;
	 	}
	 	Zend_Registry::set($register_id, $access); //save access.
		return $access;

	 }
}

?>