<?php

/**
 * UserController
 *
 * @author
 * @version
 */

require_once 'Zend/Controller/Action.php';
require_once 'Precurio/Upload.php';
require_once ('user/models/UserUtil.php');
require_once 'discussion/models/vo/Discussion.php';
class User_ProfileController extends Zend_Controller_Action {

	public function preDispatch()
	{
		$this->_helper->layout->setLayout(PrecurioLayoutConstants::MAIN_C);
		$router = Zend_Controller_Front::getInstance()->getRouter();
        $fake_route = new Zend_Controller_Request_Http();
        $fake_route->setRequestUri('/');
        $router->route($fake_route);
	}
	public function indexAction()
	{
		$this->_forward('view');

	}
	public function editAction()
	{
		$this->view->form = $this->getOutOfOfficeForm(Precurio_Session::getCurrentUserId());
	}
	public function viewAction()
	{
		$this->view->errorMessages = implode('<br/>',$this->_helper->flashMessenger->getMessages());
		$this->_helper->layout->setLayout(PrecurioLayoutConstants::MAIN_C);
		$user_id = $this->getRequest()->getParam('id');
		if($user_id == Precurio_Session::getCurrentUserId() || $user_id == 0)
		{
			$this->view->isMyPage = 1;
		}
		else
		{
			$this->view->isMyPage = 0;
		}
		$utilFn = new UserUtil();
		$params = $this->getRequest()->getParams();
		$this->view->user = $utilFn->getUser($params['id']);
		$this->view->page = $params['page'];
		$this->view->param1 = $params['param1'];
		$this->view->param2 = $params['param2'];
		$this->view->cpage = $params['cpage'];

		//Precurio_Utils::debug($params);
	}
	public function updateAction()
	{
		$user = UserUtil::getUser(Precurio_Session::getCurrentUserId());
		$params = $this->getRequest()->getParams();
		if(isset($_FILES['profile_pic']) && $_FILES['profile_pic']['size'] > 0)
		{
			$filePath = Content::addPhoto('profile_pic',true);
	        $picId = $user->newProfilePic($filePath);
	        $params['profile_picture_id']=$picId;
		}
		if($params['locale'])
		{
			$s = new UserSetting(Precurio_Session::getCurrentUserId());
			$s->setLocale($params['locale']);
			unset($params['locale']);
		}

		$user->update($params);
		$this->_redirect('/user/profile/edit');
		return;
	}
	public function changepasswordAction()
	{
		$this->_helper->layout->disableLayout();
		$this->_helper->viewRenderer->setNoRender();

		$params = $this->getRequest()->getParams();
		$user = UserUtil::getUser(Precurio_Session::getCurrentUserId());
		if(md5($params['cp']) !== $user->password)
		{
			echo($this->view->translate('Current password is not correct'));
			return;
		}
		if($params['np'] !== $params['np2'])
		{
			echo($this->view->translate('Your new passwords do not match'));
			return;
		}
		if( strlen($params['np']) < 6)
		{
			echo($this->view->translate('Your new password is invalid, enter at least 6 characters'));
			return;
		}
		$user->updatePassword($params['np']);
		echo($this->view->translate('You have successfully changed your password'));
	}

	public function uploadpicAction()
	{
		$this->_helper->layout->disableLayout();
		$this->_helper->viewRenderer->setNoRender();

		if(!isset($_FILES['profile_pic']))
		{
			$this->_redirect('/user/profile/edit');
			return;
		}

		$filePath = Content::addPhoto('profile_pic',true);
		$user = UserUtil::getUser(Precurio_Session::getCurrentUserId());
        $picId = $user->newProfilePic($filePath);
        $user->update(array('profile_picture_id'=>$picId));
		$this->_redirect('/user/profile/edit');
		return;
	}
	public function setoutAction()
	{
		$redirectPage = $this->getRequest()->getParam('user_id') == Precurio_Session::getCurrentUserId()
		? '/user/profile/edit'   : '/admin/user/view/id/'.$this->getRequest()->getParam('user_id');
		if (!$this->getRequest()->isPost()) {
			$this->_redirect($redirectPage);
			return;
		}
		$form = $this->getOutOfOfficeForm(0,null);
		if (!$form->isValid($_POST))
		{
			// Failed validation; redisplay form
			$this->view->form = $form;
			$this->_redirect($redirectPage);
			return;
		}

		$timestamp = Precurio_Date::now()->getTimestamp();

		$values = $form->getValues();
		$values['date_created'] = $timestamp;
		$start_date = new Precurio_Date();
		$start_date->setMonth($values['start_month']);
		$start_date->setDay($values['start_day']);
		$start_date->setYear($values['start_year']);
		$values['leave_date'] = $start_date->getTimestamp();
		unset($values['start_month']);
		unset($values['start_day']);
		unset($values['start_year']);


		$end_date = new Precurio_Date();
		$end_date->setMonth($values['end_month']);
		$end_date->setDay($values['end_day']);
		$end_date->setYear($values['end_year']);
		$end_date->setHour(23); //out of office expires at the end of the day.
		$end_date->setMinute(59);
		$values['return_date'] = $end_date->getTimestamp();
		unset($values['end_month']);
		unset($values['end_day']);
		unset($values['end_year']);

		if($values['return_date'] <= $values['leave_date'])
		{
			$this->_redirect($redirectPage);
			return;
		}

		$values['proxy_id'] = $values['proxy_id'][0];
		$values['active'] = 1;

		if(Precurio_Utils::isNull($values['id']))
		{
			unset($values['id']);
			$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::OUT_OF_OFFICE));
			$row = $table->createRow($values);
			$id = $row->save();

			$currentUser = UserUtil::getUser($values['user_id']);
			$currentUser->out_of_office = 1;
			$currentUser->save();
		}
		else
		{
			$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::OUT_OF_OFFICE));
			$row = $table->find($values['id'])->current();
			$row->setFromArray($values);
			$row->save();
		}
		$this->_redirect($redirectPage);
		return;
	}
	public function deleteoutAction()
	{
		$this->_helper->layout->disableLayout();
		$this->_helper->viewRenderer->setNoRender();

		$out_id = $this->getRequest()->getParam('id',0);
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::OUT_OF_OFFICE,'rowClass'=>'OutOfOffice'));
		$row = $table->find($out_id)->current();
		if($row == null)
		{
			$this->_redirect('/user/mypage/settings');
			return;
		}
		$row->deactivate();

		echo $this->view->translate('Welcome Back!');

		return ;
	}
	private function getOutOfOfficeForm($user_id,$outObj = null)
	{
		$startDate = $outObj == null ? Precurio_Date::now() : new Precurio_Date($outObj->getLeaveDate(true));
		$endDate = $outObj == null ? Precurio_Date::now() : new Precurio_Date($outObj->getReturnDate(true) + 7200);

		$form = new Zend_Form();
		$form->setAction($this->getRequest()->getBaseUrl().'/user/profile/setout')
		->setMethod('post')
		->setAttrib('id','addForm')
		->setAttrib('name','addForm')
		->setAttrib('enctype', 'multipart/form-data');

		$form->addElement('hidden', 'id', array(
				'validators' => array(
				),
				'required' => false,
				'value'=>$outObj['id'],
		));
		$form->addElement('hidden', 'user_id', array(
				'validators' => array(
				),
				'required' => false,
				'value'=>$user_id,
		));	//$user_id here is user initiating the out of office

		$form->addElement('select', 'start_month', array(
				'required' => true,
				'class' => 'oneThirdSelect form-control',
				'multiOptions'=> Precurio_FormElement::getOptionsArray(Precurio_Date::getAllMonths(),'value','label'),
				'value'=>$startDate->get(Precurio_Date::MONTH_SHORT)
		));
		$form->addElement('select', 'start_day', array(
				'required' => true,
				'class' => 'oneThirdSelect form-control',
				'multiOptions'=> Precurio_FormElement::getOptionsArray(Precurio_Date::getAllDays(),'value','label'),
				'value'=>$startDate->get(Precurio_Date::DAY)
		));
		$form->addElement('select', 'start_year', array(
				'required' => true,
				'class' => 'oneThirdSelect form-control',
				'multiOptions'=> Precurio_FormElement::getOptionsArray(Precurio_Date::getAllYears(),'value','label'),
				'value'=>$startDate->get(Precurio_Date::YEAR)
		));

		$form->addElement('select', 'end_month', array(
				'required' => true,
				'class' => 'oneThirdSelect form-control',
				'multiOptions'=> Precurio_FormElement::getOptionsArray(Precurio_Date::getAllMonths(),'value','label'),
				'value'=>$endDate->get(Precurio_Date::MONTH_SHORT)
		));
		$form->addElement('select', 'end_day', array(
				'required' => true,
				'class' => 'oneThirdSelect form-control',
				'multiOptions'=> Precurio_FormElement::getOptionsArray(Precurio_Date::getAllDays(),'value','label'),
				'value'=>$endDate->get(Precurio_Date::DAY)
		));
		$form->addElement('select', 'end_year', array(
				'required' => true,
				'class' => 'oneThirdSelect form-control',
				'multiOptions'=> Precurio_FormElement::getOptionsArray(Precurio_Date::getAllYears(),'value','label'),
				'value'=>$endDate->get(Precurio_Date::YEAR)
		));

		$form->addElement('textarea', 'summary', array(
				'validators' => array(
				),
				'filters'=>array(
						'htmlEntities'
				),
				'class' => 'form-control',
				'rows'=>2,
				'required' => false,
				'value'=>$outObj['summary']
		));

		$selectUser = new Zend_Form_Element_Multiselect('proxy_id');
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::USERS,'rowClass'=>'User'));
		$select = $table->select()->where('active=1')->order('first_name asc');
		$users = $table->fetchAll($select);

		$proxy_id = $outObj == null ? $user_id : $outObj['proxy_id'];
		foreach($users as $user)
		{
			$selectUser->addMultiOption($user->getId(),$user->getFullName());
		}
		$selectUser->setAttrib('size',10);
		$selectUser->setAttrib('class', 'form-control');
		$selectUser->setValue($proxy_id);
		$selectUser->multiple = '';
		$form->addElement($selectUser);

		$form->setElementDecorators(array('ViewHelper','FormElements','Errors'));
		return $form;
	}
	public function sharestatusAction()
	{
		$this->_helper->layout->disableLayout();
		$this->_helper->viewRenderer->setNoRender();
		$msg = $this->getRequest()->getParam('message');

		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::STATUS_MESSAGES,'rowClass'=>'UserStatus'));
		$data = array(
				'user_id'=>Precurio_Session::getCurrentUserId(),
				'message'=>$msg,
				'group_id'=>0,
				'content_id'=>0,
				'date_created'=>Precurio_Date::now()->getTimestamp()
		);
		$row = $table->createRow($data);
		$id = $row->save();
		Precurio_Activity::create(User::APPID, User::ACTIVITY_NEW_STATUS, $id, Precurio_Session::getCurrentUserId());
		$this->_redirect('/user/profile/view');
	}

}
?>