<?php
require_once("team/models/vo/Team.php");
require_once("team/models/vo/TeamTask.php");
require_once("team/models/vo/TeamFolder.php");
class Template extends Zend_Db_Table_Row_Abstract
{
	public static function getAll()
	{
		try 
		{
			$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::TEAM_TEMPLATES));
			return $table->fetchAll("active=1");
		}
		catch(Exception $e)
		{
			return array();
		}
	}
	/**
	 * @param int $id
	 * @return Template
	 */
	public static function get($id)
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::TEAM_TEMPLATES,'rowClass'=>'Template'));
		$row = $table->fetchRow($table->select()->where("id = ?",$id));
		return $row;
	}
	
	public function getTasks()
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::TEAM_TEMPLATES_DATA));
		return $table->fetchAll($table->select()->where("template_id = ?",$this->id)->where("appid = ?",Task::APPID)->where("active = 1"));
	}
	public function getFolders()
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::TEAM_TEMPLATES_DATA));
		return $table->fetchAll($table->select()->where("template_id = ?",$this->id)->where("appid = ?",Content::APPID)->where("active = 1"));
	}
	/**
	 * @param Team $team
	 */
	public function applyTo($team)
	{
		$timestamp = Precurio_Date::now()->getTimestamp();
		//apply tasks
		$tasks = $this->getTasks();
		
		foreach($tasks as $item)
		{
			TeamTask::create(array(
				"title"=>$item->title,
				"creator_user_id"=>$team->user_id,
				"creator_group_id"=>$team->getId(),
				"user_id"=>$item->user_id,
				"start_time"=>$timestamp,
				"date_created"=>$timestamp,
				"end_time"=>""
			));
		}
		
		//apply folder
		$teamFolder = $team->getFolder();
		$folders = $this->getFolders();
		foreach($folders as $item)
		{
			Folders::createNew(array(
				"title"=>$item->title,
				"user_id"=>$item->user_id,
				"access_type"=>TeamFolder::ACCESS_SHARED,
				"group_id"=>$team->getId(),
				"parent_id"=>$teamFolder->getId(),
				"date_created"=>$timestamp
			));
		}
	}
}
class TemplateData extends Zend_Db_Table_Row_Abstract
{
	
}

?>