<?php
require_once("task/models/vo/Task.php");
require_once("team/models/vo/Team.php");
class TeamTask extends Task{
	const VIEW_URL = "/team/task/view/id/{1}/t_id/{2}";

	const ACTIVITY_ADD_TEAM = "add_group";
	/**
	 * @param int $id
	 * @param int $team_id
	 * @return TeamTask
	 */
	public static function get($id,$team_id)
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::TASK, 'rowClass'=>'TeamTask'));
		$select = $table->select(false);
		$select->setIntegrityCheck(false);
		$select->setTable($table);

		$select = $select->distinct()
		->from(array('a' => PrecurioTableConstants::TASK))
		->join(array('b' => PrecurioTableConstants::TASK_GROUPS),'a.id = b.task_id',array('group_id'))
		->where('a.id = ?' ,$id)
		->where('b.group_id = ?' ,$team_id)
		->order('b.id desc');
		$task = $table->fetchRow($select);
		return $task;
	}
	/**
	 * Get all tasks associated with a user
	 * @param int $user_id
	 * @version 4
	 * @return Zend_Db_Table_Rowset_Abstract
	 */
	public static function getAll($team_id)
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::TASK, 'rowClass'=>'TeamTask'));
		$select = $table->select(false);
		$select->setIntegrityCheck(false);
		$select->setTable($table);

		$select = $select->distinct()
		->from(array('a' => PrecurioTableConstants::TASK))
		->join(array('b' => PrecurioTableConstants::TASK_GROUPS),'a.id = b.task_id',array('group_id'))
		->where('a.active = 1 AND b.active= 1')
		->where('b.group_id = ?' ,$team_id)
		->order('start_time asc')->order('status asc')->order('end_time asc');
		$tasks = $table->fetchAll($select);
		//remove duplicates caused by joining to table "task_users"
		$result = array();
		foreach($tasks as $task)
		{
			$result[$task->getId()] = $task;
		}
		return $result;
	}
	public function getUrl()
	{
		return getLocalizedString(self::VIEW_URL,$this->getId(),$this->group_id);
	}
	/**
	 * Returns a collection of User objects that have access to the task.
	 * @return Zend_Db_Table_Rowset_Abstract
	 */
	public function getUsers()
	{
		/*
		//Modification for eFed Credit Union. Only notify the user that the task was assigned to
		$users = array();
		$users[] = $this->getUser();
		return $users;
		*/

		$group_id = isset($this->group_id) ? $this->group_id : $this->creator_group_id;
		$users = parent::getUsers();
		$members = UserUtil::getGroup($group_id)->getUsers();

		$result = array();

		foreach($users as $row)
			$result[$row->id] = $row;

		foreach($members as $row)
			$result[$row->id] = $row;

		return $result;
	}
	private $user;
	/**
	 * Gets the user performing the task
	 * @return User
	 */
	public function getUser()
	{
		if(!Precurio_Utils::isNull($this->user))
			return $this->user;
		$user_id = $this->getUserId();
		if(empty($user_id))return null;
		$this->user = UserUtil::getUser($user_id);
		return $this->user;
	}
	/**
	 * Get ID of user performing the task.
	 */
	public function getUserId()
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::TASK_USERS));
		$select = $table->select()->where('task_id = ?',$this->getId())
		->where('is_active = 1')
		->where('active = 1')->order('id desc');
		$row = $table->fetchRow($select);
		if(empty($row))return 0;
		return $row->user_id;
	}
	/**
	 * Determines if a user has access to the task
	 * @param int $user_id
	 * @return boolean
	 */
	public function canAccess($user_id)
	{
		if($user_id == $this->creator_user_id)return true;//always grant author
		//first check user access
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::TASK_USERS));
		$row = $table->fetchRow($table->select()->where('task_id = ?',$this->getId())->where('user_id = ?',$user_id)->where('active = 1'));
		if(!empty($row))return true;

		//then check group membership
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::TASK_GROUPS));
		$rows = $table->fetchAll($table->select()->where('task_id = ?',$this->getId())->where('active = 1'));
		foreach($rows as $row)
		{
			$team = Team::get($row->group_id);
			if($team->containsMember($user_id))return true;
		}
		return false;//user is not a member of any group with access to this task
	}
	/**
	 * Determines if a team has access to the task
	 * @param int $group_id
	 * @return boolean
	 */
	public function canTeamAccess($group_id)
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::TASK_GROUPS));
		$row = $table->fetchRow($table->select()->where('task_id = ?',$this->getId())->where('active = 1')->where('group_id = ?',$group_id));
		return !empty($row);
	}
	public function addTeam($team_id,$user_id=0)
	{
		if(empty($team_id))return;
		if(empty($user_id))$user_id = Precurio_Session::getCurrentUserId();
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::TASK_GROUPS));
		$time = Precurio_Date::now()->getTimestamp();
		$table->insert(array('group_id'=>$team_id,'task_id'=>$this->getId(),'date_created'=>$time,'active'=>1));

		Precurio_Activity::create(Task::APPID,self::ACTIVITY_ADD_TEAM,$this->getId(),$user_id,null,0,$team_id);
	}
	/**
	 * Creates a new team task and returns the ID
	 * @param array $data
	 * @throws Exception
	 * @return int
	 */
	public static function create($data)
	{
		//TODO determine where the user id is out of office, if yes get proxy
		$user_id = $data['user_id'];
		if(isset($data['id']))unset($data['id']);//you must do this else lastInsertId wont work
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::TASK,'rowClass'=>'TeamTask'));
		try
		{
			$row = $table->createRow($data);
			$id = $row->save();

			//add team members to task users, so that the task appears on their main task list
			$group = Team::get($data['creator_group_id']);
			$members = $group->getUsers();
			$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::TASK_USERS));
			if(!isset($data['user_id']))$data['user_id'] = 0;//if not assigned, set to zero
			foreach($members as $user)
			{
				$table->insert(array('user_id'=>$user->getId(),'task_id'=>$id,'is_active'=>($user->getId() == $data['user_id'] ? 1 : 0),'date_created'=>$data['date_created']));
			}

			//now add team, so it appears on team task list. (this is more important, architecture-wise)
			$row->addTeam($data['creator_group_id'],$data['creator_user_id']);
			Precurio_Activity::create(Task::APPID,Task::ACTIVITY_NEW,$id,$data['creator_user_id'],null,0,$data['creator_group_id']);

			$task = Task::get($id);
			$task->index();

		}
		catch (Exception $e)
		{
			throw $e;
		}

		return $id;
	}

	/**
	 * Return the group_id of the team accessing this task.
	 * @return unknown
	 */
	public function getTeamId()
	{
		$group_id = isset($this->group_id) ? $this->group_id : $this->creator_group_id;
		return $group_id;
	}
	protected function recordActivity($type,$user_id,$date_created=null,$onlyNotifyId=0)
	{
		if($type == Task::ACTIVITY_ADD_USER)return;//do not record add user activities.
		Precurio_Activity::create(Task::APPID,$type,$this->getId(),$user_id,$date_created,$onlyNotifyId,$this->getTeamId());
	}
}

?>