<?php
require_once ('Zend/Db/Table/Row/Abstract.php');
require_once("team/models/vo/Team.php");
class TeamNote  extends Zend_Db_Table_Row_Abstract implements Precurio_ObjectInterface,Precurio_TaggableInterface {
	const APPID = 'note';
	const VIEW_URL = "/team/note/view/id/{1}/t_id/{2}";

	const ACTIVITY_ADD_TEAM = "add_group";
	const ACTIVITY_NEW = "new";
	const ACTIVITY_COMMENT = "comment";
	const ACTIVITY_VIEW = "view";
	const ACTIVITY_EDIT = "edit";

	public function getId()
	{
		return $this->id;
	}
	public function getTitle()
	{
		return $this->title;
	}
	/**
	 * Gets the user that created the note
	 * @return User
	 */
	public function getUser()
	{
		return UserUtil::getUser($this->creator_user_id);
	}

	/**
	 * Gets the date the note was updated
	 * @return Precurio_Date
	 */
	public function getDate()
	{
		return new Precurio_Date($this->last_updated);
	}
	public static function getAll($team_id)
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::NOTES,'rowClass'=>'TeamNote'));
		$select = $table->select(false);
		$select->setIntegrityCheck(false);
		$select->setTable($table);

		$select = $select->distinct()
		->from(array('a' => PrecurioTableConstants::NOTES))
		->join(array('b' => PrecurioTableConstants::NOTE_GROUPS),'a.id = b.note_id',array('group_id'))
		->where('a.active = 1')
		->where('b.group_id = ?',$team_id)
		->order('last_updated desc');
		$items = $table->fetchAll($select);
		//remove duplicates caused by joining tables
		$result = array();
		foreach($items as $item)
		{
			$result[$item->id] = $item;
		}
		return $result;

	}
	public function getUrl()
	{
		return getLocalizedString(self::VIEW_URL,$this->getId(),$this->group_id);
	}
	/**
	 * Returns a collection of User objects that have access to the note.
	 * @return Zend_Db_Table_Rowset_Abstract
	 */
	public function getUsers()
	{
		return UserUtil::getGroup($this->group_id)->getUsers();
	}

	/**
	 * Gets a note object.
	 * Returns null if object does not exist
	 * @param int $id - ID of the note
	 * @param int $team_id - ID of the team
	 * @return TeamNote
	 */
	public static function get($id,$team_id)
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::NOTES,'rowClass'=>'TeamNote'));
		$select = $table->select(false);
		$select->setIntegrityCheck(false);
		$select->setTable($table);

		$select = $select->distinct()
		->from(array('a' => PrecurioTableConstants::NOTES))
		->join(array('b' => PrecurioTableConstants::NOTE_GROUPS),'a.id = b.note_id',array('group_id'))
		->where('a.active = 1')
		->where('b.group_id = ?',$team_id)
		->where('a.id = ?',$id);
		return $table->fetchRow($select);
	}
	/**
	 * Determines if a user has access to the note
	 * @param int $user_id
	 * @return boolean
	 */
	public function canAccess($user_id)
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::NOTE_GROUPS));
		$rows = $table->fetchAll($table->select()->where('note_id = ?',$this->getId())->where('active = 1'));
		foreach($rows as $row)
		{
			$team = Team::get($row->group_id);
			if($team->containsMember($user_id))return true;
		}
		return false;//user is not a member of any group with access to this task
	}
	/**
	 * Determines if a user can edit the note
	 * @param int $user_id
	 * @return boolean
	 */
	public function canModify($user_id)
	{
		if($this->creator_user_id == $user_id)return true;
		if($this->team_edit)return true;
		return false;
	}
	/**
	 * Determines if a team has access to the note
	 * @param int $group_id
	 * @return boolean
	 */
	public function canTeamAccess($group_id)
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::NOTE_GROUPS));
		$row = $table->fetchRow($table->select()->where('note_id = ?',$this->getId())->where('active = 1')->where('group_id = ?',$group_id));
		return !empty($row);
	}
	/**
	 * Creates a note object
	 * @param $data
	 * @param $team_id
	 * @return TeamNote
	 */
	public static function createNew($data,$team_id)
	{
		$data['is_team'] = 1;
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::NOTES,'rowClass'=>'TeamNote'));
		$row = $table->createRow();
		$row->setFromArray($data);
		$id = $row->save();

		$row->addTeam($team_id,$data['creator_user_id']);

		Precurio_Activity::create(self::APPID,self::ACTIVITY_NEW,$id,$data['creator_user_id'],null,0,$team_id);

		return self::get($id,$team_id);
	}
	public function addTeam($team_id,$user_id = 0)
	{
		if(empty($team_id))return;
		if(empty($user_id))$user_id = Precurio_Session::getCurrentUserId();
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::NOTE_GROUPS));
		$time = Precurio_Date::now()->getTimestamp();
		$table->insert(array('group_id'=>$team_id,'note_id'=>$this->getId(),'date_created'=>$time,'active'=>1));

		Precurio_Activity::create(self::APPID,self::ACTIVITY_ADD_TEAM,$this->getId(),$user_id,null,0,$team_id);
	}
	public function getItemId()
	{
		return $this->getId();
	}
	public function isActive()
	{
		return $this->active;
	}
	public function updateContent($body,$team_edit)
	{
		$user_id = Precurio_Session::getCurrentUserId();
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::NOTES));
		$row = $table->find($this->id)->current();
		$row->body = $body;
		$row->team_edit = $team_edit;
		$row->last_updated = Zend_Date::now()->getTimestamp() ;
		$row->save();

		$team_id = $this->group_id;//this is possible because of the join statement when getting a note. @see TeamNote::get();
		Precurio_Activity::create(self::APPID,self::ACTIVITY_EDIT,$this->getId(),$user_id,null,0,$team_id);
	}
	/**
	 * Deletes the note
	 */
	public function do_delete()
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::NOTES));
		$table->update(array('active'=>0),'id = '.$this->getId());
	}
	public function __toString()
	{
		return $this->getTitle();
	}

	/* (non-PHPdoc)
	 * @see Precurio_TaggableInterface::getTags()
	 */
	public function getTags()
	{
		return Tag::getObjectTags($this);
	}

	/* (non-PHPdoc)
	 * @see Precurio_TaggableInterface::isTagged()
	 */
	public function isTagged($tag)
	{
		return Tag::objectIsTagged($this, $tag);
	}
}

?>