<?php
require_once ('document/models/vo/Folder.php');

class TeamFolder extends Folder {
	const VIEW_URL = '/team/document/folder/id/{1}/t_id/{2}';

	protected $categoryClass = 'TeamFolder';
	protected $documentClass = 'TeamDocument';

	public function getUrl()
	{
		return getLocalizedString(self::VIEW_URL,$this->getId(),$this->group_id);
	}
	/**
	 * Very similar with static function getCategory(), just different rowClass.
	 * @param int $id id of category
	 * @param int $group_id - id of the team
	 * @return TeamFolder
	 */
	public static function get($id,$group_id)
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::CATEGORYS,'rowClass'=>'TeamFolder'));
		$item = $table->fetchRow($table->select()->where('id = ?',$id));
		
		$item->group_id = $group_id;
		return $item;
	}
	/**
	 * Returns the sub-categorys on a category
	 * @param boolean $recursive |default true| - flag to determine if you want to recursively get sub categories of sub categories.
	 * @param int $category_id |default 0| - id of category you want to get it's children. (Mostly used internaly when recurive=true)
	 * @return array
	 */
	public function getCategoryChildren($recursive = true,$category_id=0)
	{
		if($category_id == 0)$category_id = $this->id;
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::CATEGORYS,'rowClass'=>$this->categoryClass));

		$select = new Zend_Db_Table_Select($table);
		$select->setIntegrityCheck(false);
		$select = $select->from(array('a' => PrecurioTableConstants::CATEGORYS))
		->where('parent_id = ?',$category_id)
		->where('active = 1')
		->order('title asc');

		$items = $table->fetchAll($select);
		if(!isset($categorys))
			$categorys = array();
		foreach($items as $item)
		{
			$item->group_id = $this->group_id;
			$categorys[$item->id] = $item;
			if($recursive)
			{
				$categorys = array_merge($categorys,$this->getCategoryChildren($recursive,$item->id));

			}
		}
		return $categorys;
	}

	public function getContentChildren($recursive = true)
	{
		$categorys = array();
		$contents = array();
		//if you want to get all children (both direct and indirect), you have to first get all sub categorys
		if($recursive)
		{
			$categorys = $this->getCategoryChildren(true);
		}
		array_unshift($categorys,$this);//add this category

		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::CONTENT,'rowClass'=>$this->documentClass));
		foreach ($categorys as $category)
		{
			$select = new Zend_Db_Table_Select($table);
			$select->setIntegrityCheck(false);
			$select = $select->from(array('a' => PrecurioTableConstants::CONTENT),Document::$requiredContentProp)
			->join(array('b' => PrecurioTableConstants::CONTENT_CATEGORYS),'a.id = b.content_id',array())
			->join(array('c' => PrecurioTableConstants::DOCUMENTS),'a.id = c.content_id',Document::$requiredDocumentProp)
			->where('b.category_id = ?',$category->id)
			->where('a.active=1')
			->where('b.active=1')
			->order('c.last_modified desc');
			$temp = $table->fetchAll($select);
			foreach($temp as $t)//get contents Zend_Db_Table_RowSet into array , by looping.
			{
				$t->group_id = $this->group_id;
				$contents[$t->id] = $t;//using $contents[$t->id] instead of  solves the issue of duplicate contents, since  already existing contents will replace themselves
			}
		}

		return $contents;
	}
	public function init()
	{
		parent::init();
		if(!isset($this->_data['group_id']))$this->_data['group_id'] = 0;
	}
}

?>