<?php
require_once 'team/controllers/BaseController.php';
require_once "team/models/vo/TeamDocument.php";
require_once "team/models/vo/TeamTask.php";

class Team_DocumentController extends Team_BaseController{

	public function indexAction()
	{
		$team = $this->view->team;
		$this->view->folder =  $team->getFolder();
		$history = FolderHistory::get();
		$history->clear();
	}
	public function folderAction()
	{
		$team = $this->view->team;

		if($this->getRequest()->isXmlHttpRequest())
		{
			$this->_helper->layout->disableLayout();
		}

		$category_id = $this->getRequest()->getParam('id');
		$category = TeamFolder::get($category_id,$team->getId());
		if($category == null)
		{
			throw new Precurio_Exception($this->view->translate('Invalid Action'),Precurio_Exception::EXCEPTION_INVALID_USER_ACTION);
		}
		if(!$category->active)
		{
			throw new Precurio_Exception($this->view->translate('Folder has been removed.'),Precurio_Exception::EXCEPTION_MISSING_CONTENT);
		}
		if(!$category->canAccess(Precurio_Session::getCurrentUserId()))
		{
			throw new Precurio_Exception($this->view->translate('You do not have permission to view this folder'),Precurio_Exception::EXCEPTION_NO_ACCESS);
		}
		$this->view->category = $category;
		$this->view->folder = $category;

		$history = FolderHistory::get();
		$history->add($category_id);

		$this->render('index');

	}
	public function viewAction()
	{
		if($this->getRequest()->isXmlHttpRequest())
			$this->_helper->layout->disableLayout();

		$team = $this->view->team;

		$id = $this->getRequest()->getParam('id');
		$document = TeamDocument::get($id,$team->getId());
		if(empty($document))
		{
			throw new Precurio_Exception($this->view->translate(Precurio_Exception::EXCEPTION_MISSING_CONTENT),Precurio_Exception::EXCEPTION_MISSING_CONTENT);
		}
		if(!$document->canAccess(Precurio_Session::getCurrentUserId()))
		{
			throw new Precurio_Exception($this->view->translate(PrecurioStrings::CANNOTACCESSRESOURCE),Precurio_Exception::EXCEPTION_NO_ACCESS);
		}

		$document->viewed(Precurio_Session::getCurrentUserId());

		$this->view->document = $document;
	}
	protected  function getAppName()
	{
		return Document::APPID;
	}
}