<?php

/**
 * DiscussionController
 *
 * @author
 * @version
 */

require_once 'team/controllers/BaseController.php';
require_once "team/models/vo/TeamDiscussion.php";

class Team_DiscussionController extends Team_BaseController {
	/**
	 * The default action - show the home page
	 */
	public function indexAction()
	{
		$team = $this->view->team;
		$this->view->discussions = TeamDiscussion::getAll($team->getId());
	}
	public function viewAction()
	{
		$team = $this->view->team;
		$id = $this->getRequest()->getParam('id');
		$discussion = TeamDiscussion::get($id,$team->getId());
		if(empty($discussion) || !$discussion->canTeamAccess($this->getParam('t_id')))
			throw new Precurio_Exception(PrecurioStrings::CANNOTACCESSRESOURCE, Precurio_Exception::EXCEPTION_NO_ACCESS);
		if(!$discussion->isActive())
		{
			$this->_redirect($team->getUrl('discussion'));
		}
		$this->view->discussion  = $discussion;
		Precurio_Activity::create(Discussion::APPID,Discussion::ACTIVITY_VIEW,$id,Precurio_Session::getCurrentUserId(),null,0,$team->getId());
	}
	/**
	 *Display create discussion form
	 */
	public function addAction()
	{

	}
	/**
	 * Action called on submit create new discussion
	 */
	public function submitAction()
	{
		if(isset($this->_helper->layout))
			$this->_helper->layout->disableLayout();
		$this->_helper->viewRenderer->setNoRender();

		$params = $this->getRequest()->getPost();

		$time = Precurio_Date::now()->getTimestamp();
		$user_id = Precurio_Session::getCurrentUserId();
		$params['message'] = trim($params['message']);
		$data = array('creator_user_id'=>$user_id,'title'=>$params['subject'],'message'=>$params['message'],'date_created'=>$time,'last_updated'=>$time,'active'=>1);

		$discussion = TeamDiscussion::createNew($data,$this->getParam('t_id'));

		$this->_redirect($discussion->getUrl());
	}
	public function updateAction()
	{
		if(isset($this->_helper->layout))
			$this->_helper->layout->disableLayout();
		$this->_helper->viewRenderer->setNoRender();

		$params = $this->getRequest()->getParams();

		$discussion = TeamDiscussion::get($params['id'],$params['t_id']);
		if(empty($discussion))return;

		$time = Precurio_Date::now()->getTimestamp();
		$user_id = Precurio_Session::getCurrentUserId();
		if(!$discussion->canAccess($user_id))return;

		switch($params['form'])
		{
			case 'deactivate':
				$discussion->do_delete();
				return;
				break;
			case 'edit_subject':
				$discussion->changeSubject($params['subject']);
				$this->redirect($discussion->getUrl());
				break;
			case 'comment':
				$discussion->postMessage($user_id,$params['message']);
				$this->redirect($discussion->getUrl());
				break;
		}
	}
	protected  function getAppName()
	{
		return "discussion";
	}

}
