<?php

/**
 * BaseController
 *
 * @author
 * @version
 */

require_once 'Zend/Controller/Action.php';
require_once ('team/models/vo/Team.php');
class Team_BaseController extends Zend_Controller_Action {

	public function init()
	{
		$root = Zend_Registry::get('root');
		if($this->view->theme != 'default')
			$this->view->addScriptPath($root .  '/application/default/layouts/default/team');
		$this->view->addScriptPath($root .  '/application/default/layouts/'.$this->view->theme.'/team');
		$layout = Zend_Layout::getMvcInstance();
		$layout->setLayoutPath($root. '/application/default/layouts/'.$this->view->theme.'/team');

		$id = $this->getParam('t_id');
		$team = Team::get($id);
		$user_id = Precurio_Session::getCurrentUserId();
		if(!$team->containsMember($user_id))
		{
			throw new Precurio_Exception(PrecurioStrings::CANNOTACCESSRESOURCE,Precurio_Exception::EXCEPTION_NO_ACCESS);
		}
		$this->view->team = $team;

		$this->view->page = $this->getAppName();
	}
	/**
	 * Gets the name of the team app. This is also the "appid"
	 * Method should be overwritten by children.
	 * @return string
	 */
	protected  function getAppName()
	{
		return "";
	}
}
