<?php
/**
 *
 * @author Brain
 * @version
 */
require_once 'Zend/View/Interface.php';
require_once 'user/models/UserUtil.php';
require_once ('task/models/Tasks.php');

class Task_View_Helper_TasksReport {

	/**
	 * @var Zend_View_Interface
	 */
	public $view;
	protected $all = 0;
	protected $pending = 0;
	protected $due = 0;
	protected $completed = 0;
	protected $my = 0;

	private function init()
	{
		$user_id = Precurio_Session::getCurrentUserId();
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::TASK, 'rowClass'=>'Task'));
		$select = $table->select(false);
		$select->setIntegrityCheck(false);
		$select->setTable($table);

		$select = $select->distinct()
		->from(array('a' => PrecurioTableConstants::TASK))
		->join(array('b' => PrecurioTableConstants::TASK_USERS),'a.id = b.task_id',array('user_id','is_proxy','is_transfer','date_assigned'=>'date_created'))
		->where('a.active = 1 AND b.active= 1 AND (a.creator_user_id = ? OR b.user_id = ?)' ,$user_id)
		->where('a.creator_group_id = 0')
		->order('end_time asc')->order('status asc')->order('start_time desc');
		$tasks = $table->fetchAll($select);

		//remove duplicates caused by joining to table "task_users"
		$result = array();
		foreach($tasks as $task)
		{
			if(isset($result[$task->getId()]))continue;

			$result[$task->getId()] = $task;

			$this->all++;

			if(!$task->isAssignedToMe())continue;//we only want to get stats for task assigned to me

			$this->my++;

			if($task->isDue())
				$this->due++;
			elseif($task->isComplete())
				$this->completed++;
			else
				$this->pending++;

		}
	}
	public function tasksReport() {
		$this->init();
		return $this;
	}
	public function getAllCount()
	{
		return $this->all;
	}
	public function getPendingCount()
	{
		return $this->pending;
	}
	public function getDueCount()
	{
		return $this->due;
	}
	public function getCompletedCount()
	{
		return $this->completed;
	}
	public function getMyCount()
	{
		return $this->my;
	}
	/**
	 * Sets the view field
	 * @param $view Zend_View_Interface
	 */
	public function setView(Zend_View_Interface $view) {
		$this->view = $view;
	}

}
