<?php

/**
 * SearchController
 *
 * @author
 * @version
 */

require_once 'Zend/Controller/Action.php';

class Search_IndexController extends Zend_Controller_Action {
	/**
	 * The default action - show the home page
	 */
	public function indexAction()
	{
		$query = $this->getRequest()->getParam('qry','');

		//$query .= strlen($query) >= 3 ? '*' : '';
		$page = $this->getRequest()->getParam('cpage',0);
		$this->view->cpage = $page;
		$this->view->query = $query;
		if($query == '')
		{

			$this->view->hits = array();
			return;

		}
		if($page == 0)
			$this->view->cpage = 1;

		$dict = new Precurio_Search();
		$hits = $dict->search($query);
		$this->view->hits = $hits;

		$ns = new Zend_Session_Namespace('temp');
		$ns->searchResult = $this->view->hits;

		//log search query
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::USER_SEARCH));
		$id = $table->insert(array(
		'user_id'=>Precurio_Session::getCurrentUserId(),
		'query'=>$query,
		'hit_count'=>count($hits),
		'date_created'=>Precurio_Date::now()->getTimestamp()
		));
		$this->renderScript("result.phtml");
	}
	public function optimiseAction()
	{
		$dict = new Precurio_Search();
		$dict->optimize();
		echo '<br/>'.$this->view->translate("Search Indexes have been optimised").'<br/>';
		$this->_helper->viewRenderer->setNoRender();
	}

	public function reindexAction()
	{
		$fn = new Precurio_FileFn();
		$dir = Zend_Registry::get('root').'/dict';
		$fn->deldir($dir);

		$dict = new Precurio_Search();
		$dict->optimize();
		
		if($this->getRequest()->getParam("ajax","0") == 1){
		    $this->_helper->layout->disableLayout(); $this->_helper->viewRenderer->setNoRender();
		    echo "Index has been updated";
		    return;
		}

		$this->renderScript("reindexed.phtml");

	}
	public function init()
	{
		$root = Zend_Registry::get('root');
		if($this->view->theme != 'default')
			$this->view->addScriptPath($root .  '/application/default/layouts/default/views/search');
		$this->view->addScriptPath($root .  '/application/default/layouts/'.$this->view->theme.'/views/search');
	}

}
?>