<?php

/**
 * SearchController
 *
 * @author
 * @version
 */

require_once 'Zend/Controller/Action.php';
require_once 'report/models/Report.php';
require_once 'report/models/AnalyticsReport.php';

class Report_SearchController extends Zend_Controller_Action {
	public function translate($str)
	{
		return $this->view->translate($str);
	}
	/**
	 * The default action - show the home page
	 */
	public function indexAction() {
		return $this->_redirect('/report/search/phrase');
	}
	public function phraseAction()
	{

        $analyticReport = new AnalyticsReport();

		$chart = Report::chart('chart1');
        $chart->setChartType('bar_glass');

        $data = $analyticReport->getMostSearchedPhrases();
		if(count($data) < 1)
		{
			echo("<div id='noRecords' align='center'>".$this->translate(PrecurioStrings::NOTENOUGHREPORTDATA) ."</div>");
			return;//no top contents, then definitely no most search content
		}

        $chart->setSource(new Bvb_Grid_Source_Array($data));

        $chart->setXLabels('word');
        $chart->addValues('value', array('set_colour' => '#BBBBFF', 'set_key' => $this->translate('Number of Times'),'set_tooltip'=>"#val# ".$this->translate("times")));

        $x  =  count($data) * 100;
        if($x>900)$x=900; //900 is the maximum value
        if($x<300)$x=300; //300 is the minimum value

        $chart->setChartDimensions($x,350);
        $chart->setMultiple(false);
		$this->view->chart = $chart->deploy();

/*********************************************************************************************/

		$chart2 = Report::chart('chart2');
        $chart2->setChartType('bar_glass');

        $data = $analyticReport->getTopFailedSearchedPhrases();
		if(count($data) < 5)
		{
			echo("<div id='noRecords' align='center'>".$this->translate(PrecurioStrings::NOTENOUGHREPORTDATA) ."</div>");
			return;//no top contents, then definitely no most search content
		}

        $chart2->setSource(new Bvb_Grid_Source_Array($data));

        $chart2->setXLabels('word');
        $chart2->addValues('value', array('set_colour' => '#FF4444', 'set_key' => $this->translate('Number of Times'),'set_tooltip'=>$this->translate("Returned no results")." #val# ".$this->translate("times")));

        $x  =  count($data) * 100;
        if($x>900)$x=900; //900 is the maximum value
        if($x<300)$x=300; //300 is the minimum value

        $chart2->setChartDimensions($x,350);
        $chart2->setMultiple(false);
		$this->view->chart2 = $chart2->deploy();
	}
	public function contentAction()
	{
		$baseUrl = $this->getRequest()->getBaseUrl();

		$grid = Report::grid('grid1');
		$analytics = new AnalyticsReport();

		$data = $analytics->getMostSearchedContent();

		if(empty($data))
		{
			echo("<div id='noRecords' align='center'>".$this->translate(PrecurioStrings::NOTENOUGHREPORTDATA) ."</div>");
			return;
		}

		$grid->setSource(new Bvb_Grid_Source_Array($data));

		$grid->updateColumn('title',array('title'=>$this->translate('Content Title')));
		$grid->updateColumn('user',array('title'=>$this->translate('Created By')));
		$grid->updateColumn('value',array('title'=>$this->translate('Number of Search Hits')));
		$grid->updateColumn('id',array('hidden'=>true));
		$grid->updateColumn('view_id',array('hidden'=>true));

		$grid->updateColumn('title',array('decorator'=>"<a href='$baseUrl/cms/view/details/c_id/{{id}}'>{{title}}</a>"));

        $this->view->grid = $grid->deploy();

        /****************************************************************************/

		$grid2 = Report::grid('grid2');

		$data = $analytics->getTopSearchOriginationContent();

		if(empty($data))
		{
			echo("<div id='noRecords' align='center'>".$this->translate(PrecurioStrings::NOTENOUGHREPORTDATA) ."</div>");
			return;
		}

		$grid2->setSource(new Bvb_Grid_Source_Array($data));

		$grid2->updateColumn('title',array('title'=>$this->translate('Content Title')));
		$grid2->updateColumn('user',array('title'=>$this->translate('Created By')));
		$grid2->updateColumn('value',array('title'=>$this->translate('Number of Search Hits')));
		$grid2->updateColumn('value',array('hidden'=>true));
		$grid2->updateColumn('id',array('hidden'=>true));
		$grid2->updateColumn('view_id',array('hidden'=>true));

		$grid2->updateColumn('title',array('decorator'=>"<a href='$baseUrl/cms/view/details/c_id/{{id}}'>{{title}}</a>"));

        $this->view->grid2 = $grid2->deploy();


	}
	public function preDispatch()
	{
		$this->_helper->layout()->setLayout(PrecurioLayoutConstants::MAIN_REPORT);
		$this->view->page = $this->getRequest()->getActionName();
	}
	public function postDispatch()
	{
		$this->render('index');
	}

}
?>