<?php

/**
 * PortalController
 *
 * @author
 * @version
 */

require_once 'Zend/Controller/Action.php';
require_once 'report/models/Report.php';
require_once 'report/models/AnalyticsReport.php';

class Report_PortalController extends Zend_Controller_Action {
	public function translate($str)
	{
		return $this->view->translate($str);
	}
	/**
	 * The default action - show the home page
	 */
	public function indexAction() {
		return $this->_redirect('/report/portal/module');
	}

	public function moduleAction()
	{
        $analyticReport = new AnalyticsReport();

		$chart = Report::chart('chart1');
        $chart->setChartType('bar_3d');

		$now = time();
		$threeMonthsAgo = $now - (60 * 60 * 24 * 7 * 13); //3months == 13 weeks
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::ANALYTIC));

		$select = $table->select(false)
		->from(array('a'=>PrecurioTableConstants::ANALYTIC),
			array('module'=>'ucase(module)','total'=>'count(*)'))
		->where('date_created > ?',$threeMonthsAgo)
		->where('module <>"default"')
		->where('module <>"document"')
		->where('module <>"install"')
		->where('module <>"widget"')
		->group('module');

		if($table->fetchAll($select)->count() < 5)
		{
			echo("<div id='noRecords' align='center'>".$this->translate(PrecurioStrings::NOTENOUGHREPORTDATA) ."</div>");
			return;//no usage, then definitely no items
		}

        $chart->setSource(new Bvb_Grid_Source_Zend_Select($select));

        $chart->setXLabels('module');
        $chart->addValues('total', array('set_colour' => '#44DD55', 'set_key' => 'Usage'));

        $chart->setChartDimensions(920,350);
        $chart->setMultiple(false);
		$this->view->chart = $chart->deploy();

/*********************************************************************************************/


		$grid = Report::grid('inventory');

		$data = $analyticReport->getModuleInventory();

		if(empty($data))
		{
			echo("<div id='noRecords' align='center'>".$this->translate(PrecurioStrings::NOTENOUGHREPORTDATA) ."</div>");
			return;
		}

		$grid->setSource(new Bvb_Grid_Source_Array($data));

		$grid->updateColumn('last_insert_date',array('format'=>'date'));
		$grid->updateColumn('last_insert_date',array('search'=>false));
		$grid->updateColumn('module',array('search'=>false));
		$grid->updateColumn('inventory',array('search'=>false));


        $this->view->grid = $grid->deploy();



	}
	public function visitorAction()
	{
		 $analyticReport = new AnalyticsReport();
		$datas = $analyticReport->getPortalVisitorsReport();


		$chart = Report::chart('chart1');
        $chart->setChartType('line');

		if(count($datas[1]) < 5)
		{
			echo("<div id='noRecords' align='center'>".$this->translate(PrecurioStrings::NOTENOUGHREPORTDATA) ."</div>");
			return;
		}

        $chart->setSource(new Bvb_Grid_Source_Array($datas[1]));

        $chart->setXLabels('week');
        $chart->addValues('total', array('set_colour' => '#44DD55', 'set_key' => $this->translate('Total Visits')));


        $chart->setChartDimensions(920,350);
        $chart->setMultiple(false);
		$this->view->chart = $chart->deploy();


		/*********************************************************************************************/


		$grid = Report::grid('visitors');

		$data = $datas[0];

		if(count($data) < 2 )
		{
			echo("<div id='noRecords' align='center'>".$this->translate(PrecurioStrings::NOTENOUGHREPORTDATA) ."</div>");
			return;
		}

		$grid->setSource(new Bvb_Grid_Source_Array($data));

		$grid->updateColumn('last_visit_date',array('format'=>'date'));
		$grid->updateColumn('user_id',array('hidden'=>true));
		$grid->updateColumn('last_visit_date',array('search'=>false));
		$grid->updateColumn('user',array('search'=>false));
		$grid->updateColumn('number_of_visits',array('search'=>false));


        $this->view->grid = $grid->deploy();

	}

	public function activityAction()
	{
		$analyticReport = new AnalyticsReport();
		$data = $analyticReport->getPortalActivity();


		$chart = Report::chart('chart1');
        $chart->setChartType('line');

        if(count($data) < 5)
		{
			echo("<div id='noRecords' align='center'>".$this->translate(PrecurioStrings::NOTENOUGHREPORTDATA) ."</div>");
			return;
		}


        $chart->setSource(new Bvb_Grid_Source_Array($data));

        $chart->setXLabels('day');
        $chart->addValues('total', array('set_colour' => '#44DD55', 'set_key' => $this->translate('Total Visits')));


        $chart->setChartDimensions(920,350);
        $chart->setMultiple(false);
		$this->view->chart = $chart->deploy();
	}

	public function preDispatch()
	{
		$this->_helper->layout()->setLayout(PrecurioLayoutConstants::MAIN_REPORT);
		$this->view->page = $this->getRequest()->getActionName();
	}
	public function postDispatch()
	{
		$this->render('index');
	}
}
?>