<?php

/**
 * ContentController
 *
 * @author
 * @version
 */

require_once 'Zend/Controller/Action.php';
require_once 'report/models/Report.php';
require_once 'report/models/AnalyticsReport.php';
require_once 'cms/models/vo/Content.php';

class Report_ContentController extends Zend_Controller_Action {

	public function translate($str)
	{
		return $this->view->translate($str);
	}
	/**
	 * The default action - show the home page
	 */
	public function indexAction() {
		return $this->_redirect('/report/content/top');
	}
	public function topAction()
	{
		$now = time();
		$threeMonthsAgo = $now - (60 * 60 * 24 * 7 * 13); //3months == 13 weeks


		$chart = Report::chart();
        $chart->setExport(array('ofc'));

        $chart->setChartType('bar_filled');

		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::CONTENT));

		$select = $table->select(true);
		$select->setIntegrityCheck(false);

		$select = $select->distinct()
				->where('date_created > ?',$threeMonthsAgo)
				->where('active=1')
				->order('num_of_hits DESC')
				->order('rating DESC')
				->limit(20);
		if($table->fetchAll($select)->count() < 5)
		{
			echo("<div id='noRecords' align='center'>".$this->translate(PrecurioStrings::NOTENOUGHREPORTDATA)."</div>");
			return;//no top contents, then definitely no most search content
		}

        $chart->setSource(new Bvb_Grid_Source_Zend_Select($select));

        $chart->setXLabels('title');
        $chart->addValues('num_of_hits', array('set_colour' => '#00FF00', 'set_key' => $this->translate('Number of Views'),'set_tooltip'=>$this->translate('Score')." = #val#"));
		$chart->setTitle($this->translate('Top Contents').' ('.$this->translate('within the last 3 months').')');

        $count = $table->fetchAll($select)->count();
        $x  =  $count * 100;
        if($x>900)$x=900; //900 is the maximum value
        if($x<300)$x=300; //300 is the minimum value

        $chart->setChartDimensions($x,350);
        $chart->setMultiple(false);
		$this->view->chart = $chart->deploy();


/**********************************************************************************/


		$grid = Report::grid('top');
		$analytics = new AnalyticsReport();

		$data = $analytics->getMostSearchedContent();

		if(empty($data))
		{
			echo("<div id='noRecords' align='center'>".$this->translate(PrecurioStrings::NOTENOUGHREPORTDATA) ."</div>");
			return;
		}

		$grid->setSource(new Bvb_Grid_Source_Array($data));

		$grid->updateColumn('title',array('title'=>$this->translate('Content Title')));
		$grid->updateColumn('user',array('title'=>$this->translate('Created By')));
		$grid->updateColumn('value',array('title'=>$this->translate('Number of Search Hits')));
		$grid->updateColumn('id',array('hidden'=>true));
		$grid->updateColumn('view_id',array('hidden'=>true));

		$baseUrl = $this->getRequest()->getBaseUrl();
		$grid->updateColumn('title',array('decorator'=>"<a href='$baseUrl/cms/view/details/c_id/{{id}}'>{{title}}</a>"));

        $this->view->grid = $grid->deploy();


	}

	public function userAction()
	{
		$grid = Report::grid('user');

		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::CONTENT,'rowClass'=>'Content'));
		$select = $table->select(false);
		$select->setIntegrityCheck(false);
		$select = $select->distinct()
				->from(array('a'=>PrecurioTableConstants::CONTENT),array('id','date_created','user_id'))
				->join(array('b' => PrecurioTableConstants::USERS),'a.user_id = b.user_id',array('total'=>'count(*)','userid'=>'user_id'))
				->where('a.active=1')
				->order('total desc')
				->group('b.user_id')
				;

		if($table->fetchAll($select)->count() < 1)
		{
			echo("<div id='noRecords' align='center'>".$this->translate(PrecurioStrings::NOTENOUGHREPORTDATA) ."</div>");
			return;//no top contents, then definitely no most search content
		}

		$grid->setSource(new Bvb_Grid_Source_Zend_Select($select));

		$grid->updateColumn('date_created',array('title'=>$this->translate('Last Contribution Date')));
		$grid->updateColumn('total',array('title'=>$this->translate('Number of Contributions')));
		$grid->updateColumn('user_id',array('title'=>$this->translate('Contributor')));
		$grid->updateColumn('id',array('hidden'=>true));
		$grid->updateColumn('userid',array('hidden'=>true));

		$grid->updateColumn('user_id',array('format'=>'User'));
		$grid->updateColumn('date_created',array('format'=>array('LastContentDate',array('{{userid}}'))));
		$grid->updateColumn('user_id',array('position'=>'1'));
		$grid->updateColumn('total',array('position'=>'2'));

		$grid->updateColumn('user_id',array('search'=>false));
		$grid->updateColumn('total',array('search'=>false));
		$grid->updateColumn('date_created',array('search'=>false));

		$baseUrl = $this->getRequest()->getBaseUrl();
		$grid->updateColumn('user_id',array('decorator'=>"<a href='$baseUrl/user/profile/view/{{userid}}'>{{user_id}}</a>"));

        $this->view->grid = $grid->deploy();
	}
	public function activityAction()
	{
		$analytics = new AnalyticsReport();
		$baseUrl = $this->getRequest()->getBaseUrl();


		$chart = Report::chart('viewactivity');
		$data = $analytics->getContentViewActivity();
		if(empty($data))
		{
			echo("<div id='noRecords' align='center'>".$this->translate(PrecurioStrings::NOTENOUGHREPORTDATA) ."</div>");
			return;
		}

		$chart->setChartType('line');
		$chart->setSource(new Bvb_Grid_Source_Array($data));
        $chart->addValues('value', array('set_colour' => '#7777FF', 'set_key' => 'Value','set_tooltip'=>"#val#"));
		$chart->setTitle($this->translate('Content View Activity') .' ('.$this->translate('within the last 3 months').')');
		$chart->setXLabels('week');

		$chart->setChartDimensions(900,250);

        $this->view->chart = $chart->deploy();

    /*****************************************************/

        $chart2 = Report::chart('addactivity');
		$data = $analytics->getContentAdditionActivity();
		if(empty($data))
		{
			echo("<div id='noRecords' align='center'>".$this->translate(PrecurioStrings::NOTENOUGHREPORTDATA)."</div>");
			return;
		}

		$chart2->setChartType('line');
		$chart2->setSource(new Bvb_Grid_Source_Array($data));
        $chart2->addValues('value', array('set_colour' => '#77FF77', 'set_key' => 'Value','set_tooltip'=>"#val#"));
		$chart2->setTitle($this->translate('Content Addition Activity').' ('.$this->translate('within the last 3 months').')');
		$chart2->setXLabels('week');

		$chart2->setChartDimensions(900,250);

        $this->view->chart2 = $chart2->deploy();

    /*****************************************************/

        $chart3 = Report::chart('editactivity');
		$data = $analytics->getContentUpdateActivity();
		if(empty($data))
		{
			echo("<div id='noRecords' align='center'>".$this->translate(PrecurioStrings::NOTENOUGHREPORTDATA) ."</div>");
			return;
		}

		$chart3->setChartType('line');
		$chart3->setSource(new Bvb_Grid_Source_Array($data));
        $chart3->addValues('value', array('set_colour' => '#FF77FF', 'set_key' => 'Value','set_tooltip'=>"#val#"));
		$chart3->setTitle($this->translate('Content Update Activity').' ('.$this->translate('within the last 3 months').')');
		$chart3->setXLabels('week');

		$chart3->setChartDimensions(900,250);

        $this->view->chart3 = $chart3->deploy();
	}
	public function preDispatch()
	{
		$this->_helper->layout()->setLayout(PrecurioLayoutConstants::MAIN_REPORT);
		$this->view->page = $this->getRequest()->getActionName();

	}
	public function postDispatch()
	{
		$this->render('index');
	}

}
?>