<?php
require_once('link/models/vo/Link.php');
class Links
{
	/**
	 * Get all links.
	 * @param int $user_id OPTIONAL, Specify user id if you want all links by a specific user.
	 * @return Zend_Db_Table_Rowset_Abstract
	 */
	public static function getAllLinks($user_id = 0)
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::LINKS, 'rowClass'=>'Link'));
		$select = $table->select()->where('active=1')->order('last_updated desc');
		if(!empty($user_id))
			$select = $select->where('user_id = ?',$user_id)->order('last_updated desc');
		$rows = $table->fetchAll($select);
		$links = array();
		foreach($rows as  $row)
		{
			if($row->getActivityId())
			{
				$links[] = $row;
			}
		}
		return $links;
	}
	/**
	 * Get people who have the most links in descending order
	 * @param int $limit OPTIONAL
	 * @return Zend_Db_Table_Rowset_Abstract
	 */
	public static function getPopularPeople($limit = 10)
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::LINKS, 'rowClass'=>'Link'));
		$select = $table->select()->from(PrecurioTableConstants::LINKS,array('num'=>'count(*)','user_id'))
							->where('active=1')->group('user_id')
							->order('num desc')->limit($limit);

		return $table->fetchAll($select);
	}
	public static function getLinksbyTag($tag)
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::LINKS, 'rowClass'=>'Link'));
		$select = $table->select(false);
		$select->setIntegrityCheck(false);
		$select->setTable($table);

		$select = $select->distinct()
						->from(array('a' => PrecurioTableConstants::LINKS))
						->join(array('b' => PrecurioTableConstants::USER_TAGS),'a.id = b.item_id',array())
						->join(array('c' => PrecurioTableConstants::TAGS),'b.tag_id = c.id',array())
						->where('a.active=1')
						->where('b.active=1')
						->where('c.title = ?',$tag)
						->order('last_updated desc');
		return $table->fetchAll($select);
	}
	/**
	 * @param int $id
	 * @return Link
	 */
	public static function getLink($id)
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::LINKS, 'rowClass'=>'Link'));
		return $table->find($id)->current();
	}
	/**
	 * Checks if a url has already been shared
	 * @param string $url
	 * @return int - the link id if it exist, or 0 otherwise.
	 */
	public static function exists($url)
	{
		$url = trim($url);
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::LINKS));
		$row = $table->fetchRow($table->select()->where('url = ?',$url)->where('active = 1'));
		return empty($row)?0:$row->id;
	}
	public static function createNew($data)
	{
		unset($data['id']);
		$tags = $data['tags'];
		unset($data['tags']);
		$tr = Zend_Registry::get('Zend_Translate');
		//first make sure it has not been shared by user
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::LINKS));
		$row = $table->fetchRow($table->select()->where('url = ?',$data['url'])->where('user_id = ?',$data['user_id'])->where('active = 1'));
		if(!empty($row))
			throw new Exception($tr->translate('Web link has already been shared'));

		$row = $table->createRow($data);
		$id = $row->save();
		if(empty($id))
		{
			throw new Precurio_Exception($tr->translate('An error occurred while submitting, please try again'), $type);
		}
		$link =  Links::getLink($id);

		$tags = explode(",",$tags);
		$tags = array_unique($tags);
		foreach($tags as $tag)
			$link->addTag($tag);

		//generate notification of new link
		Precurio_Activity::newActivity($data['user_id'],Precurio_Activity::SHARED_LINK,$id,'/link/index/view/id/'.$id)	;

		return $id;

	}
}
?>