<?php
/**
 * IndexController
 *
 * @author
 * @version
 */
require_once 'Zend/Controller/Action.php';
require_once 'link/models/Links.php';
class Link_IndexController extends Zend_Controller_Action
{
    public function indexAction ()
    {
    	$this->_helper->layout()->setLayout(PrecurioLayoutConstants::MAIN_REPORT);
    	$this->view->params = $this->getRequest()->getParams();
    }
    public function listAction()
    {
    	$user_id = $this->getRequest()->getParam('u_id',0);
    	$tag = $this->getRequest()->getParam('tag','');
    	//id param is only set from viewAction(), which inturn is only called from an activity feed
    	$link_id = $this->getRequest()->getParam('id',0);
    	if($link_id)
    	{
    		$this->view->id = $link_id;
    		$this->view->links = array(Links::getLink($link_id));
			$this->view->params = $this->getRequest()->getParams();
			return;
    	}

    	if(!empty($tag))
    	{
    		$this->view->tag = $tag;
    		$this->view->links = Links::getLinksbyTag($tag);
    	}
    	else
    	{
    		$this->view->user_id = $user_id;
			$this->view->links = Links::getAllLinks($user_id);
    	}
		$this->view->cpage = $this->getRequest()->getParam('cpage',1);
    }
	public function shareAction()
    {
    	$this->_helper->layout->disableLayout();
    	$url = $this->getRequest()->getParam('url','');
    	if(strtolower(substr($url,0,3)) == 'www')
		{
			$url = 'http://'.$url;
		}

    	$info = $this->fetch_and_parse_page($url);
    	$link_id = Links::exists($url);
    	if(!empty($link_id))
    	{
    		$this->view->id = $link_id;
    		//comment the line below to allow multiple users share a link
	    	//$this->view->link = Links::getLink($link_id);//convert to edit mode if link already exists
    	}
    	$this->view->url = $url;
    	$this->view->title = $info['title'];
    	$this->view->description = strip_tags($info['description']);
    	$this->view->keywords = UserTag::getRecommended($info['keywords'],$info['title'],$info['description']);
    }
	public function viewAction()
	{
		$link_id = $this->getRequest()->getParam('id',0);
		$this->_redirect('/link/index/index/id/'.$link_id);
	}
	function submitAction()
	{
		$data = $this->getRequest()->getPost();
		$data = Precurio_Utils::cleanPostData($data);
		if(empty($data['title']))
		{
			$error .= $this->view->translate('Submit Failed. You did not enter a link title').'<br/>';
		}

		if(isset($error))
		{
			$this->_helper->flashMessenger()->addMessage($error);
			$this->_redirect('/link');
		}
		try
		{
			if(empty($data['id']))
			{
				$id = Links::createNew($data);
			}
			else
			{
				$id = $data['id'];
				$link = Links::getLink($id);
				$link->update($data);
			}
		}
		catch(Exception $e)
		{
			$this->_helper->flashMessenger()->addMessage($e->getMessage());
			$this->_redirect('/link');
		}
		$this->_redirect('/link/');
	}
	/**
	 * Called when user clicks "delete"
	 */
	public function confirmdeleteAction()
	{
		$this->_helper->layout->disableLayout();
		$this->view->id  = $this->getRequest()->getParam('id');
	}
	public function deleteAction()
	{
		$link_id = $this->getRequest()->getParam('id');
		$link = Links::getLink($link_id);
		//Only the user of the analyst can delete the request
		if($link->user_id == Precurio_Session::getCurrentUserId())
		{
			$link->do_delete();
		}
		$this->_redirect('/link');

	}
	public function editAction()
	{
		$this->_helper->layout->disableLayout();
		$link_id = $this->getRequest()->getParam('id');
		$this->view->link = Links::getLink($link_id);
		$this->render('share');
	}
	function fetch_and_parse_page($url)
	{
	    $html = file_get_contents($url);

	    /* get page's title */
	    preg_match("/<title>(.+)<\/title>/siU", $html, $matches);
	    $title = $matches[1];

	    /* get page's keywords */
	    $re="<meta\s+name=['\"]??keywords['\"]??\s+content=['\"]??(.+)['\"]??\s*\/?>";
	    preg_match("/$re/siU", $html, $matches);
	    $keywords = $matches[1];

	    /* get page's description */
	    $re="<meta\s+name=['\"]??description['\"]??\s+content=['\"]??(.+)['\"]??\s*\/?>";
	    preg_match("/$re/siU", $html, $matches);
	    $desc = $matches[1];

	    $info = array(
	        "url"         => $url,
	        "title"       => $title,
	        "keywords"    => $keywords,
	        "description" => $desc,
	    );

	    return($info);
	}
}
?>