<?php
require_once 'user/models/vo/User.php';
class ExtranetUser extends User {
	/**
	 * Get an extranet user
	 * @param in $user_id
	 * @param boolean $throwError
	 * @throws Precurio_Exception
	 * @throws Exception
	 * @return ExtranetUser
	 */
	public static function get($user_id=null, $throwError = false)
	{
		if(Zend_Registry::isRegistered('Zend_Translate'))
			$tr = Zend_Registry::get('Zend_Translate');
		try
		{

			$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::USERS,'rowClass'=>'ExtranetUser'));
			$userVo = $table->fetchRow($table->select()->where('user_id = ? ',$user_id)->where('is_external = 1'));
			if(Precurio_Utils::isNull($userVo))
			{
				$msg = isset($tr) ? $tr->translate(PrecurioStrings::NOSUCHUSER) : PrecurioStrings::NOSUCHUSER;
				throw new Precurio_Exception($msg,Precurio_Exception::EXCEPTION_NO_SUCH_USER);
			}
		}
		catch(Exception $e)
		{
			if($throwError)throw $e;
			return null;
		}
		return $userVo;
	}
	/**
	 * Get all documents uploaded by user (if allowed) or shared directly with the user
	 * @param int $user_id
	 * @return Zend_Db_Table_Rowset_Abstract
	 */
	public function getDocuments()
	{
		$result = array();
		$user_id = $this->getId();
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::CONTENT,'rowClass'=>'Document'));

		$select = new Zend_Db_Table_Select($table);
		$select->setIntegrityCheck(false);
		$select = $select->from(array('a' => PrecurioTableConstants::CONTENT),Document::$requiredContentProp)
		->join(array('b' => PrecurioTableConstants::DOCUMENTS),'a.id = b.content_id')
		->join(array('c' => PrecurioTableConstants::SHARED_CONTENTS),'a.id = c.content_id',array())
		->where('a.active = 1')
		->where('a.user_id = ? OR c.user_id = ?',$user_id,$user_id)
		->order('a.date_created desc');

		$rows = $table->fetchAll($select);
		foreach($rows as $row)
			$result[$row->id] = $row;

		//now we also get documents that have been shared with group user belongs to.
		//note, this only gets document that was shared with groups and not content of folders that was shared.
		$select = new Zend_Db_Table_Select($table);
		$select->setIntegrityCheck(false);
		$select = $select->from(array('a' => PrecurioTableConstants::CONTENT),Document::$requiredContentProp)
		->join(array('b' => PrecurioTableConstants::DOCUMENTS),'a.id = b.content_id')
		->join(array('c' => PrecurioTableConstants::GROUP_CONTENTS),'a.id = c.content_id',array())
		->join(array('d' => PrecurioTableConstants::USER_GROUPS),'c.group_id = d.group_id',array())
		->where('a.active = 1')
		->where('d.user_id = ?',$user_id)
		->order('a.date_created desc');

		$rows = $table->fetchAll($select);
		foreach($rows as $row)
		{
			if(!isset($result[$row->id]))
				$result[$row->id] = $row;
		}

		uasort($result,function($a,$b){
			$a = $a->date_created;
			$b = $b->date_created;
			if ($a == $b) {
				return 0;
			}
			return ($a > $b) ? -1 : 1;
		});

		return $result;
	}
	/**
	 * Get all tasks associated with user
	 * @param int $user_id
	 * @version 4
	 * @return array
	 */
	public function getTasks()
	{
		$user_id = $this->getId();
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::TASK, 'rowClass'=>'Task'));
		$select = $table->select(false);
		$select->setIntegrityCheck(false);
		$select->setTable($table);

		$select = $select->distinct()
		->from(array('a' => PrecurioTableConstants::TASK))
		->join(array('b' => PrecurioTableConstants::TASK_USERS),'a.id = b.task_id',array('user_id','is_proxy','is_transfer','date_assigned'=>'date_created'))
		->where('a.active = 1 AND b.active= 1 AND (a.creator_user_id = ? OR b.user_id = ?)' ,$user_id)
		->order('end_time asc')->order('status asc')->order('start_time desc');
		$tasks = $table->fetchAll($select);
		//remove duplicates caused by joining to table "task_users"
		$result = array();
		foreach($tasks as $task)
		{
			$result[$task->getId()] = $task;
		}
		return $result;
	}
	public function getDiscussions()
	{
		$user_id = $this->getId();
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::DISCUSSIONS,'rowClass'=>'Discussion'));
		$select = $table->select(false);
		$select->setIntegrityCheck(false);
		$select->setTable($table);

		$select = $select->distinct()
		->from(array('a' => PrecurioTableConstants::DISCUSSIONS))
		->join(array('b' => PrecurioTableConstants::DISCUSSION_USERS),'a.id = b.discussion_id',array('user_id'))
		->where('a.active = 1 AND b.active= 1 AND (a.creator_user_id = ? OR b.user_id = ?)' ,$user_id)
		->order('last_updated desc');
		$items = $table->fetchAll($select);
		//remove duplicates caused by joining tables
		$result = array();
		foreach($items as $item)
			$result[$item->id] = $item;

		//now get discussions that have been shared with groups user belong to.
		$select = $table->select(false);
		$select->setIntegrityCheck(false);
		$select->setTable($table);

		$select = $select->distinct()
		->from(array('a' => PrecurioTableConstants::DISCUSSIONS))
		->join(array('b' => PrecurioTableConstants::DISCUSSION_GROUPS),'a.id = b.discussion_id',array('group_id'))
		->join(array('c' => PrecurioTableConstants::USER_GROUPS),'b.group_id = c.group_id',array())
		->where('a.active = 1 AND b.active= 1 AND  c.user_id = ?' ,$user_id)
		->order('last_updated desc');
		$items = $table->fetchAll($select);
		//remove duplicates caused by joining tables
		foreach($items as $item)
			$result[$item->id] = $item;

		//now get discussions in forums thathave been shared with groups user belong to.
		$select = $table->select(false);
		$select->setIntegrityCheck(false);
		$select->setTable($table);

		$select = $select->distinct()
		->from(array('a' => PrecurioTableConstants::DISCUSSIONS))
		->join(array('b' => PrecurioTableConstants::CATEGORYS),'a.category_id = b.id',array())
		->join(array('c' => PrecurioTableConstants::GROUP_CATEGORYS),'b.id = c.category_id',array('group_id'))
		->join(array('d' => PrecurioTableConstants::USER_GROUPS),'c.group_id = d.group_id',array())
		->where('a.active = 1 AND b.active= 1 AND c.active= 1 AND  d.user_id = ?' ,$user_id)
		->order('last_updated desc');
		$items = $table->fetchAll($select);
		//remove duplicates caused by joining tables
		foreach($items as $item)
			$result[$item->id] = $item;

		//sort result
		uasort($result,function($a,$b){
			$a = $a->last_updated;
			$b = $b->last_updated;
			if ($a == $b) {
				return 0;
			}
			return ($a > $b) ? -1 : 1;
		});
		return $result;
	}

}

?>