<?php

/**
 * UserController
 *
 * @author
 * @version
 */

require_once 'extranet/controllers/BaseController.php';
require_once 'Precurio/Upload.php';
require_once ('user/models/UserUtil.php');
require_once ('cms/models/vo/Content.php');

class Extranet_UserController extends Extranet_BaseController {
	/**
	 * The default action - show the home page
	 */
	public function indexAction()
	{

	}
	public function editAction()
	{

	}
	public function registerAction()
	{
		$id = $this->getParam('id',0);
		if(empty($id))return;//link was accessed by user
		$email = Precurio_Utils::decrypt($id);
		if(empty($email))return;//invalid param sent (user tried hacking)
		$activity_id = Precurio_Extranet::isInvited($email);
		if(empty($activity_id))return;//email was not invited (user successfully hacked email code)
		$user_id = Precurio_Extranet::isRegistered($email);
		if(!empty($user_id))
		{
			$this->_redirect("/login");
			return;//email has already been registered.
		}
		$this->view->email = $email;
	}
	public function submitAction()
	{
		$params = $this->getRequest()->getPost();
		$email = $params['email'];
		$activity_id = Precurio_Extranet::isInvited($email);
		if(empty($activity_id))return;//email was not invited (user successfully hacked email code)
		$user_id = Precurio_Extranet::isRegistered($email);
		if(!empty($user_id))
		{
			$this->_redirect("/login");
			return;//email has already been registered.
		}
		$params['password'] = $params['password1'];
		$user_id = Precurio_Extranet::createUser($params);
		$this->_redirect('/extranet/user/');
	}
	public function loginAction()
	{
		$this->_helper->layout->setLayout('login');
		try
		{
			$user_id = Precurio_Session::getCurrentUserId();
			$user = UserUtil::getUser($user_id);
			Precurio_Session::logOut();
			throw new Precurio_Exception($this->view->translate(PrecurioStrings::SESSIONEXPIRED),Precurio_Exception::EXCEPTION_SESSION_EXPIRED);
		}
		catch (Precurio_Exception $e)//i.e there was a problem retrieving the session user
		{
			//simply do nothing and continue execution
		}
	}
	public function logoutAction()
	{
		Precurio_Session::logOut();
		return $this->_redirect('/extranet/user/login');
	}



	public function updateAction()
	{
		$user = UserUtil::getUser(Precurio_Extranet::getCurrentUserId());
		$params = $this->getRequest()->getParams();
		if(isset($_FILES['profile_pic']) && $_FILES['profile_pic']['size'] > 0)
		{
			$filePath = Content::addPhoto('profile_pic',true);
			$picId = $user->newProfilePic($filePath);
			$params['profile_picture_id']=$picId;
		}
		if($params['locale'])
		{
			$s = new UserSetting(Precurio_Extranet::getCurrentUserId());
			$s->setLocale($params['locale']);
			unset($params['locale']);
		}

		$user->update($params);
		$this->_redirect('/extranet/user/edit');
		return;
	}
	public function changepasswordAction()
	{
		$this->_helper->layout->disableLayout();
		$this->_helper->viewRenderer->setNoRender();

		$params = $this->getRequest()->getParams();
		$user = UserUtil::getUser(Precurio_Extranet::getCurrentUserId());
		if(md5($params['cp']) !== $user->password)
		{
			echo($this->view->translate('Current password is not correct'));
			return;
		}
		if($params['np'] !== $params['np2'])
		{
			echo($this->view->translate('Your new passwords do not match'));
			return;
		}
		if( strlen($params['np']) < 6)
		{
			echo($this->view->translate('Your new password is invalid, enter at least 6 characters'));
			return;
		}
		$user->updatePassword($params['np']);
		echo($this->view->translate('You have successfully changed your password'));
	}

	public function uploadpicAction()
	{
		$this->_helper->layout->disableLayout();
		$this->_helper->viewRenderer->setNoRender();

		if(!isset($_FILES['profile_pic']))
		{
			$this->_redirect('/extranet/user/edit');
			return;
		}

		$filePath = Content::addPhoto('profile_pic',true);
		$user = UserUtil::getUser(Precurio_Extranet::getCurrentUserId());
		$picId = $user->newProfilePic($filePath);
		$user->update(array('profile_picture_id'=>$picId));
		$this->_redirect('/extranet/user/edit');
		return;
	}

	public function forgotAction()
	{
		$this->_helper->layout->setLayout('login');

		$params = $this->getRequest()->getPost();
		if(count($params))
		{
			$this->view->submited = true;
			$email = $params['id'];
			$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::AUTH));
			$row = $table->fetchRow($table->select()->where('identity = ?',$email));
			if(empty($row))//no user with that email.
			{
				$this->view->error = true;
				return false;
			}

			$this->sendResetLink($row->id,$email);
		}

	}
	private function sendResetLink($user_id,$email)
	{
		//first create this activity
		$activity_id = Precurio_Activity::create(User::APPID, User::ACTIVITY_FORGOT_PASSWORD, $user_id, $user_id,null,-2);
		if(empty($activity_id))return;
		$activity = UserActivity::get($activity_id);

		//get a code
		$code = UserCode::generate($user_id, $activity);

		$baseUrl = Precurio_Extranet::getBaseUrl();

		$format = Precurio_Activity::getMessageFormat($activity,'mail');
		$resetUrl = $baseUrl.'/user/reset/id/'.$code;
		$user = UserUtil::getUser($user_id);
		$body = getLocalizedString($format,$user->getFullName(),$user->getGenderPronoun(),$resetUrl,"",$user_id,0,$baseUrl,"","");

		$mail = new Precurio_Mail();
		$mail->sendData(array(
				'to'=>$email,
				'subject'=>$activity->getMailSubject(),
				'body'=>$body,
				'activity_id'=>$activity->getId()
		));
	}
	public function resetAction()
	{
		$this->_helper->layout->setLayout('login');

		$code = $this->getParam('id',0);
		if(empty($code))
		{
			$this->_redirect("/extranet/user/login");
			return;//link was accessed by user
		}

		$userCode = UserCode::getCode($code);

		if(empty($userCode))
		{
			$this->_redirect("/extranet/user/login");
			return;//link was accessed by user
		}
		if($userCode->isExpired())
		{
			$this->view->error = "The reset link has expired.";
			return;//link was accessed by user
		}

		$user = $userCode->getUser();

		$lastActivity = $user->getLastActivity();

		if($lastActivity->getId() != $userCode->activity_id)//user has performed an activity since requesting for password reset
		{
			$this->view->error = "This link is no more valid.";
			return;//link was accessed by user
		}

		$this->view->email = $user->getFullName();
		$this->view->id = $code;
	}
	public function submitresetAction()
	{
		$this->_helper->layout->disableLayout();
		$this->_helper->viewRenderer->setNoRender();

		$params = $this->getRequest()->getPost();

		$userCode = UserCode::getCode($params['id']);

		if(empty($userCode) || empty($params['password']))
		{
			echo "Invalid link.";
			return;//link was accessed by user
		}
		if($userCode->isExpired())
		{
			echo "The reset link has expired.";
			return;//link was accessed by user
		}

		$user = $userCode->getUser();
		$user->updatePassword($params['password']);
		echo($this->view->translate('You have successfully changed your password'));
		return;
	}
	/**
	 * This is an exact replica of default/login/submit.
	 * If there is any change there, simply copy and replace this one.
	 */
	public function submitloginAction()
	{
		$this->_helper->layout->setLayout('login');
		$params = $this->getRequest()->getParams();
		if(!isset($params['username']))
		{
			$ns = new Zend_Session_Namespace(Precurio_Session::NAMESPACE_USER);
			if(!isset($ns->currentUser))//throw a re-login error because session has expired
			{
				throw new Precurio_Exception($this->view->translate(PrecurioStrings::SESSIONEXPIRED),Precurio_Exception::EXCEPTION_SESSION_EXPIRED);
			}

			$user = $ns->currentUser;
			$params['username'] = $user->identity;
			$params['password'] = $user->credential;
		}

		$config = Zend_Registry::get('config');

		$auth = $this->_helper->getHelper($config->auth_mech);
		try
		{
			$this->view->isValid = $auth->validate($params['username'],$params['password']);
		}
		catch(Zend_Auth_Adapter_Exception  $err)
		{
			Precurio_Exception::dispatchError($err,$this->getRequest());
		}
		if($auth->getCode() != Zend_Auth_Result::SUCCESS)
		{

			$this->view->loginError = $auth->getErrorMessage();
		}
		else
		{
			$login = $auth->getUser();
			$user_id = $login->id;
			$user = UserUtil::getUser($user_id);
			$isExtranet = $user->isExternal();

			$ns = new Zend_Session_Namespace(($isExtranet ? Precurio_Session::NAMESPACE_EXTRANET : Precurio_Session::NAMESPACE_USER));
			Precurio_Session::setCurrentUser($auth->getUser(),$isExtranet);
			if(isset($ns->lastRequest))
			{
				$uri = unserialize($ns->lastRequest);

				$baseUrl = $this->getRequest()->getBaseUrl();
				if($baseUrl != "")
				{
					$uri = substr($uri,strlen($baseUrl));
				}
				$log = Zend_Registry::get('log');
				$log->info($uri);

				return $this->_redirect($uri);
			}
			else
			{
				if($user->getPercentageComplete() <= 40 && $config->force_profile_complete)
				{
					$this->_redirect(($isExtranet ? '/extranet/user' : '/user/profile/edit'));
				}
				else
				{
					$this->_redirect(($isExtranet ? '/extranet/user' : '/default/index/home'));
				}
			}
		}
	}
}
