<?php

/**
 * TaskController
 *
 * @author
 * @version
 */

require_once 'extranet/controllers/BaseController.php';
require_once 'task/models/vo/Task.php';
class Extranet_TaskController extends Extranet_BaseController {
	/**
	 * The default action - show the home page
	 */
	public function indexAction()
	{
		$user_id = Precurio_Extranet::getCurrentUserId();
		$user = ExtranetUser::get($user_id);
		$tasks = $user->getTasks();
		$this->view->tasks = $tasks;
	}
	public function viewAction()
	{
		$task_id = $this->getRequest()->getParam('id',0);
		$task = Task::get($task_id);

		if(empty($task) || !$task->isActive())
		{
			throw new Precurio_Exception(PrecurioStrings::INVALIDPAGEACCESS, Precurio_Exception::EXCEPTION_INVALID_CONTENT);
		}
		if(!$task->canAccess(Precurio_Extranet::getCurrentUserId()))
		{
			throw new Precurio_Exception(PrecurioStrings::CANNOTACCESSRESOURCE, Precurio_Exception::EXCEPTION_NO_ACCESS);
		}

		$this->view->task = $task;
	}
	public function commentAction()
	{
		if(isset($this->_helper->layout))
			$this->_helper->layout->disableLayout();
		$this->_helper->viewRenderer->setNoRender();

		$params = $this->getRequest()->getPost();
		$user_id = Precurio_Extranet::getCurrentUserId();

		$task = Task::get($params['id']);

		if(empty($task) || !$task->isActive())
		{
			throw new Precurio_Exception(PrecurioStrings::INVALIDPAGEACCESS, Precurio_Exception::EXCEPTION_INVALID_CONTENT);
		}
		if(!$task->canAccess(Precurio_Extranet::getCurrentUserId()))
		{
			throw new Precurio_Exception(PrecurioStrings::CANNOTACCESSRESOURCE, Precurio_Exception::EXCEPTION_NO_ACCESS);
		}


		$message = trim($params['message']);
		if(!empty($message))
			Comment::create($user_id, $message, $params['id'],$params['appid']);

		$this->redirect(Precurio_Extranet::getBaseUrl().'/task/view/id/'.$params['id']);
	}
	public function exportAction()
	{
		$this->_helper->layout->disableLayout();
		$this->_helper->viewRenderer->setNoRender();

		$task_id = $this->getRequest()->getParam('id',0);
		$task = Task::get($task_id);
		if(empty($task) || !$task->isActive())
		{
			throw new Precurio_Exception(PrecurioStrings::INVALIDPAGEACCESS, Precurio_Exception::EXCEPTION_INVALID_CONTENT);
		}
		if(!$task->canAccess(Precurio_Extranet::getCurrentUserId()))
		{
			throw new Precurio_Exception(PrecurioStrings::CANNOTACCESSRESOURCE, Precurio_Exception::EXCEPTION_NO_ACCESS);
		}

		$iCal = $task->export(Precurio_Extranet::getCurrentUserId());
		$filename = $task->getTitle().".ics";
		$this->getResponse()->setHeader('Content-Description','File Transfer');
		$this->getResponse()->setHeader('Content-Disposition',"attachment; filename=$filename");
		$this->getResponse()->setHeader('Content-Type','text/calendar');
		$this->getResponse()->setHeader('Content-Transfer-Encoding','binary');
		echo $iCal;
	}

}