<?php

/**
 * DocumentController
 *
 * @author
 * @version
 */

require_once 'extranet/controllers/BaseController.php';
require_once 'document/models/vo/Document.php';
class Extranet_DocumentController extends Extranet_BaseController {
	/**
	 * The default action - show the home page
	 */
	public function indexAction()
	{
		$user_id = Precurio_Extranet::getCurrentUserId();
		$user = ExtranetUser::get($user_id);
		$documents = $user->getDocuments();
		$this->view->documents = $documents;
	}
	public function viewAction()
	{
		$id = $this->getRequest()->getParam('id');
		$document = Document::get($id);

		if(empty($document))
		{
			throw new Precurio_Exception($this->view->translate(Precurio_Exception::EXCEPTION_MISSING_CONTENT),Precurio_Exception::EXCEPTION_MISSING_CONTENT);
		}
		if(!$document->canAccess(Precurio_Extranet::getCurrentUserId()))
		{
			throw new Precurio_Exception($this->view->translate(PrecurioStrings::CANNOTACCESSRESOURCE),Precurio_Exception::EXCEPTION_NO_ACCESS);
		}

		$document->viewed(Precurio_Extranet::getCurrentUserId());

		$this->view->document = $document;
	}
	public function downloadAction()
	{
		$this->_helper->layout->disableLayout();
		$this->_helper->viewRenderer->setNoRender();

		$content_id = $this->getRequest()->getParam('c_id');
		$document = Documents::getDocument($content_id);
		if(!$document->canAccess(Precurio_Extranet::getCurrentUserId()))
		{
			throw new Precurio_Exception(PrecurioStrings::CANNOTACCESSRESOURCE, Precurio_Exception::EXCEPTION_NO_ACCESS);
		}
		$version = $this->getRequest()->getParam('v',0);
		$document = Document::getVersion($document->getId(), $version);

		$document->download(Precurio_Extranet::getCurrentUserId());
	}
	public function commentAction()
	{
		if(isset($this->_helper->layout))
			$this->_helper->layout->disableLayout();
		$this->_helper->viewRenderer->setNoRender();

		$params = $this->getRequest()->getPost();
		$user_id = Precurio_Extranet::getCurrentUserId();

		$document = Document::get($params['id']);

		if(empty($document) || !$document->canAccess($user_id))
		{
			throw new Precurio_Exception(PrecurioStrings::CANNOTACCESSRESOURCE, Precurio_Exception::EXCEPTION_NO_ACCESS);
		}


		$message = trim($params['message']);
		if(!empty($message))
			Comment::create($user_id, $message, $params['id'],$params['appid']);

		$this->redirect(Precurio_Extranet::getBaseUrl().'/document/view/id/'.$params['id']);
	}
}
