<?php
require_once ('document/models/Folders.php');
require_once ('document/models/vo/ISpecialFolder.php');

/**
 * Event Folder Object.
 *
 * To implement a special folder, you only need override 3 methods. i.e. the constructor, getAppId() and getActivityType
 * @author brain
 *
 */
class EventFolder extends Folder implements ISpecialFolder
{
	protected $item_id;
	protected $item;
	public function __construct($event_id)
	{

		$tr = Zend_Registry::get('Zend_Translate');
		$this->_data = array(
		'id'=>RootFolder::SPECIAL_ID_EVENT,
		'user_id'=>0,
		'parent_id'=>RootFolder::SPECIAL_ID_SHARED,
		'title'=>$tr->translate('Event Files and Photos'),
		'description'=>'',
		'access_type'=>RootFolder::ACCESS_SHARED,
		'special_id'=>RootFolder::SPECIAL_ID_EVENT
		);
		$this->item_id = $event_id;
		$this->item = Event::get($event_id);
	}
	public function getAppId()
	{
		return Event::APPID;
	}
	public function getActivityType($isPhoto = true)
	{
		return $isPhoto ? Event::ACTIVITY_ADD_PHOTO : Event::ACTIVITY_ADD_FILE;
	}
	public function isPublic()
	{
		return true;
	}
	public function getUrl()
	{
		return $this->item->getUrl();
	}
	public function getItemId()
	{
		return $this->item_id;
	}

	public function addContents($content_ids,$access_type = Category::ACCESS_PRIVATE)
	{
		$user_id = Precurio_Session::getCurrentUserId();
		if(!is_array($content_ids))$content_ids = array($content_ids);

		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::CONTENT_CATEGORYS));
		$table2 = new Zend_Db_Table(array('name'=>PrecurioTableConstants::APP_DOCUMENTS));
		foreach($content_ids as $content_id)
		{

			$content = MyContents::getContent($content_id,false);
			$fileExt =  strtolower(substr(strrchr($content->title, "."), 1));

			if(in_array($fileExt, array('jpg','png','jpeg')))
			{
				$content->setFromArray(array(
					'is_photo'=>1,
					'image_path'=>Content::PATH_THUMBNAILS.$content->title
				));
				$content->save();
			}
			$table->insert(array(
					'category_id'=>$this->special_id,
					'content_id'=>$content_id,
					'user_id'=>$user_id,
					'date_created'=>Zend_Date::now()->getTimestamp(),
					'active'=>1
			));
			$table2->insert(array(
					'appid'=>$this->getAppId(),
					'item_id'=>$this->getItemId(),
					'content_id'=>$content_id,
					'user_id'=>$user_id,
					'date_created'=>Zend_Date::now()->getTimestamp(),
					'active'=>1

			));

			Precurio_Activity::create($this->getAppId(),$this->getActivityType($content->is_photo),$this->getItemId(),$user_id);
		}
		return;
	}
	public function getContentChildren($recursive = true)
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::APP_DOCUMENTS));
		$rows =  $table->fetchAll($table->select()->where('appid = ?',$this->getAppId())
											->where('item_id = ?',$this->getItemId())
											->where('active = 1'));
		$result = array();
		foreach($rows as $row)
		{
			try
			{
				$doc = Documents::getDocument($row->content_id,false);
				if($doc && $doc->isActive())
					$result[] = $doc;
			}
			catch (Precurio_Exception $e){}
		}
		return $result;
	}
	/**
	 * Remove content from category, this does not delete the contents themeselves.
	 * It simply removes the relationship
	 * @param array|int $content_ids
	 * @return null
	 */
	public function removeContents($content_ids)
	{
		if(!is_array($content_ids))$content_ids = array($content_ids);
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::CONTENT_CATEGORYS));
		$table2 = new Zend_Db_Table(array('name'=>PrecurioTableConstants::APP_DOCUMENTS));
		$id = $this->id;
		$appid = $this->getAppId();
		$item_id = $this->getItemId();
		foreach($content_ids as $content_id)
		{
			$table->delete("content_id = $content_id and category_id = $id");
			$table2->update(array('active'=>0),"item_id = $item_id AND appid = '$appid' AND content_id = $content_id");
		}
		return;
	}

}
?>