<?php

require_once ('Zend/Db/Table/Row/Abstract.php');
require_once ('cms/models/vo/Content.php');
require_once ('Precurio/ActivityInterface.php');
require_once ('event/models/vo/EventFolder.php');
class Event extends Zend_Db_Table_Row_Abstract implements Precurio_ObjectInterface, Precurio_SearchableInterface{
	 const ATTENDING = 3;
	 const NOTSURE = 2;
	 const NOTATTENDING = 1;
	 const PAST = 'past';
	 const UPCOMING = 'upcoming';
	 const ONGOING = 'ongoing';
	 const MY = 'my';

	 const ACTIVITY_ADD_EVENT = "new";
	 const ACTIVITY_EDIT_EVENT = "edit";
	 const ACTIVITY_ADD_FILE = "add_file";
	 const ACTIVITY_ADD_PHOTO = "add_photo";
	 const ACTIVITY_INVITE_USER = "add_user";

	 const APPID = "event";
	 const VIEW_URL =  "/event/index/details/e_id/{1}";
	public function getId()
	{
		return $this->id;
	}
	public function getTitle()
	{
		return $this->title;
	}
	public function getUserId()
	{
		return $this->user_id;
	}
	public function getSummary()
	{
		return $this->summary;
	}
	public function getDescription()
	{
		return $this->description;
	}
	public function getLocation()
	{
		if(empty($this->location_id))return null;
		return Location::getLocationName($this->location_id);
	}
	public function getVenue()
	{
		if(empty($this->venue))return $this->getLocation();
		return $this->venue;
	}
	/**
	 * Get the start date
	 * @return Ambigous <string, unknown>
	 */
	public function getDate($returnString=true)
	{
		$date =  new Precurio_Date(trim($this->start_timestamp));
		$time = $this->start_time;
		$time = strpos($time,"pm") ? intval($time) + 12 : intval($time);
		if($time==24)$time=12;//if time is 24, it means time was 12pm. revert back. The above logic of adding 12 to pm values fails when it is 12pm
		$date->setTime($time);
		return $returnString ? $date->get(Precurio_Date::DATE_LONG) : $date;
	}
	public function getEndDate($returnString=true)
	{
		$date = new Precurio_Date($this->end_date,null,'de');
		$time = $this->end_time;
		$time = strpos($time,"pm") ? intval($time) + 12 : intval($time);
		if($time==24)$time=12;//if time is 24, it means time was 12pm. revert back. The above logic of adding 12 to pm values fails when it is 12pm
		$date->setTime($time);

		$user = UserUtil::getUser(Precurio_Session::getCurrentUserId());
            $userSettings = $user->getSettings();
            $loc = $userSettings->getLocale();
		$date->setLocale($loc);
		return $returnString ? $date->get(Precurio_Date::DATE_LONG) : $date;
	}
	public function getImagePath()
	{
		$root = Zend_Registry::get('root');
		if(stristr($this->logo, 'public/'))//if it already contains the baseurl, remove it
		{
			$this->logo = substr($this->logo, stripos($this->logo,'/uploads'));
		}
		if(!is_file($root.'/public/'.$this->logo))
			return '/uploads/event-banner-default.png';
		return $this->logo;
	}
	/**
	 * Returns the state of the event, whether upcoming,past or ongoing
	 * @return string
	 */
	public function getState()
	{
		$now = time();
		$startDate = new Precurio_Date($this->start_date);
		$endDate = new Precurio_Date($this->end_date);
		if($now > $startDate->getTimestamp())
			return Event::PAST;
		else
			return Event::UPCOMING;

	}
	public function isPast()
	{
		$date = $this->getDate(false);
		return !Precurio_Date::now()->isEarlier($date);
	}
	public function isPublic()
	{
		return $this->is_open;
	}
	public function getInvitees()
	{
		$db = Zend_Registry::get('db');
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::USER_EVENTS));
		$select = $table->select(false);
		$select->setIntegrityCheck(false);
		$select = $select->from(array('a'=>PrecurioTableConstants::USER_EVENTS),array('user_id'=>'invitee_id'))
							->join(array('b'=>PrecurioTableConstants::USERS),'a.invitee_id = b.user_id',array('full_name'=>'first_name','email'))
							->where('invitee_id <> ?',$this->user_id )
							->where('event_id = ?',$this->getId() )
							->where('b.active = 1');
		$user_ids = $db->fetchAll($select);
		return $user_ids;
	}
	/**
	 * @deprecated
	 * @param unknown $user_ids
	 */
	public function setInvitees($user_ids)
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::USER_EVENTS));
		//delete all previous invitees. remember to exempt the creator.
		$where = $table->getAdapter()->quoteInto('invitee_id <> ?', $this->user_id);
		$where2 = $table->getAdapter()->quoteInto('event_id = ?',$this->getId() );
		$n = $table->delete(array($where,$where2));//$n will be 0 for a new invitation
		$data = array();
		$data['event_id'] = $this->getId();
		$data['date_created'] = Precurio_Date::now()->getTimestamp();
		foreach($user_ids as $user_id)
		{
			$data['invitee_id'] = $user_id;
			$row = $table->createRow($data);
			$row->save();
			if($n==0)
			{
				//only send an invitation notification, if there has been no previous notification.
				//else , already invited people will keep getting invitation notifications  anytime there
				//is a new invite.
				$url = '/event/'.($this->isPast() ? 'past' : 'upcoming'). '/details/e_id/'.$this->getId();
			}

		}
	}
	public function inviteUser($user_id)
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::USER_EVENTS));
		$row = $table->fetchRow($table->select()->where('event_id = ?',$this->getId())->where('invitee_id = ?',$user_id));
		if($row)return;//user has already been invited
		if(empty($user_id))return;
		$data = array();
		$data['event_id'] = $this->getId();
		$data['date_created'] = Precurio_Date::now()->getTimestamp();
		$data['invitee_id'] = $user_id;
		$data['user_id'] = Precurio_Session::getCurrentUserId();
		$row = $table->createRow($data);
		$row->save();
		Precurio_Activity::create(self::APPID, self::ACTIVITY_INVITE_USER, $this->getId(), $user_id,null,$user_id);
		return;
	}
	public function uninviteUser($user_id)
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::USER_EVENTS));
		$row = $table->fetchRow($table->select()->where('event_id = ?',$this->getId())->where('invitee_id = ?',$user_id));
		if($row)$row->delete();
		return;
	}
	public function getStatusStr()
	{
		//status string is different for upcoming and past event
		$tr = Zend_Registry::get('Zend_Translate');
		$status = $this->getStatus();
		if($status == Event::ATTENDING)
			return $tr->translate(PrecurioStrings::ATTENDINGEVENT);
		if($status == Event::NOTSURE)
			return $tr->translate(PrecurioStrings::UNSUREEVENT);
		if($status == Event::NOTATTENDING)
			return $tr->translate(PrecurioStrings::NOTATTENDINGEVENT);
		return $tr->translate("You did not attend this event");
	}
	/**
	 * Returns the attendance status of a user in the event.
	 * (0 - user has not indicated, 1 - user will not be attending, 2 - user is not sure, 3 - user is attending)
	 * @param $user_id (defaults to the session user)
	 * @return number
	 */
	private $_status = -1;
	public function getStatus($user_id = 0)
	{
		if(empty($user_id))$user_id = Precurio_Session::getCurrentUserId();
		if($this->_status == -1)
		{
			$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::EVENT_STATUS));
			$row = $table->fetchRow($table->select()->where('event_id = ?',$this->getId())
												->where('user_id = ?',$user_id));
			$this->_status = $row == null ? 0 : $row->status;
		}
		return $this->_status;

	}
	public function getUsersAttending()
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::USERS, 'rowClass'=>'User'));
		$select = $table->select();
		$select->setIntegrityCheck(false);
		$select->setTable($table);
		$select = $select
						->from(array('a' => PrecurioTableConstants::USERS))
						->join(array('b' => PrecurioTableConstants::EVENT_STATUS),'a.user_id = b.user_id',array('date_invitation_accepted'=>'date_created'))
						->where('b.event_id= ? ',$this->getId())
						->where('b.status= ? ',self::ATTENDING);

		$all = $table->fetchAll($select);
		return $all;
	}
	public function getUsersNotAttending()
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::USERS, 'rowClass'=>'User'));
		$select = $table->select();
		$select->setIntegrityCheck(false);
		$select->setTable($table);
		$select = $select
						->from(array('a' => PrecurioTableConstants::USERS))
						->join(array('b' => PrecurioTableConstants::EVENT_STATUS),'a.user_id = b.user_id',array('date_invitation_accepted'=>'date_created'))
						->where('b.event_id= ? ',$this->getId())
						->where('b.status= ? ',self::NOTATTENDING);

		$all = $table->fetchAll($select);
		return $all;
	}
	public function getUsersNotSure()
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::USERS, 'rowClass'=>'User'));
		$select = $table->select();
		$select->setIntegrityCheck(false);
		$select->setTable($table);
		$select = $select
						->from(array('a' => PrecurioTableConstants::USERS))
						->join(array('b' => PrecurioTableConstants::EVENT_STATUS),'a.user_id = b.user_id',array('date_invitation_accepted'=>'date_created'))
						->where('b.event_id= ? ',$this->getId())
						->where('b.status= ? ',self::NOTSURE);

		$all = $table->fetchAll($select);
		return $all;
	}

	public function userIsInvited($user_id)
	{
		if($this->is_open)return true;
		//else i.e not an open event
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::USER_EVENTS));
		$row = $table->fetchRow($table->select()->where('event_id = ?',$this->getId())->where('invitee_id = ?',$user_id));
		if($row)return true;
		//user is not in list
		return false;
	}
	/**
	 * Determines if a user can modify the event
	 * @param int $user_id
	 * @return boolean
	 */
	public function canModify($user_id)
	{
		return $this->user_id == $user_id || UserUtil::isAllowed("admin_index");
	}
	/**
	 * Determine if this user can invite other users
	 * @param int $user_id
	 * @return boolean
	 */
	public function canInvite($user_id)
	{
		return $this->user_id == $user_id;
	}
	/**
	 * Determines if the event is open/public.
	 * proxy to isPubic();
	 * @return boolean
	 */
	public function isOpen()
	{
		return $this->isPublic();
	}
	public function isOfficial()
	{
		return $this->work_related ? true : false;
	}
	/**
	 * Determines if a user can access the event
	 * @param int $user_id
	 * @return boolean
	 */
	public function canAccess($user_id)
	{
		if($this->isOpen())return true;
		if($this->user_id == $user_id)return true;
		if($this->userIsInvited($user_id))return true;
		return false;
	}
	public function getItemId()
	{
		return $this->getId();
	}
	public function getUsers()
	{
		if($this->isOpen())return array();

		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::USERS,'rowClass'=>'User'));
		$select = $table->select(false);
		$select->setIntegrityCheck(false);
		$select->setTable($table);

		$select = $select
		->from(array('a' => PrecurioTableConstants::USERS))
		->join(array('b' => PrecurioTableConstants::USER_EVENTS),'a.user_id = b.invitee_id',array('invitee_id'))
		->where('event_id = ?' ,$this->getId())
		->where('a.active = 1')
		->order('b.date_created asc');

		$rows = $table->fetchAll($select);
		//now we need to convert to array
		$result = array();foreach($rows as $row)$result[] = $row;

		return $result;
	}
	public function isActive()
	{
		return $this->active;
	}
	public function getUrl()
	{
		return getLocalizedString(self::VIEW_URL,$this->getId());
	}
	public function __toString()
	{
		return $this->getTitle();
	}
	public function getUser()
	{
		return UserUtil::getUser($this->getUserId());
	}
	public function getFolder()
	{
		return new EventFolder($this->getId());
	}
	public function getDateCreated()
	{
		$date = new Precurio_Date(trim($this->date_created));
		return $date->get(Precurio_Date::DATE_LONG);
	}
	/**
	 * Return event object whoose id is $event_id;s
	 * @param $event_id int
	 * @return Event
	 */
	public static function get($event_id)
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::USER_EVENTS, 'rowClass'=>'Event'));
		$select = $table->select();
		$select->setIntegrityCheck(false);
		$select->setTable($table);
		$select = $select
		->from(array('a' => PrecurioTableConstants::EVENT))
		->join(array('c' => PrecurioTableConstants::USERS),'a.user_id = c.user_id',array('first_name','last_name','profile_picture_id'))
		->where('a.id= ? ',$event_id);


		$event = $table->fetchRow($select);
		return $event;
	}
	public function getHost()
	{
		if(empty($this->host))return $this->getUser()->getFullName();
		return $this->host;
	}

	/**
	 * Exports the event as an iCal
	 * @return string
	 */
	public function export()
	{
		require_once( "others/iCalcreator.class.php" );
		$tz = date_default_timezone_get();
		$session_user_id = Precurio_Session::getCurrentUserId();
		$sessionUser = UserUtil::getUser($session_user_id);
		$u_id = $sessionUser->getUsername().'-event'.$this->getId();

		$user = $this->getUser();
		$organizer = $user->getFullName()." <".$user->getEmail().">";

		$config = Zend_Registry::get('config');
		$url = $config->base_url.$this->getUrl();

		$startArr = getdate($this->getDate(false)->getTimestamp());
		$endArr = getdate($this->getEndDate(false)->getTimestamp());

		$config = array( "unique_id" =>$u_id, "TZID"      => $tz );
		$v = new vcalendar( $config );                             // create a new calendar object instance

		$v->setProperty( "method", "PUBLISH" );                    // required of some calendar software
		//$v->setProperty( "x-wr-calname", "Precurio" );      // required of some calendar software
		//$v->setProperty( "X-WR-CALDESC", "Intranet Tasks and Events" ); // required of some calendar software
		$v->setProperty( "X-WR-TIMEZONE", $tz );                   // required of some calendar software

		$xprops = array( "X-LIC-LOCATION" => $tz );                // required of some calendar software
		iCalUtilityFunctions::createTimezone( $v, $tz, $xprops );  // create timezone component(-s) opt. 1
			                                                       // based on present date

		$vevent = & $v->newComponent( "vevent" );                  // create an event calendar component
		$vevent->setProperty( "dtstart", array( "year"  => $startArr['year']
				, "month" =>    $startArr['mon']
				, "day"   =>    $startArr['mday']
				, "hour"  =>    $startArr['hours']
				, "min"   =>    $startArr['minutes']
				, "sec"   =>    $startArr['seconds'] ));
		$vevent->setProperty( "dtend",   array( "year"  => $endArr['year']
				, "month" =>    $endArr['mon']
				, "day"   =>    $endArr['mday']
				, "hour"  =>    $endArr['hours']
				, "min"   =>    $endArr['minutes']
				, "sec"   =>    $endArr['seconds'] ));
		$vevent->setProperty( "LOCATION", $this->getVenue() );       // property name - case independent
		$vevent->setProperty( "summary", $this->getTitle() );
		$vevent->setProperty( "description", strip_tags($this->getDescription()) );
		$vevent->setProperty( "organizer", $organizer );
		$vevent->setProperty( "url",$url );


		$valarm = & $vevent->newComponent( "valarm" );             // create an event alarm
		$valarm->setProperty("action", "DISPLAY" );
		$valarm->setProperty("description", $vevent->getProperty( "description" ));

		$d = sprintf( '%04d%02d%02d %02d%02d%02d',  $startArr['year'], $startArr['mon'], ($startArr['mday']-1), $startArr['hours'], $startArr['minutes'], $startArr['seconds']);
		iCalUtilityFunctions::transformDateTime( $d, $tz, "UTC", "Ymd\THis\Z");
		$valarm->setProperty( "trigger", $d );                     // create alarm trigger (in UTC datetime)

		//echo $v->createCalendar();die('hekk');
		return $v->createCalendar();
	}

	public function index()
	{
		$index = Precurio_Search::getIndex();

		//first remove user from the index if it exists
		$hits = $index->find('id:' . $this->getId().' AND module:'.self::APPID);
		foreach ($hits as $hit)
			$index->delete($hit->id);
		$index->commit();

		if(!$this->isActive())return;

		$event = $this;

		//now create a new index document
		$doc = new Zend_Search_Lucene_Document();
		$doc->addField(Zend_Search_Lucene_Field::keyword('id',$event->getId()));
		$doc->addField(Zend_Search_Lucene_Field::keyword('user_id',$event->user_id));
		$doc->addField(Zend_Search_Lucene_Field::text('title',$event->getTitle()));
		$doc->addField(Zend_Search_Lucene_Field::text('host',$event->host));
		$doc->addField(Zend_Search_Lucene_Field::text('venue',$event->venue));
		$doc->addField(Zend_Search_Lucene_Field::text('location',$event->getLocation()));
		$doc->addField(Zend_Search_Lucene_Field::text('summary',$event->getSummary()));
		$doc->addField(Zend_Search_Lucene_Field::unStored('description',$event->description));
		$doc->addField(Zend_Search_Lucene_Field::unStored('comments',$this->getCommentsContent()));
		$doc->addField(Zend_Search_Lucene_Field::keyword('date',$event->getDate()));
		$doc->addField(Zend_Search_Lucene_Field::unIndexed('is_open',$event->is_open));
		$doc->addField(Zend_Search_Lucene_Field::keyword('url',$event->getUrl()));
		$doc->addField(Zend_Search_Lucene_Field::keyword('module',self::APPID));

		$index->addDocument($doc);
		return $index;
	}
	/**
	 * Gets all the comment as a string for search purpose
	 * @return string
	 */
	private function getCommentsContent()
	{
		$comments = Comment::getAll($this->getId(), self::APPID);
		$body = "";
		foreach($comments as $comment)
			$body = $body.' '.$comment->message;
		return $body;
	}
}

?>